/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport.imporT;

import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.Messages;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.importexport.ImportExportException;
import com.arcway.repository.interFace.importexport.imporT.IImportAgent;
import com.arcway.repository.interFace.importexport.imporT.IImportJobEditor;
import com.arcway.repository.interFace.importexport.imporT.IRepositoryMessageDisplay;
import com.arcway.repository.interFace.importexport.imporT.ImportInterpreter;
import com.arcway.repository.interFace.importexport.imporT.importjob.impl.ImportJob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ImportAgent
implements IImportAgent {
    private final IRepositoryInterfaceRO repositoryInterface;

    public ImportAgent(IRepositoryInterfaceRO repositoryInterface) {
        this.repositoryInterface = repositoryInterface;
    }

    @Override
    public void importRepositorySnippet(IRepositorySnippetRO repositorySnippet, IMessageSet interpretationMessages, List<IImportJobEditor> importJobEditors, IRepositoryMessageDisplay messageDisplay) throws ImportExportException {
        ImportInterpreter.checkImportability(repositorySnippet);
        IRepositorySnapshotRO repositorySnapshot = RepositoryInterfaces.openCurrentSnapshot(this.repositoryInterface);
        ImportJob importJob = null;
        try {
            try {
                importJob = ImportInterpreter.createInitialImportJob(repositorySnippet, interpretationMessages, this.repositoryInterface);
                boolean noConflicts = true;
                boolean abortImport = false;
                ArrayList<IImportJobEditor> activeImportJobEditors = new ArrayList<IImportJobEditor>(importJobEditors);
                do {
                    Iterator importJobEditorIterator = activeImportJobEditors.iterator();
                    while (importJobEditorIterator.hasNext()) {
                        IImportJobEditor importJobEditor = (IImportJobEditor)importJobEditorIterator.next();
                        IImportJobEditor.ResultCode resultCode = importJobEditor.editImportJob(importJob, repositorySnapshot, !noConflicts);
                        if (resultCode == IImportJobEditor.ResultCode.COMPLETED_NOMORECALLS) {
                            importJobEditorIterator.remove();
                            continue;
                        }
                        if (resultCode != IImportJobEditor.ResultCode.ABORTIMPORT) continue;
                        abortImport = true;
                        break;
                    }
                    if (abortImport) continue;
                    IMessageSet lockOrExecutionMessages = null;
                    Tuple<Boolean, IMessageSet> noConflictsAndMessages = importJob.isExecutable(repositorySnapshot);
                    noConflicts = (Boolean)noConflictsAndMessages.getT1();
                    if (!noConflicts) {
                        lockOrExecutionMessages = (IMessageSet)noConflictsAndMessages.getT2();
                    }
                    if (noConflicts) {
                        importJob.updateLocks(repositorySnapshot);
                        lockOrExecutionMessages = importJob.getLockMessages();
                        noConflicts = lockOrExecutionMessages.isEmpty();
                    }
                    if (noConflicts) {
                        lockOrExecutionMessages = importJob.execute(repositorySnapshot);
                        noConflicts = lockOrExecutionMessages.isEmpty();
                    }
                    if (noConflicts || messageDisplay == null) continue;
                    messageDisplay.displayRepositoryMessages(lockOrExecutionMessages);
                } while (!noConflicts && !abortImport && !activeImportJobEditors.isEmpty());
                if (!noConflicts && !abortImport) {
                    throw new ImportExportException(Messages.getString("ImportAgent.Error.NoMoreImportJobEditorsButStillConflicts.Message"));
                }
            }
            catch (EXNotReproducibleSnapshot eNRS) {
                throw new ImportExportException(Messages.getString("ImportAgent.Error.NotReproducibleSnapshot.Message"), eNRS);
            }
        }
        finally {
            repositorySnapshot.closeSnapshot();
            if (importJob != null) {
                importJob.dispose();
            }
        }
    }
}

