/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.importexport;

import com.arcway.lib.file.tmp.ITempFileProvider;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.repository.interFace.Messages;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategorySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryFile;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.importexport.FileArchiveSnippetFile;
import com.arcway.repository.interFace.importexport.IFileArchiveSnippetFile;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.importexport.ImportExportException;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RepositorySnippetForExport
implements IRepositorySnippetRO {
    private static final String MESSAGEKEY_ERROR_FILENOTACCESSIBLE = "FileArchiveSnippet.Error.FileNotAccessible";
    private final IRepositoryTypeManagerRO typeManager;
    private final ITempFileProvider temporaryFileProviderForFileProperties;
    private final List<RepositoryObjectSampleWithParentObjectReference> explicitObjects;
    private final List<RepositoryObjectSampleWithParentObjectReference> implicitObjects;
    private final HashMap_<IRepositoryObjectReference, IRepositoryObjectSample> contextObjects;
    private final ISetRW_<ICrossLinkRepositoryRelationSample> crossLinkRelations;
    private final ISetRW_<IOccurrenceRepositoryRelationSample> occurrenceRelations;
    private final IMapRW_<IRepositoryObjectTypeCategoryID, IRepositoryObjectTypeCategorySample> objectTypeCategories;
    private final IMapRW_<IRepositoryFileID, IFileArchiveSnippetFile> filesInArchiveMap = new HashMap_(IRepositoryFileID.IS_EQUAL_FILE_ID_HASHER);
    private final HashMap_<IRepositoryObjectReference, RepositoryObjectSampleWithParentObjectReference> explicitObjects_uniquenessCheck;
    private final HashMap_<IRepositoryObjectReference, RepositoryObjectSampleWithParentObjectReference> implicitObjects_uniquenessCheck;

    public RepositorySnippetForExport(IRepositoryTypeManagerRO typeManager, ITempFileProvider temporaryFileProviderForFileProperties) {
        this.typeManager = typeManager;
        this.temporaryFileProviderForFileProperties = temporaryFileProviderForFileProperties;
        this.explicitObjects = new ArrayList<RepositoryObjectSampleWithParentObjectReference>();
        this.implicitObjects = new ArrayList<RepositoryObjectSampleWithParentObjectReference>();
        this.crossLinkRelations = new HashSet_(ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        this.occurrenceRelations = new HashSet_(IOccurrenceRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        this.explicitObjects_uniquenessCheck = new HashMap_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        this.implicitObjects_uniquenessCheck = new HashMap_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        this.contextObjects = new HashMap_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        this.objectTypeCategories = new HashMap_(IRepositoryObjectTypeCategoryID.IS_EQUAL_OBJECT_TYPE_CATEGORY_ID_HASHER);
    }

    public final void addExplicitObject(RepositoryObjectSampleWithParentObjectReference explicitObjectWithParentReference) {
        IRepositoryObjectSample explicitObject = explicitObjectWithParentReference.getObjectSample();
        IRepositoryObjectReference explicitObjectReference = explicitObject.getObjectReference(this.typeManager);
        RepositoryObjectSampleWithParentObjectReference originalExplicitObject = (RepositoryObjectSampleWithParentObjectReference)this.explicitObjects_uniquenessCheck.getByKey((Object)explicitObjectReference);
        if (originalExplicitObject != null) {
            this.explicitObjects.remove(originalExplicitObject);
        } else {
            RepositoryObjectSampleWithParentObjectReference originalImplicitObject = (RepositoryObjectSampleWithParentObjectReference)this.implicitObjects_uniquenessCheck.removeAsValue((Object)explicitObjectReference);
            if (originalImplicitObject != null) {
                this.implicitObjects.remove(originalImplicitObject);
            } else {
                this.contextObjects.removeAsEntry((Object)explicitObjectReference);
            }
        }
        this.explicitObjects.add(explicitObjectWithParentReference);
        this.explicitObjects_uniquenessCheck.put((Object)explicitObjectReference, (Object)explicitObjectWithParentReference);
    }

    public final void addImplicitObject(RepositoryObjectSampleWithParentObjectReference implicitObjectWithParentReference) {
        IRepositoryObjectSample implicitObject = implicitObjectWithParentReference.getObjectSample();
        IRepositoryObjectReference implicitObjectReference = implicitObject.getObjectReference(this.typeManager);
        if (!this.explicitObjects_uniquenessCheck.containsKey((Object)implicitObjectReference)) {
            RepositoryObjectSampleWithParentObjectReference originalImplicitObject = (RepositoryObjectSampleWithParentObjectReference)this.implicitObjects_uniquenessCheck.removeAsValue((Object)implicitObjectReference);
            if (originalImplicitObject != null) {
                this.implicitObjects.remove(originalImplicitObject);
            } else {
                this.contextObjects.removeAsEntry((Object)implicitObjectReference);
            }
            this.implicitObjects.add(implicitObjectWithParentReference);
            this.implicitObjects_uniquenessCheck.put((Object)implicitObjectReference, (Object)implicitObjectWithParentReference);
        }
    }

    public final void addContextObject(IRepositoryObjectSample contextObject) {
        IRepositoryObjectReference contextObjectReference = contextObject.getObjectReference(this.typeManager);
        if (!(this.explicitObjects_uniquenessCheck.containsKey((Object)contextObjectReference) || this.implicitObjects_uniquenessCheck.containsKey((Object)contextObjectReference) || this.contextObjects.containsKey((Object)contextObjectReference))) {
            this.contextObjects.put((Object)contextObjectReference, (Object)contextObject);
        }
    }

    public final void addCrossLinkRelation(ICrossLinkRepositoryRelationSample relation) {
        this.crossLinkRelations.add((Object)relation);
    }

    public final void addOccurrenceRelation(IOccurrenceRepositoryRelationSample relation) {
        this.occurrenceRelations.add((Object)relation);
    }

    public final void addObjectTypeCategory(IRepositoryObjectTypeCategorySample category) {
        this.objectTypeCategories.put((Object)category.getObjectTypeCategoryID(), (Object)category);
    }

    public boolean containsObjectTypeCategory(IRepositoryObjectTypeCategoryID categoryID) {
        return this.objectTypeCategories.containsKey((Object)categoryID);
    }

    public final void addFile(IRepositoryFileID fileID, IRepositoryFile file) throws ImportExportException {
        try {
            if (!this.filesInArchiveMap.containsKey((Object)fileID)) {
                File tempFile = this.temporaryFileProviderForFileProperties.createTemporaryFile();
                DataCopyHelper.copyFile((InputStream)file.toInputStream(), (OutputStream)new FileOutputStream(tempFile));
                FileArchiveSnippetFile fileArchiveSnippetFile = new FileArchiveSnippetFile(fileID, file.getName(), file.getCreationDate(), file.getCreationSnapshotInformation(), tempFile);
                this.filesInArchiveMap.put((Object)fileID, (Object)fileArchiveSnippetFile);
            }
        }
        catch (EXNotReproducibleSnapshot eNRS) {
            throw new ImportExportException(Messages.getString(MESSAGEKEY_ERROR_FILENOTACCESSIBLE), eNRS);
        }
        catch (FileNotFoundException fNFE) {
            throw new ImportExportException(Messages.getString(MESSAGEKEY_ERROR_FILENOTACCESSIBLE), fNFE);
        }
        catch (JvmExternalResourceInteractionException jERIE) {
            throw new ImportExportException(Messages.getString(MESSAGEKEY_ERROR_FILENOTACCESSIBLE), jERIE);
        }
    }

    @Override
    public IList_<RepositoryObjectSampleWithParentObjectReference> getExplicitObjects() {
        return new ArrayList_(this.explicitObjects);
    }

    public boolean containsExplicitObject(IRepositoryObjectSample objectSample) {
        IRepositoryObjectReference objectReference = objectSample.getObjectReference(this.typeManager);
        return this.explicitObjects_uniquenessCheck.containsKey((Object)objectReference);
    }

    @Override
    public IList_<RepositoryObjectSampleWithParentObjectReference> getImplicitObjects() {
        return new ArrayList_(this.implicitObjects);
    }

    public boolean containsImplicitObject(IRepositoryObjectSample objectSample) {
        IRepositoryObjectReference objectReference = objectSample.getObjectReference(this.typeManager);
        return this.implicitObjects_uniquenessCheck.containsKey((Object)objectReference);
    }

    @Override
    public ICollection_<IRepositoryObjectSample> getContextObjects() {
        return this.contextObjects.values();
    }

    @Override
    public ICollection_<ICrossLinkRepositoryRelationSample> getCrossLinkRelations() {
        return this.crossLinkRelations;
    }

    @Override
    public ICollection_<IOccurrenceRepositoryRelationSample> getOccurrenceRelations() {
        return this.occurrenceRelations;
    }

    @Override
    public ICollection_<IRepositoryObjectTypeCategorySample> getObjectTypeCategories() {
        return this.objectTypeCategories.values();
    }

    @Override
    public ICollection_<IFileArchiveSnippetFile> getFiles() {
        return this.filesInArchiveMap.values();
    }
}

