/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.exceptions;

import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.math.Sgn;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.exceptions.IEXCrossLinkRelationContributionsRelated;
import com.arcway.repository.interFace.exceptions.IEXCrossLinkRelationRelated;
import com.arcway.repository.interFace.exceptions.IEXCrossLinkRelationRelatedWithContributionsOfSpecialType;
import com.arcway.repository.interFace.exceptions.IEXRepositoryObjectRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryObjectTypeCategoryRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryObjectsRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryPropertiesRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryPropertyRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryUnspecifiedRelated;
import com.arcway.repository.interFace.exceptions.IRelatedTypeCaseHandler;
import com.arcway.repository.interFace.exceptions.IRepositoryAccessException;
import com.arcway.repository.interFace.exceptions.RepositoryException;
import java.util.Arrays;
import java.util.List;

public abstract class RepositoryAccessException
extends RepositoryException
implements IRepositoryAccessException {
    public static final IHasher_<RepositoryAccessException> HASHER = new IHasher_<RepositoryAccessException>(){

        public boolean isEqual(RepositoryAccessException object1, RepositoryAccessException object2) {
            return COMPARATOR.sgn((Object)object1, (Object)object2) == 0;
        }

        public int getHashCode(RepositoryAccessException object) {
            return COMPARATOR.getHashCode((Object)object);
        }
    };
    public static final IComparator_<RepositoryAccessException> COMPARATOR = new IComparator_<RepositoryAccessException>(){

        public int sgn(RepositoryAccessException object1, RepositoryAccessException object2) {
            return object1.sgn(object2);
        }

        public int getHashCode(RepositoryAccessException object) {
            return object.getHashCode();
        }
    };
    public static final IHasher_<String[]> EQUAL_STRING_ARRAY_HASHER = new IHasher_<String[]>(){

        public int getHashCode(String[] object) {
            return Arrays.hashCode(object);
        }

        public boolean isEqual(String[] object1, String[] object2) {
            return Arrays.equals(object1, object2);
        }
    };
    private static long nextFreeID = 1L;
    private final long uniqueID = RepositoryAccessException.getNextID();
    private List<ComparePropertyWithHasher<?>> comparePropertyCache = null;
    private int hashCodeCache;

    private static synchronized long getNextID() {
        long thisID = nextFreeID++;
        return thisID;
    }

    protected RepositoryAccessException() {
    }

    protected RepositoryAccessException(String detailedMessage) {
        super(detailedMessage);
    }

    protected RepositoryAccessException(Throwable cause) {
        super(cause);
    }

    @Override
    public void switchRelatedType(IRelatedTypeCaseHandler caseHandler) {
        Class<? extends IEXRepositoryRelated> relatedType = this.getRelatedType();
        if (relatedType == IEXRepositoryObjectRelated.class) {
            caseHandler.caseObjectRelated((IEXRepositoryObjectRelated)((Object)this));
        } else if (relatedType == IEXRepositoryObjectsRelated.class) {
            caseHandler.caseObjectsRelated((IEXRepositoryObjectsRelated)((Object)this));
        } else if (relatedType == IEXRepositoryPropertyRelated.class) {
            caseHandler.casePropertyRelated((IEXRepositoryPropertyRelated)((Object)this));
        } else if (relatedType == IEXRepositoryPropertiesRelated.class) {
            caseHandler.casePropertiesRelated((IEXRepositoryPropertiesRelated)((Object)this));
        } else if (relatedType == IEXRepositoryObjectTypeCategoryRelated.class) {
            caseHandler.caseObjectTypeCategoryRelated((IEXRepositoryObjectTypeCategoryRelated)((Object)this));
        } else if (relatedType == IEXCrossLinkRelationRelated.class) {
            caseHandler.caseCrossLinkRelationRelated((IEXCrossLinkRelationRelated)((Object)this));
        } else if (relatedType == IEXCrossLinkRelationRelatedWithContributionsOfSpecialType.class) {
            caseHandler.caseCrossLinkRelationRelatedWithContributionsOfSpecialType((IEXCrossLinkRelationRelatedWithContributionsOfSpecialType)((Object)this));
        } else if (relatedType == IEXCrossLinkRelationContributionsRelated.class) {
            caseHandler.caseCrossLinkRelationContributionsRelated((IEXCrossLinkRelationContributionsRelated)((Object)this));
        } else if (relatedType == IEXRepositoryUnspecifiedRelated.class) {
            caseHandler.caseUnspecified();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private int sgn(RepositoryAccessException object2) {
        int sgn = IRepositoryAccessException.NATURAL_EXCEPTION_LEVEL_COMPARATOR.sgn((Object)this.getExceptionLevel(), (Object)object2.getExceptionLevel());
        if (sgn == 0 && (sgn = IRepositoryAccessException.NATURAL_EXCEPTION_CATEGORY_COMPARATOR.sgn((Object)this.getExceptionCategory(), (Object)object2.getExceptionCategory())) == 0) {
            boolean exceptionsAreEqual;
            boolean bl = exceptionsAreEqual = this.getClass().equals(object2.getClass()) && this.isExceptionOfSameTypeEqual(object2);
            if (!exceptionsAreEqual) {
                sgn = Sgn.sgn((long)(this.uniqueID - object2.uniqueID));
            }
        }
        return sgn;
    }

    private int getHashCode() {
        this.fillCachedProperties();
        return this.hashCodeCache;
    }

    private boolean isExceptionOfSameTypeEqual(RepositoryAccessException exeptionOfEqualType) {
        this.fillCachedProperties();
        exeptionOfEqualType.fillCachedProperties();
        return this.calculateIsEqual(this.comparePropertyCache, exeptionOfEqualType.comparePropertyCache);
    }

    private synchronized void fillCachedProperties() {
        if (this.comparePropertyCache == null) {
            this.comparePropertyCache = this.getCompareProperties();
            this.hashCodeCache = this.calculateHashCode(this.comparePropertyCache);
        }
    }

    private int calculateHashCode(List<ComparePropertyWithHasher<?>> properties) {
        int hashCode = 0;
        for (ComparePropertyWithHasher<?> propertyWithHasher : properties) {
            Object property = propertyWithHasher.getT1();
            if (property == null) continue;
            IHasher_ hasher = (IHasher_)propertyWithHasher.getT2();
            hashCode ^= hasher.getHashCode(property);
        }
        return hashCode;
    }

    private boolean calculateIsEqual(List<ComparePropertyWithHasher<?>> properties1, List<ComparePropertyWithHasher<?>> properties2) {
        boolean isEqual = true;
        assert (properties1.size() == properties2.size());
        int i = 0;
        while (isEqual && i < properties1.size()) {
            ComparePropertyWithHasher<?> propertyWithHasher1 = properties1.get(i);
            ComparePropertyWithHasher<?> propertyWithHasher2 = properties2.get(i);
            Object property1 = propertyWithHasher1.getT1();
            Object property2 = propertyWithHasher2.getT1();
            IHasher_ hasher = (IHasher_)propertyWithHasher1.getT2();
            isEqual &= hasher.isEqual(property1, property2);
            ++i;
        }
        return isEqual;
    }

    protected abstract List<ComparePropertyWithHasher<?>> getCompareProperties();

    protected class ComparePropertyWithHasher<T>
    extends Tuple<T, IHasher_<? super T>> {
        public ComparePropertyWithHasher(T property, IHasher_<? super T> hasher) {
            super(property, hasher);
        }
    }
}

