/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.exceptions;

import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollectionRW_;
import com.arcway.lib.java.collections.ISortedSetRW_;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.java.collections.SortedSet_;
import com.arcway.lib.java.maps.ISortedMapRW_;
import com.arcway.lib.java.maps.ISortedMap_;
import com.arcway.lib.java.maps.SortedMap_;
import com.arcway.repository.interFace.exceptions.ExceptionCategory;
import com.arcway.repository.interFace.exceptions.ExceptionLevel;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.IRepositoryAccessException;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;

public class MessageSet
implements IMessageSet {
    private final ICollectionRW_<RepositoryAccessException> undispatchedMessages = new ArrayList_();
    private ExceptionLevel highestLevel = null;
    private boolean uniqueLevelPossible = true;
    private ExceptionLevel uniqueLevel = null;
    private boolean uniqueCategoryPossible = true;
    private ExceptionCategory uniqueCategory = null;
    private final ISortedSetRW_<RepositoryAccessException> allMessages = new SortedSet_(RepositoryAccessException.COMPARATOR);
    private final ISortedMapRW_<ExceptionLevel, ISortedMapRW_<ExceptionCategory, ISortedSetRW_<RepositoryAccessException>>> level2category2messages = new SortedMap_(IRepositoryAccessException.NATURAL_EXCEPTION_LEVEL_COMPARATOR);

    public void add(RepositoryAccessException messageToAdd) {
        this.undispatchedMessages.add((Object)messageToAdd);
    }

    public void addAll(IMessageSet messagesToAdd) {
        if (messagesToAdd instanceof MessageSet) {
            MessageSet messagesTpAddTyped = (MessageSet)messagesToAdd;
            this.undispatchedMessages.addAll(messagesTpAddTyped.undispatchedMessages);
            this.undispatchedMessages.addAll(messagesTpAddTyped.allMessages);
        } else {
            this.undispatchedMessages.addAll(messagesToAdd.getMessages());
        }
    }

    public void clear() {
        this.undispatchedMessages.clear();
        this.highestLevel = null;
        this.uniqueLevelPossible = true;
        this.uniqueLevel = null;
        this.uniqueCategoryPossible = true;
        this.uniqueCategory = null;
        this.allMessages.clear();
        this.level2category2messages.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.undispatchedMessages.isEmpty() && this.allMessages.isEmpty();
    }

    @Override
    public int getSizeHint() {
        return this.undispatchedMessages.size() + this.allMessages.size();
    }

    @Override
    public ISortedSet_<RepositoryAccessException> getMessages() {
        this.dispatch();
        return this.allMessages;
    }

    @Override
    public ISortedMap_<ExceptionLevel, ? extends ISortedMap_<ExceptionCategory, ? extends ISortedSet_<RepositoryAccessException>>> getCategorized() {
        this.dispatch();
        return this.level2category2messages;
    }

    private void dispatch() {
        for (RepositoryAccessException messageToDispatch : this.undispatchedMessages) {
            ISortedSetRW_ categoryRelatedMessages;
            ISortedMapRW_ levelRelatedMessages;
            this.allMessages.add((Object)messageToDispatch);
            ExceptionLevel level = messageToDispatch.getExceptionLevel();
            if (this.highestLevel == null || level.compareTo(this.highestLevel) < 0) {
                this.highestLevel = level;
            }
            if (this.uniqueLevelPossible) {
                if (this.uniqueLevel == null) {
                    this.uniqueLevel = level;
                } else if (this.uniqueLevel != level) {
                    this.uniqueLevel = null;
                    this.uniqueLevelPossible = false;
                }
            }
            if ((levelRelatedMessages = (ISortedMapRW_)this.level2category2messages.getByKey((Object)level)) == null) {
                levelRelatedMessages = new SortedMap_(IRepositoryAccessException.NATURAL_EXCEPTION_CATEGORY_COMPARATOR);
                this.level2category2messages.put((Object)level, (Object)levelRelatedMessages);
            }
            ExceptionCategory category = messageToDispatch.getExceptionCategory();
            if (this.uniqueCategoryPossible) {
                if (this.uniqueCategory == null) {
                    this.uniqueCategory = category;
                } else if (this.uniqueCategory != category) {
                    this.uniqueCategory = null;
                    this.uniqueCategoryPossible = false;
                }
            }
            if ((categoryRelatedMessages = (ISortedSetRW_)levelRelatedMessages.getByKey((Object)category)) == null) {
                categoryRelatedMessages = new SortedSet_(RepositoryAccessException.COMPARATOR);
                levelRelatedMessages.put((Object)category, (Object)categoryRelatedMessages);
            }
            categoryRelatedMessages.add((Object)messageToDispatch);
        }
        this.undispatchedMessages.clear();
    }

    @Override
    public ExceptionLevel getHighestLevel() {
        this.dispatch();
        return this.highestLevel;
    }

    @Override
    public ExceptionCategory getUniqueCategory() {
        this.dispatch();
        return this.uniqueCategory;
    }

    @Override
    public ExceptionLevel getUniqueLevel() {
        this.dispatch();
        return this.uniqueLevel;
    }
}

