/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.declaration.data.key;

import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IListIterator_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.stringtools.StringCanonicalizer;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;

public class KeyPath
implements IKey {
    public static final IHasher_<KeyPath> IS_EQUAL_KEYPATH_HASHER = new IHasher_<KeyPath>(){

        public boolean isEqual(KeyPath keyPath1, KeyPath keyPath2) {
            return keyPath1.toCanonicalString().equals(keyPath2.toCanonicalString());
        }

        public int getHashCode(KeyPath keyPath) {
            return keyPath.hashCodeForCanonicalString();
        }
    };
    private final IList_<KeySegment> keySegmentList;
    private final String canonicalPathStringCache;
    private final int canonicalPathStringHashCodeCache;

    public KeyPath(String keyPathString) {
        assert (Assert.checkArgumentBeeingNotNull((Object)keyPathString));
        assert (Assert.checkStringToBeNotEmpty((String)keyPathString));
        assert (Assert.checkStringToContainNoInvalidCharacters((String)keyPathString.substring(0, 1), (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-"));
        assert (Assert.checkStringToContainNoInvalidCharacters((String)keyPathString.substring(1), (String)ALLOWED_CHARACTERS_FOLLOWINGCHARS));
        this.keySegmentList = KeyPath.pathStringToKeySegmentList(keyPathString);
        String pathString = KeyPath.calculatePathStringFromKeySegmentList(this.keySegmentList);
        this.canonicalPathStringCache = StringCanonicalizer.getSystemWideCanonicalString((String)pathString);
        this.canonicalPathStringHashCodeCache = this.canonicalPathStringCache.hashCode();
    }

    public KeyPath(KeyPath keyPathToExtend, KeySegment keySegmentToAppend) {
        Assert.checkArgumentBeeingNotNull((Object)keyPathToExtend);
        Assert.checkArgumentBeeingNotNull((Object)keySegmentToAppend);
        this.keySegmentList = KeyPath.appendKeySegment(keyPathToExtend.keySegmentList, keySegmentToAppend);
        String pathString = String.valueOf(keyPathToExtend.canonicalPathStringCache) + KEY_SPERARTOR + keySegmentToAppend.toKeyString();
        this.canonicalPathStringCache = StringCanonicalizer.getSystemWideCanonicalString((String)pathString);
        this.canonicalPathStringHashCodeCache = this.canonicalPathStringCache.hashCode();
    }

    public KeyPath(KeyPath keyPathToExtend, KeyPath keyPathToAppend) {
        Assert.checkArgumentBeeingNotNull((Object)keyPathToExtend);
        Assert.checkArgumentBeeingNotNull((Object)keyPathToAppend);
        this.keySegmentList = KeyPath.concatKeySegmentLists(keyPathToExtend.keySegmentList, keyPathToAppend.keySegmentList);
        String pathString = String.valueOf(keyPathToExtend.canonicalPathStringCache) + KEY_SPERARTOR + keyPathToAppend.canonicalPathStringCache;
        this.canonicalPathStringCache = StringCanonicalizer.getSystemWideCanonicalString((String)pathString);
        this.canonicalPathStringHashCodeCache = this.canonicalPathStringCache.hashCode();
    }

    public KeyPath(IList_<KeySegment> p_keySegmentList) {
        Assert.checkArgumentBeeingNotNull(p_keySegmentList);
        Assert.checkCollectionToBeNotEmpty(p_keySegmentList);
        this.keySegmentList = new ArrayList_(p_keySegmentList);
        String pathString = KeyPath.calculatePathStringFromKeySegmentList(this.keySegmentList);
        this.canonicalPathStringCache = StringCanonicalizer.getSystemWideCanonicalString((String)pathString);
        this.canonicalPathStringHashCodeCache = this.canonicalPathStringCache.hashCode();
    }

    public KeyPath() {
        this.keySegmentList = new ArrayList_();
        String pathString = KeyPath.calculatePathStringFromKeySegmentList(this.keySegmentList);
        this.canonicalPathStringCache = StringCanonicalizer.getSystemWideCanonicalString((String)pathString);
        this.canonicalPathStringHashCodeCache = this.canonicalPathStringCache.hashCode();
    }

    public final IList_<KeySegment> getKeySegmentList() {
        return this.keySegmentList;
    }

    private static IList_<KeySegment> pathStringToKeySegmentList(String keyPathString) {
        ArrayList_ newKeySegmentList = new ArrayList_();
        StringBuffer workingPathString = new StringBuffer(keyPathString);
        int pos = workingPathString.indexOf(KEY_SPERARTOR);
        while (pos >= 0) {
            String keyString = workingPathString.substring(0, pos);
            newKeySegmentList.add((Object)new KeySegment(keyString));
            workingPathString.delete(0, pos + KEY_SPERARTOR.length());
            pos = workingPathString.indexOf(KEY_SPERARTOR);
        }
        newKeySegmentList.add((Object)new KeySegment(workingPathString.toString()));
        return newKeySegmentList;
    }

    private static IList_<KeySegment> appendKeySegment(IList_<KeySegment> keySegmentListToExtend, KeySegment keySegmentToAppend) {
        ArrayList_ newKeyList = new ArrayList_(keySegmentListToExtend);
        newKeyList.add((Object)keySegmentToAppend);
        return newKeyList;
    }

    private static IList_<KeySegment> concatKeySegmentLists(IList_<KeySegment> keySegmentListToExtend, IList_<KeySegment> keySegmentListToAppend) {
        ArrayList_ newKeyList = new ArrayList_(keySegmentListToExtend);
        newKeyList.addAll(keySegmentListToAppend);
        return newKeyList;
    }

    public final int hashCodeForCanonicalString() {
        return this.canonicalPathStringHashCodeCache;
    }

    private static String calculatePathStringFromKeySegmentList(IList_<KeySegment> segmentList) {
        StringBuffer pathString = new StringBuffer();
        IListIterator_ i = segmentList.iterator();
        if (i.hasNext()) {
            KeySegment currentKey = (KeySegment)i.next();
            pathString.append(currentKey.toKeyString());
        }
        while (i.hasNext()) {
            KeySegment currentKeySegment = (KeySegment)i.next();
            pathString.append(KEY_SPERARTOR);
            pathString.append(currentKeySegment.toKeyString());
        }
        return pathString.toString();
    }

    public String toCanonicalString() {
        return this.canonicalPathStringCache;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.canonicalPathStringCache + ")";
    }
}

