/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions;

import com.arcway.lib.java.Equals;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.IEXLockDenied;
import com.arcway.repository.interFace.exceptions.ExceptionCategory;
import com.arcway.repository.interFace.exceptions.ExceptionLevel;
import com.arcway.repository.interFace.exceptions.IEXRepositoryRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryUnspecifiedRelated;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractEXLockDenied
extends RepositoryAccessException
implements IEXLockDenied {
    private final ISet_<ConflictingLockInformation> conflictingLockInformation;
    private final String[] localizedOtherReasons;
    private List<RepositoryAccessException.ComparePropertyWithHasher<?>> compareProperties;

    protected AbstractEXLockDenied(ISet_<ConflictingLockInformation> conflictingLockInformation) {
        this.conflictingLockInformation = conflictingLockInformation;
        this.localizedOtherReasons = null;
    }

    protected AbstractEXLockDenied(String[] localizedOtherReasons) {
        this.localizedOtherReasons = localizedOtherReasons;
        this.conflictingLockInformation = null;
    }

    @Override
    public ISet_<ConflictingLockInformation> getConflictingLockInformation() {
        return this.conflictingLockInformation;
    }

    @Override
    public String[] getLocalizedOtherReasons() {
        return this.localizedOtherReasons;
    }

    @Override
    public ExceptionLevel getExceptionLevel() {
        return ExceptionLevel.EXCEPTION;
    }

    @Override
    public ExceptionCategory getExceptionCategory() {
        return ExceptionCategory.LOCK_DENIED;
    }

    @Override
    public Class<? extends IEXRepositoryRelated> getRelatedType() {
        return IEXRepositoryUnspecifiedRelated.class;
    }

    @Override
    protected List<RepositoryAccessException.ComparePropertyWithHasher<?>> getCompareProperties() {
        if (this.compareProperties == null) {
            this.compareProperties = new ArrayList();
            if (this.conflictingLockInformation != null) {
                this.compareProperties.add(new RepositoryAccessException.ComparePropertyWithHasher<ISet_<ConflictingLockInformation>>(this, this.conflictingLockInformation, ConflictingLockInformation.EQUAL_LOCK_INFORMATION_SET_HASHER));
            }
            this.compareProperties.add(new RepositoryAccessException.ComparePropertyWithHasher<String[]>(this, this.localizedOtherReasons, RepositoryAccessException.EQUAL_STRING_ARRAY_HASHER));
            this.addSubclassCompareProperties(this.compareProperties);
        }
        return this.compareProperties;
    }

    protected abstract void addSubclassCompareProperties(List<RepositoryAccessException.ComparePropertyWithHasher<?>> var1);

    public static class ConflictingLockInformation {
        public static final IHasher_<? super ConflictingLockInformation> EQUAL_LOCK_INFORMATION_HASHER = IHasher_.EQUALS_HASHER;
        public static final IHasher_<ISet_<ConflictingLockInformation>> EQUAL_LOCK_INFORMATION_SET_HASHER = new IHasher_<ISet_<ConflictingLockInformation>>(){

            public boolean isEqual(ISet_<ConflictingLockInformation> object1, ISet_<ConflictingLockInformation> object2) {
                if (object1 == object2) {
                    return true;
                }
                if (object1.size() != object2.size()) {
                    return false;
                }
                return object1.containsAll(object2);
            }

            public int getHashCode(ISet_<ConflictingLockInformation> object) {
                int hash = 0;
                for (ConflictingLockInformation lockInformation : object) {
                    hash ^= lockInformation.hashCode();
                }
                return hash;
            }
        };
        private final String userName;
        private final String clientName;
        private final String localizedLockType;
        private final String detail;

        public ConflictingLockInformation(String userName, String clientName, String localizedLockType, String detail) {
            this.userName = userName;
            this.clientName = clientName;
            this.localizedLockType = localizedLockType;
            this.detail = detail;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getClientName() {
            return this.clientName;
        }

        public String getLocalizedLockType() {
            return this.localizedLockType;
        }

        public String getDetail() {
            return this.detail;
        }

        public int hashCode() {
            int hashCode = this.userName.hashCode();
            hashCode ^= this.clientName.hashCode();
            hashCode ^= this.localizedLockType.hashCode();
            if (this.detail != null) {
                hashCode ^= this.detail.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            ConflictingLockInformation cLockInfo;
            boolean equals = false;
            if (obj instanceof ConflictingLockInformation && (cLockInfo = (ConflictingLockInformation)obj).getUserName().equals(this.userName) && cLockInfo.getClientName().equals(this.clientName) && cLockInfo.getLocalizedLockType().equals(this.localizedLockType) && Equals.equals((Object)cLockInfo.getDetail(), (Object)this.detail)) {
                equals = true;
            }
            return equals;
        }
    }
}

