/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.dataaccess;

import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import java.util.ArrayList;
import java.util.List;

public class UniquePropertiesStore {
    private final IMapRW_<NameSpace, Tuple<Boolean, List<UniquePropertiesStoreEntry>>> nameSpace2NameProperties;
    private final IMapRW_<IRepositoryObjectTypeID, List<UniquePropertiesStoreEntry>> typeID2IDProperties = new HashMap_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);

    public UniquePropertiesStore() {
        this.nameSpace2NameProperties = new HashMap_(NameSpace.HASHER);
    }

    public void addNameProperty(IRepositoryPropertySample namePropertySample, IRepositoryPropertyType propertyType, IRepositoryObjectReference parent, boolean parentIsNew, IRepositoryObjectReference relatedObject, int propertyOperation) {
        UniquePropertiesStoreEntry nameProperty = new UniquePropertiesStoreEntry(namePropertySample, propertyType, relatedObject, propertyOperation);
        NameSpace nameSpace = new NameSpace(parent, propertyType);
        Tuple parentStateAndNamePropertiesToCheck = (Tuple)this.nameSpace2NameProperties.getByKey((Object)nameSpace);
        if (parentStateAndNamePropertiesToCheck == null) {
            ArrayList namePropertiesToCheck = new ArrayList();
            parentStateAndNamePropertiesToCheck = new Tuple((Object)parentIsNew, namePropertiesToCheck);
            this.nameSpace2NameProperties.put((Object)nameSpace, (Object)parentStateAndNamePropertiesToCheck);
        }
        ((List)parentStateAndNamePropertiesToCheck.getT2()).add(nameProperty);
    }

    public void addIDProperty(IRepositoryPropertySample idPropertySample, IRepositoryPropertyType propertyType, IRepositoryObjectTypeID objectTypeID, IRepositoryObjectReference relatedObject, int propertyOperation) {
        UniquePropertiesStoreEntry idProperty = new UniquePropertiesStoreEntry(idPropertySample, propertyType, relatedObject, propertyOperation);
        ArrayList<UniquePropertiesStoreEntry> idPropertiesToCheck = (ArrayList<UniquePropertiesStoreEntry>)this.typeID2IDProperties.getByKey((Object)objectTypeID);
        if (idPropertiesToCheck == null) {
            idPropertiesToCheck = new ArrayList<UniquePropertiesStoreEntry>();
            this.typeID2IDProperties.put((Object)objectTypeID, idPropertiesToCheck);
        }
        idPropertiesToCheck.add(idProperty);
    }

    public IMapRW_<NameSpace, Tuple<Boolean, List<UniquePropertiesStoreEntry>>> getNameSpace2NameProperties() {
        return this.nameSpace2NameProperties;
    }

    public IMapRW_<IRepositoryObjectTypeID, List<UniquePropertiesStoreEntry>> getTypeID2IDProperties() {
        return this.typeID2IDProperties;
    }

    public static class NameSpace {
        public static final IHasher_<NameSpace> HASHER = new IHasher_<NameSpace>(){

            public boolean isEqual(NameSpace nameParentKey1, NameSpace nameParentKey2) {
                return nameParentKey1.getChildNamePropertyType() == nameParentKey2.getChildNamePropertyType() && IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER.isEqual((Object)nameParentKey1.getParentObjectReference(), (Object)nameParentKey2.getParentObjectReference());
            }

            public int getHashCode(NameSpace nameParentKey) {
                int hash = IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER.getHashCode((Object)nameParentKey.getParentObjectReference());
                return hash ^= System.identityHashCode(nameParentKey.getChildNamePropertyType());
            }
        };
        private final IRepositoryObjectReference parentObjectReference;
        private final IRepositoryPropertyType childNamePropertyType;

        public NameSpace(IRepositoryObjectReference parentObjectReference, IRepositoryPropertyType childNamePropertyType) {
            this.parentObjectReference = parentObjectReference;
            this.childNamePropertyType = childNamePropertyType;
        }

        public IRepositoryObjectReference getParentObjectReference() {
            return this.parentObjectReference;
        }

        public IRepositoryPropertyType getChildNamePropertyType() {
            return this.childNamePropertyType;
        }
    }

    public class UniquePropertiesStoreEntry {
        public static final int ADD_PROPERTY = 1;
        public static final int MODIFIY_PROPERTY = 2;
        private final IRepositoryPropertySample propertySample;
        private final IRepositoryPropertyType propertyType;
        private final IRepositoryObjectReference object;
        private final int propertyOperation;

        private UniquePropertiesStoreEntry(IRepositoryPropertySample propertySample, IRepositoryPropertyType propertyType, IRepositoryObjectReference object, int propertyOperation) {
            this.propertySample = propertySample;
            this.propertyType = propertyType;
            this.object = object;
            this.propertyOperation = propertyOperation;
        }

        public IRepositoryPropertySample getPropertySample() {
            return this.propertySample;
        }

        public IRepositoryPropertyType getPropertyType() {
            return this.propertyType;
        }

        public IRepositoryObjectReference getObject() {
            return this.object;
        }

        public int getPropertyOperation() {
            return this.propertyOperation;
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }

        public final int hashCode() {
            return super.hashCode();
        }
    }
}

