/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.dataaccess;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;

public final class RepositoryFileState {
    public static final RepositoryFileState IS_TEMPORARY = new RepositoryFileState("temporary");
    public static final RepositoryFileState IS_LOCAL = new RepositoryFileState("local");
    public static final RepositoryFileState IS_GLOBAL = new RepositoryFileState("global");
    private final String name;

    private RepositoryFileState(String name) {
        Assert.checkArgumentBeeingNotNull((Object)name);
        this.name = name;
    }

    public String toString() {
        return String.valueOf(To.string((Object)this)) + " (" + this.name + ")";
    }

    public boolean isTemporary() {
        return this == IS_TEMPORARY;
    }

    public boolean isLocal() {
        return this == IS_LOCAL;
    }

    public boolean isGlobal() {
        return this == IS_GLOBAL;
    }

    public static abstract class Switch {
        public Switch(RepositoryFileState selector) throws Exception {
            if (selector == IS_TEMPORARY) {
                this.caseIsTemporary();
            } else if (selector == IS_LOCAL) {
                this.caseIsLocal();
            } else if (selector == IS_GLOBAL) {
                this.caseIsGlobal();
            } else {
                Assert.illegalArgument();
            }
        }

        public abstract void caseIsTemporary() throws Exception;

        public abstract void caseIsLocal() throws Exception;

        public abstract void caseIsGlobal() throws Exception;
    }
}

