/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data.lock;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;

public final class RepositoryIDLockType {
    public static final RepositoryIDLockType FINGER = new RepositoryIDLockType("finger");
    public static final RepositoryIDLockType ALLOCATE = new RepositoryIDLockType("allocate");
    public static final RepositoryIDLockType RELEASE = new RepositoryIDLockType("release");
    private final String name;

    private RepositoryIDLockType(String name) {
        Assert.checkArgumentBeeingNotNull((Object)name);
        this.name = name;
    }

    public String toString() {
        return String.valueOf(To.string((Object)this)) + " (" + this.name + ")";
    }

    public boolean finger() {
        return this == FINGER;
    }

    public boolean release() {
        return this == RELEASE;
    }

    public boolean allocate() {
        return this == ALLOCATE;
    }

    public static abstract class Switch {
        public Switch(RepositoryIDLockType conflictType) throws Exception {
            if (conflictType == FINGER) {
                this.caseFinger();
            } else if (conflictType == ALLOCATE) {
                this.caseAllocate();
            } else if (conflictType == RELEASE) {
                this.caseRelease();
            } else {
                Assert.illegalArgument();
            }
        }

        public abstract void caseFinger() throws Exception;

        public abstract void caseAllocate() throws Exception;

        public abstract void caseRelease() throws Exception;
    }
}

