/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data.lock;

import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;

public abstract class AbstractRepositoryIDLockSample
extends AbstractRepositoryLockSample {
    public abstract IRepositoryObjectTypeID getContextObjectTypeID();

    public abstract IRepositoryPropertySetSample getContextObjectID();

    public abstract IRepositoryObjectTypeID getObjectTypeID();

    public abstract IRepositoryPropertyTypeID getPropertyTypeID();

    public abstract IRepositoryPropertySample getID();

    @Override
    public boolean isEqualTo(AbstractRepositoryLockSample sample) {
        if (this == sample) {
            return true;
        }
        if (sample == null) {
            return false;
        }
        if (!(sample instanceof AbstractRepositoryIDLockSample)) {
            return false;
        }
        AbstractRepositoryIDLockSample other = (AbstractRepositoryIDLockSample)sample;
        assert (this.getObjectTypeID() != null && this.getContextObjectID() != null && this.getContextObjectTypeID() != null && this.getID() != null && this.getPropertyTypeID() != null);
        assert (other.getObjectTypeID() != null && other.getContextObjectID() != null && other.getContextObjectTypeID() != null && other.getID() != null && other.getPropertyTypeID() != null);
        if (IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)this.getObjectTypeID(), (Object)other.getObjectTypeID()) && IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)this.getContextObjectTypeID(), (Object)other.getContextObjectTypeID()) && RepositorySamples.isEqual(this.getContextObjectID(), other.getContextObjectID()) && IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER.isEqual((Object)this.getPropertyTypeID(), (Object)other.getPropertyTypeID()) && RepositorySamples.isEqual(this.getID(), other.getID())) {
            if (this.getBasedSnapshotID() == null) {
                return other.getBasedSnapshotID() == null;
            }
            return RepositorySamples.isEqual(this.getBasedSnapshotID(), other.getBasedSnapshotID());
        }
        return false;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("RepositoryIDLockSample: ");
        str.append("{context object type id=");
        str.append(this.getContextObjectTypeID());
        str.append(", context object id=");
        str.append(this.getContextObjectID());
        str.append(", object type id=");
        str.append(this.getObjectTypeID());
        str.append(", property type id=");
        str.append(this.getPropertyTypeID());
        str.append(", id=");
        str.append(this.getID());
        str.append(", based snapshot id=");
        str.append(this.getBasedSnapshotID());
        str.append('}');
        return str.toString();
    }

    @Override
    public boolean isCurrent(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        IRepositoryObjectType objectType = snapshot.getRepositoryInterface().getTypeManager().getObjectType(this.getObjectTypeID());
        IRepositoryAttributeSetType attributeSetType = objectType.getAttributeSetType(this.getPropertyTypeID());
        IRepositoryPropertyType propertyType = attributeSetType.getPropertyType(this.getPropertyTypeID());
        IRepositoryObjectType contextObjectType = snapshot.getRepositoryInterface().getTypeManager().getObjectType(this.getContextObjectTypeID());
        IRepositoryObject contextObject = snapshot.findRepositoryObject(contextObjectType, this.getContextObjectID());
        boolean isCurrent = contextObject == null ? false : RepositorySamples.isEqual(this.getBasedSnapshotID(), contextObject.getSnapshotIDOfLastIDModification(propertyType, this.getID()));
        return isCurrent;
    }
}

