/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.maps.SortedMap_;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IAbstractRepositoryRelationContributionType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRelationSampleCannotBeOfType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectSampleCannotBeOfType;
import com.arcway.repository.interFace.transactions.exceptions.EXPropertySampleCannotBeOfType;
import com.arcway.repository.interFace.transactions.exceptions.EXPropertySetSampleCannotBeOfType;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReferenceWithIDDefiningObjectTypeID;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySetSample;

public class RepositorySamples {
    public static boolean isEqual(IRepositoryData data1, IRepositoryData data2) {
        assert (data1 != null && data2 != null);
        IRepositoryDataType dataType1 = data1.getDataType();
        IRepositoryDataType dataType2 = data2.getDataType();
        Assert.checkArgument((boolean)dataType1.equals(dataType2));
        IRepositoryDataType dataType = dataType1;
        IRepositoryDataEqualComparator dataEqualComparator = dataType.getEqualComparator();
        Assert.checkArgumentBeeingNotNull((Object)dataEqualComparator);
        boolean isEqual = dataEqualComparator.isEqual(data1, data2);
        return isEqual;
    }

    public static boolean isEqual(IRepositoryPropertySample property1, IRepositoryPropertySample property2) {
        assert (property1 != null && property2 != null);
        return RepositorySamples.isEqual(property1.getValue(), property2.getValue());
    }

    public static boolean isEqual(IRepositoryPropertySetSample attributeSet1, IRepositoryPropertySetSample attributeSet2) {
        if (attributeSet1 == null || attributeSet2 == null) {
            return attributeSet1 == null && attributeSet2 == null;
        }
        ISet_<IRepositoryPropertyTypeID> attributeSet1propertyTypeIDs = attributeSet1.getPropertyTypeIDs();
        ISet_<IRepositoryPropertyTypeID> attributeSet2propertyTypeIDs = attributeSet2.getPropertyTypeIDs();
        Assert.checkArgument((attributeSet1propertyTypeIDs.size() == attributeSet2propertyTypeIDs.size() ? 1 : 0) != 0);
        ISet_<IRepositoryPropertyTypeID> propertyTypeIDs = attributeSet1propertyTypeIDs;
        boolean isEqual = true;
        for (IRepositoryPropertyTypeID propertyTypeID : propertyTypeIDs) {
            Assert.checkArgument((boolean)attributeSet2propertyTypeIDs.contains((Object)propertyTypeID));
            IRepositoryPropertySample property1 = attributeSet1.getPropertySample(propertyTypeID);
            IRepositoryPropertySample property2 = attributeSet2.getPropertySample(propertyTypeID);
            isEqual &= RepositorySamples.isEqual(property1, property2);
        }
        return isEqual;
    }

    public static boolean isEqual(ICrossLinkRepositoryRelationSample relation1, ICrossLinkRepositoryRelationSample relation2) {
        return ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER.isEqual((Object)relation1, (Object)relation2);
    }

    public static boolean isEqual(IOccurrenceRepositoryRelationSample relation1, IOccurrenceRepositoryRelationSample relation2) {
        return IOccurrenceRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER.isEqual((Object)relation1, (Object)relation2);
    }

    public static void checkIfIsOfType(IRepositoryPropertySample sample, IRepositoryPropertyType type, IRepositoryObjectTypeID objectTypeID) throws EXPropertySampleCannotBeOfType {
        assert (sample != null && type != null);
        if (!sample.getValue().getDataType().equals(type.getDataType())) {
            String detailedReason = "The data type of the property sample does not match the one defined in the property type.";
            throw new EXPropertySampleCannotBeOfType(sample, type.getRepositoryPropertyTypeID(), objectTypeID, detailedReason);
        }
    }

    public static void checkIfIsOfType(IRepositoryPropertySetSample sample, IRepositoryAttributeSetType type, IRepositoryObjectTypeID objectTypeID) throws EXPropertySetSampleCannotBeOfType {
        assert (sample != null && type != null);
        ISet_<IRepositoryPropertyTypeID> propertyTypeIDColl = sample.getPropertyTypeIDs();
        ICollection_<? extends IRepositoryPropertyType> propertyTypesColl = type.getPropertyTypes();
        IRepositoryAttributeSetTypeID specifiedAttributeSetTypeID = type.getRepositoryAttributeSetTypeID();
        if (propertyTypeIDColl.size() != propertyTypesColl.size()) {
            String detailedReason = "The property set sample and the attribute set type have defined different amounts of property types";
            throw new EXPropertySetSampleCannotBeOfType(sample, specifiedAttributeSetTypeID, detailedReason, objectTypeID);
        }
        HashSet_ remainingPropertyTypeIDsOfSample = new HashSet_(propertyTypeIDColl, IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        for (IRepositoryPropertyType propertyType : propertyTypesColl) {
            IRepositoryPropertyTypeID propertyTypeID = propertyType.getRepositoryPropertyTypeID();
            if (propertyTypeIDColl.contains((Object)propertyTypeID)) {
                try {
                    RepositorySamples.checkIfIsOfType(sample.getPropertySample(propertyTypeID), propertyType, objectTypeID);
                }
                catch (EXPropertySampleCannotBeOfType e) {
                    String detailedReason = "EXPropertySampleCannotBeOfType occured while checking if a property sample (of the property set sample) if of the specified property type.\n Specified property type id: " + propertyType.getRepositoryPropertyTypeID().toCanonicalString() + "\n Causer message: " + e.getMessage();
                    throw new EXPropertySetSampleCannotBeOfType(sample, specifiedAttributeSetTypeID, detailedReason, objectTypeID);
                }
                remainingPropertyTypeIDsOfSample.remove((Object)propertyTypeID);
                continue;
            }
            String detailedReason = "A property type defined in the specified attribute set type is not contained in the peroperty set sample. \n Missing property type: " + propertyTypeID.toCanonicalString();
            throw new EXPropertySetSampleCannotBeOfType(sample, specifiedAttributeSetTypeID, detailedReason, objectTypeID);
        }
        if (!remainingPropertyTypeIDsOfSample.isEmpty()) {
            StringBuffer detailedReason = new StringBuffer("One or more property types of the property set sample are not defined in the specified attribute set type. \n Missing property type(s): ");
            for (IRepositoryPropertyTypeID remainingPropertyTypeID : remainingPropertyTypeIDsOfSample) {
                detailedReason.append(remainingPropertyTypeID.toCanonicalString());
                detailedReason.append("\n");
            }
            throw new EXPropertySetSampleCannotBeOfType(sample, specifiedAttributeSetTypeID, detailedReason.toString(), objectTypeID);
        }
    }

    public static void checkIfIsOfType(IRepositoryObjectSample sample, IRepositoryObjectType type) throws EXObjectSampleCannotBeOfType {
        assert (sample != null && type != null);
        IRepositoryObjectTypeID specifiedObjectTypeID = type.getRepositoryObjectTypeID();
        if (!IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)sample.getObjectTypeID(), (Object)specifiedObjectTypeID)) {
            String detailedReason = "Specified object type and type of object sample are not equal. \n Type id of object sample: " + sample.getObjectTypeID().toCanonicalString() + "\n Specified type id: " + specifiedObjectTypeID.toCanonicalString();
            throw new EXObjectSampleCannotBeOfType(sample, specifiedObjectTypeID, detailedReason);
        }
        IRepositoryPropertySetSample propertySetSample = sample.getPropertySetSample();
        HashSet_ remainingPropertyTypeIDs = new HashSet_(propertySetSample.getPropertyTypeIDs(), IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        ICollection_<? extends IRepositoryAttributeSetType> attributeSetTypes = type.getAttributeSetTypes();
        for (IRepositoryAttributeSetType attributeSetType : attributeSetTypes) {
            for (IRepositoryPropertyType propertyType : attributeSetType.getPropertyTypes()) {
                IRepositoryPropertyTypeID propertyTypeID = propertyType.getRepositoryPropertyTypeID();
                if (propertySetSample.getPropertyTypeIDs().contains((Object)propertyTypeID)) {
                    IRepositoryPropertySample propSample = propertySetSample.getPropertySample(propertyTypeID);
                    try {
                        RepositorySamples.checkIfIsOfType(propSample, propertyType, type.getRepositoryObjectTypeID());
                    }
                    catch (EXPropertySampleCannotBeOfType e) {
                        String detailedReason = "EXPropertySampleCannotBeOfType occured while checking if a property sample (of the object sample) is of specified property type. \n Specified property type id: " + propertyType.getRepositoryPropertyTypeID().toCanonicalString() + "\n\n Causer message: " + e.getMessage();
                        throw new EXObjectSampleCannotBeOfType(sample, specifiedObjectTypeID, detailedReason);
                    }
                    remainingPropertyTypeIDs.remove((Object)propertyTypeID);
                    continue;
                }
                String detailedReason = "A property type defined in the specified object type is not contained in the given object sample \n Missing property type: " + propertyTypeID.toCanonicalString();
                throw new EXObjectSampleCannotBeOfType(sample, specifiedObjectTypeID, detailedReason);
            }
        }
        if (!remainingPropertyTypeIDs.isEmpty()) {
            StringBuffer detailedReason = new StringBuffer("One or more property types of the object sample are not defined in the specified object type \n Missing property type(s): ");
            for (IRepositoryPropertyTypeID remainingPropertyTypeID : remainingPropertyTypeIDs) {
                detailedReason.append(remainingPropertyTypeID.toCanonicalString());
                detailedReason.append("\n");
            }
            throw new EXObjectSampleCannotBeOfType(sample, specifiedObjectTypeID, detailedReason.toString());
        }
    }

    public static void checkIfIsOfType(ICrossLinkRepositoryRelationSample sample, ICrossLinkRepositoryRelationType type) throws EXCrossLinkRelationSampleCannotBeOfType {
        assert (sample != null && type != null);
        IRepositoryRelationTypeID specifiedRelationTypeID = type.getRepositoryRelationTypeID();
        if (!IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER.isEqual((Object)sample.getRelationTypeID(), (Object)type.getRepositoryRelationTypeID())) {
            String detailedReason = "Specified type and type of relation sample are not equal. \n Type id of relation sample: " + sample.getRelationTypeID().toCanonicalString() + "\n Specified type id: " + specifiedRelationTypeID.toCanonicalString();
            throw new EXCrossLinkRelationSampleCannotBeOfType(sample, specifiedRelationTypeID, detailedReason);
        }
        RepositorySamples.checkNumberOfRelationContributions(sample, type);
        ISet_<IRepositoryRelationContributionRoleID> roleIDsOfSample = sample.getRelationContributionRoleIDs();
        ICollection_<? extends ICrossLinkRepositoryRelationContributionType> rcTypes = type.getAllRelationContributionTypes();
        HashSet_ remainingRCTypes = new HashSet_(rcTypes, IAbstractRepositoryRelationContributionType.IS_EQUAL_IRELATION_CONTRIBUTION_HASHER);
        for (ICrossLinkRepositoryRelationContributionType rcType : rcTypes) {
            IRepositoryRelationContributionRoleID roleID = rcType.getRepositoryRelationContributionRoleID();
            if (roleIDsOfSample.contains((Object)roleID)) {
                remainingRCTypes.remove((Object)rcType);
                IRepositoryObjectType objectType = rcType.getRelatedObjectType();
                IRepositoryPropertySetSample objectId = sample.getObjectID(roleID);
                try {
                    RepositorySamples.checkIfIsOfType(objectId, objectType.getIDAttributeSetType(), objectType.getRepositoryObjectTypeID());
                    continue;
                }
                catch (EXPropertySetSampleCannotBeOfType e) {
                    String detailedReason = "EXPropertySetSampleCannotBeOfType occured while checking if object id property set sample (of object part of relation sample) does match the coressponding id attribute set type definition. \n Causer exception message: " + e.getMessage();
                    throw new EXCrossLinkRelationSampleCannotBeOfType(sample, specifiedRelationTypeID, detailedReason);
                }
            }
            String detailedReason = "The relation sample does not contain a role id that is defined in the specified relation type. \n Missing role id: " + roleID.toCanonicalString();
            throw new EXCrossLinkRelationSampleCannotBeOfType(sample, specifiedRelationTypeID, detailedReason);
        }
        if (!remainingRCTypes.isEmpty()) {
            StringBuffer detailedReason = new StringBuffer("One or more relation contributions of the relation sample are not defined in the specified relation type \n Missing relation contribution role id(s): ");
            for (ICrossLinkRepositoryRelationContributionType remainingRCType : remainingRCTypes) {
                detailedReason.append(remainingRCType.getRepositoryRelationContributionRoleID().toCanonicalString());
                detailedReason.append("\n");
            }
            throw new EXCrossLinkRelationSampleCannotBeOfType(sample, specifiedRelationTypeID, detailedReason.toString());
        }
    }

    public static void checkNumberOfRelationContributions(ICrossLinkRepositoryRelationSample sample, ICrossLinkRepositoryRelationType type) throws EXCrossLinkRelationSampleCannotBeOfType {
        ISet_<IRepositoryRelationContributionRoleID> roleIDsOfSample = sample.getRelationContributionRoleIDs();
        ICollection_<? extends ICrossLinkRepositoryRelationContributionType> rcTypes = type.getAllRelationContributionTypes();
        if (roleIDsOfSample.size() != rcTypes.size()) {
            String detailedReason = "Relation sample and type have defined a different amount of relation contributions.";
            IRepositoryRelationTypeID specifiedRelationTypeID = type.getRepositoryRelationTypeID();
            throw new EXCrossLinkRelationSampleCannotBeOfType(sample, specifiedRelationTypeID, detailedReason);
        }
    }

    public static IRepositoryPropertySetSample getPropertySetSampleForAttributeSet(IRepositoryObjectSample repositoryObjectSample, IRepositoryAttributeSetType repositoryAttributeSetType) {
        assert (Assert.checkArgument((repositoryAttributeSetType == repositoryAttributeSetType.getRepositoryTypeManagerRO().getObjectType(repositoryObjectSample.getObjectTypeID()).getAttributeSetType(repositoryAttributeSetType.getRepositoryAttributeSetTypeID()) ? 1 : 0) != 0));
        IRepositoryPropertySetSample objectPropertySetSample = repositoryObjectSample.getPropertySetSample();
        HashMap_ properties = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        for (IRepositoryPropertyType repositoryPropertyType : repositoryAttributeSetType.getPropertyTypes()) {
            IRepositoryPropertyTypeID propertyTypeID = repositoryPropertyType.getRepositoryPropertyTypeID();
            IRepositoryPropertySample propertySample = objectPropertySetSample.getPropertySample(propertyTypeID);
            properties.put((Object)propertyTypeID, (Object)propertySample);
        }
        return new RepositoryPropertySetSample((IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample>)properties);
    }

    public static IRepositoryPropertySetSample getPropertySetSampleForAttributeSet(IRepositoryObjectSample repositoryObjectSample, IRepositoryAttributeSetTypeID repositoryAttributeSetTypeID, IRepositoryTypeManagerRO repositoryTypeManager) {
        IRepositoryObjectType repositoryObjectType = repositoryTypeManager.getObjectType(repositoryObjectSample.getObjectTypeID());
        IRepositoryAttributeSetType repositoryAttributeSetType = repositoryObjectType.getAttributeSetType(repositoryAttributeSetTypeID);
        return RepositorySamples.getPropertySetSampleForAttributeSet(repositoryObjectSample, repositoryAttributeSetType);
    }

    public static IRepositoryObjectReference getObjectReferenceWithIDDefiningObjectType(IRepositoryObjectSample repositoryObjectSample, IRepositoryTypeManagerRO repositoryTypeManager) {
        IRepositoryObjectType objectType = repositoryTypeManager.getObjectType(repositoryObjectSample.getObjectTypeID());
        return new RepositoryObjectReferenceWithIDDefiningObjectTypeID(objectType, repositoryObjectSample.getObjectID(repositoryTypeManager));
    }

    public static IRepositoryPropertySetSample getSnapshotID(IRepositoryObjectSample repositorySnapshotInformation, IRepositoryTypeManagerRO repositoryTypeManager) {
        IRepositoryObjectType snapshotObjectType = repositoryTypeManager.getRootModuleType().getSnapshotObjectType();
        return RepositorySamples.getPropertySetSampleForAttributeSet(repositorySnapshotInformation, snapshotObjectType.getIDAttributeSetType());
    }

    public static IRepositoryPropertySetSample getWorkspaceID(IRepositoryObjectSample repositoryWorkspaceInformation, IRepositoryTypeManagerRO repositoryTypeManager) {
        IRepositoryObjectType workspaceObjectType = repositoryTypeManager.getRootModuleType().getWorkspaceObjectType();
        return RepositorySamples.getPropertySetSampleForAttributeSet(repositoryWorkspaceInformation, workspaceObjectType.getIDAttributeSetType());
    }

    public static String createCanonicalString(IRepositoryPropertySetSample propertySetSample) {
        SortedMap_ propertyTypeIDAsCanonicalString_2_propertyValueAsCanoncialString = new SortedMap_((IComparator_)new IComparator_<String>(){

            public int getHashCode(String string) {
                return string.hashCode();
            }

            public int sgn(String string1, String string2) {
                return string1.compareTo(string2);
            }
        });
        for (IRepositoryPropertyTypeID propertyTypeID : propertySetSample.getPropertyTypeIDs()) {
            IRepositoryPropertySample propertySample = propertySetSample.getPropertySample(propertyTypeID);
            IRepositoryData data = propertySample.getValue();
            IRepositoryDataType dataType = data.getDataType();
            IRepositoryDataHasher dataHasher = dataType.getHasher();
            Assert.checkArgumentBeeingNotNull((Object)dataHasher);
            String propertyTypeIDAsCanonicalString = propertyTypeID.toCanonicalString();
            String propertyValueAsCanonicalString = dataHasher.getCanonicalStringRepresentation(data);
            propertyTypeIDAsCanonicalString_2_propertyValueAsCanoncialString.put((Object)propertyTypeIDAsCanonicalString, (Object)propertyValueAsCanonicalString);
        }
        String[] elements = new String[2 * propertyTypeIDAsCanonicalString_2_propertyValueAsCanoncialString.size()];
        int idx = 0;
        for (IEntry_ string2Object : propertyTypeIDAsCanonicalString_2_propertyValueAsCanoncialString) {
            elements[idx] = (String)string2Object.getKey();
            elements[++idx] = (String)string2Object.getValue();
            ++idx;
        }
        String canonicalString = StringUtil.createCanonicalStringConcatenation((String[])elements);
        return canonicalString;
    }
}

