/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IRepositoryIterator_ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;

public class RepositoryRelations {
    public static ICrossLinkRepositoryRelation findCrossLinkRelation(ICrossLinkRepositoryRelationSample relationSample, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXMissingCrossLinkTarget {
        IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample> roleID2ObjectID = relationSample.getRoleID2ObjectIDMap();
        ICrossLinkRepositoryRelationType relationType = snapshot.getTypeManager().getCrossLinkRelationType(relationSample.getRelationTypeID());
        IRepositoryIterator_ICrossLinkRepositoryRelation iteratorFoundRelations = snapshot.findCrossLinkRelations(relationType, roleID2ObjectID);
        ICrossLinkRepositoryRelation foundRepositoryRelation = null;
        if (iteratorFoundRelations.hasNext()) {
            foundRepositoryRelation = iteratorFoundRelations.nextIRepositoryRelation();
        }
        Assert.checkArgument((!iteratorFoundRelations.hasNext() ? 1 : 0) != 0);
        return foundRepositoryRelation;
    }

    public static IOccurrenceRepositoryRelation findOccurrenceRelation(IOccurrenceRepositoryRelationSample relationSample, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        IOccurrenceRepositoryRelationType relationType = snapshot.getTypeManager().getOccurrenceRelationType(relationSample.getRelationTypeID());
        IOccurrenceRepositoryRelation foundRepositoryRelation = snapshot.findOccurrenceRelation(relationType, relationSample.getObjectIDofOccurrenceContainingObject(), relationSample.getOccurrenceID());
        return foundRepositoryRelation;
    }

    public static IRepositoryIterator_ICrossLinkRepositoryRelation findAllRepositoryRelationsOfType(IRepositoryRelationTypeID relationTypeID, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        IRepositoryIterator_ICrossLinkRepositoryRelation iteratorFoundRelations;
        HashMap_ roleID2ObjectID = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        ICrossLinkRepositoryRelationType relationType = snapshot.getTypeManager().getCrossLinkRelationType(relationTypeID);
        try {
            iteratorFoundRelations = snapshot.findCrossLinkRelations(relationType, (IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample>)roleID2ObjectID);
        }
        catch (EXMissingCrossLinkTarget e) {
            throw new RuntimeException();
        }
        return iteratorFoundRelations;
    }

    public static IRepositoryIterator_ICrossLinkRepositoryRelation findAllCrossLinkRelationsRelationContributionIsPartOf(IRepositoryRelationTypeID relationTypeID, IRepositoryPropertySetSample objectID, IRepositoryRelationContributionRoleID roleID, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXMissingCrossLinkTarget {
        HashMap_ roleID2ObjectID = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        roleID2ObjectID.put((Object)roleID, (Object)objectID);
        ICrossLinkRepositoryRelationType relationType = snapshot.getTypeManager().getCrossLinkRelationType(relationTypeID);
        IRepositoryIterator_ICrossLinkRepositoryRelation iteratorFoundRelations = snapshot.findCrossLinkRelations(relationType, (IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample>)roleID2ObjectID);
        return iteratorFoundRelations;
    }

    public static IRepositoryIterator_ICrossLinkRepositoryRelation findCrossLinkRelations(IRepositoryRelationTypeID relationTypeID, IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample> roleID2ObjectID, IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot, EXMissingCrossLinkTarget {
        ICrossLinkRepositoryRelationType relationType = snapshot.getTypeManager().getCrossLinkRelationType(relationTypeID);
        return snapshot.findCrossLinkRelations(relationType, roleID2ObjectID);
    }
}

