/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data;

import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryDataTypeEnumeration;

public class RepositoryProperties {
    private static final ILogger LOGGER = Logger.getLogger(RepositoryProperties.class);

    public static ISortedSet_<String> getValueRangeKeysForEnumerationProperty(RepositoryPropertyContext propertyContext) {
        ISortedSet_<String> valueRangeKeysAsEditorValue = null;
        if (propertyContext.getRepositoryDataTypeParameters() instanceof AbstractRepositoryDataTypeEnumeration.EnumerationParameters) {
            AbstractRepositoryDataTypeEnumeration.EnumerationParameters enumerationRepositoryDataTypeParameters = (AbstractRepositoryDataTypeEnumeration.EnumerationParameters)propertyContext.getRepositoryDataTypeParameters();
            valueRangeKeysAsEditorValue = enumerationRepositoryDataTypeParameters.getValues();
        }
        return valueRangeKeysAsEditorValue;
    }

    public static RepositoryPropertyContext getPropertyContext(IRepositoryPropertyReference propertyReference, IRepositoryInterfaceRO repositoryInterface) {
        IRepositoryTypeManagerRO typeManager = repositoryInterface.getTypeManager();
        IRepositoryPropertyTypeID propertyTypeID = propertyReference.getPropertyTypeID();
        IRepositoryObjectReference objectReference = propertyReference.getObjectReference();
        IRepositoryObjectTypeID objectTypeID = objectReference.getObjectTypeID();
        IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
        IRepositoryAttributeSetType repositoryAttributeSetType = objectType.getAttributeSetType(propertyTypeID);
        IRepositoryPropertyType repositoryPropertyType = repositoryAttributeSetType.getPropertyType(propertyTypeID);
        return RepositoryProperties.getPropertyContext(repositoryPropertyType);
    }

    public static RepositoryPropertyContext getPropertyContext(IRepositoryPropertyType repositoryPropertyType) {
        IRepositoryDataType repositoryDataType = repositoryPropertyType.getDataType();
        IRepositoryDataTypeParameters repositoryDataTypeParameters = repositoryPropertyType.getDataTypeParameters();
        return new RepositoryPropertyContext(repositoryPropertyType, repositoryDataType, repositoryDataTypeParameters);
    }

    public static class RepositoryPropertyContext {
        private final IRepositoryPropertyType repositoryPropertyType;
        private final IRepositoryDataType repositoryDataType;
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;

        public RepositoryPropertyContext(IRepositoryPropertyType repositoryPropertyType, IRepositoryDataType repositoryDataType, IRepositoryDataTypeParameters repositoryDataTypeParameters) {
            this.repositoryPropertyType = repositoryPropertyType;
            this.repositoryDataType = repositoryDataType;
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
        }

        public IRepositoryPropertyType getRepositoryPropertyType() {
            return this.repositoryPropertyType;
        }

        public IRepositoryDataType getRepositoryDataType() {
            return this.repositoryDataType;
        }

        public IRepositoryDataTypeParameters getRepositoryDataTypeParameters() {
            return this.repositoryDataTypeParameters;
        }
    }
}

