/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions.actions;

import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IIteratorRW_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.transactions.AbstractElementaryAction;
import com.arcway.repository.implementation.transactions.actions.LockHelper;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSetReference;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryFileArchiveRW;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.UniquePropertyChecker;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.attributeset.RepositoryAttributeSetTypeConflictType;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeFile;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.transactions.exceptions.EXAttributeSetTypeNotModifiable;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import java.util.ArrayList;
import java.util.Arrays;

public class REAModifyAttributeSet
extends AbstractElementaryAction {
    private static final ILogger logger = Logger.getLogger(REAModifyAttributeSet.class);
    private IRepositoryAttributeSetReference asToBeModifiedReference;
    private IRepositoryPropertySetSample newValues;
    private IRepositoryPropertySetSample oldValues;
    private final ISetRW_<IRepositoryFileID> loadedRepositoryFileIDs = new HashSet_(IRepositoryFileID.IS_EQUAL_FILE_ID_HASHER);

    public REAModifyAttributeSet(IRepositoryAttributeSetReference asToBeModified, IRepositoryPropertySetSample newValues) {
        this.asToBeModifiedReference = asToBeModified;
        this.newValues = newValues;
    }

    @Override
    public void execute(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        assert (this.newValues != null);
        IRepositoryObjectReference objectReference = this.asToBeModifiedReference.getObjectReference();
        IRepositoryObjectTypeID objectTypeID = objectReference.getObjectTypeID();
        IRepositoryPropertySetSample objectID = objectReference.getObjectID();
        IRepositoryAttributeSetTypeID asTypeID = this.asToBeModifiedReference.getAttributeSetTypeID();
        IRepositoryAttributeSet asToBeModified = RepositoryReferences.getAttributeSetFromReference((IRepositoryAttributeSetReference)this.asToBeModifiedReference, (IRepositorySnapshotRO)snapshot);
        IRepositoryAttributeSetType asType = asToBeModified.getAttributeSetType();
        if (asType.getConflictType().equals(RepositoryAttributeSetTypeConflictType.IS_CONSTANT)) {
            throw new EXAttributeSetTypeNotModifiable(asTypeID, objectTypeID, objectID);
        }
        RepositorySamples.checkIfIsOfType((IRepositoryPropertySetSample)this.newValues, (IRepositoryAttributeSetType)asType, (IRepositoryObjectTypeID)objectTypeID);
        IRepositoryAttributeSet parentAS = asToBeModified.getObject().getParentAttributeSet();
        IRepositoryObject parentObject = parentAS.getObject();
        for (IRepositoryPropertyType propertyType : asType.getPropertyTypes()) {
            if (propertyType.getIDType().isNotAnID()) continue;
            IRepositoryPropertyTypeID propertyTypeID = propertyType.getRepositoryPropertyTypeID();
            IRepositoryPropertySample propertyToCheck = this.newValues.getPropertySample(propertyTypeID);
            UniquePropertyChecker.checkForExistingObjectsWithProperty((IRepositoryPropertySample)propertyToCheck, (IRepositoryPropertyType)propertyType, (IRepositoryObjectReference)objectReference, (IRepositoryObject)parentObject, (IRepositorySnapshotRO)snapshot);
        }
        if (this.oldValues == null) {
            this.oldValues = asToBeModified.sample();
        }
        this.loadFiles(asType, snapshot);
        snapshot.modifyAttributeSet(asToBeModified, this.newValues);
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        locks.addAll(Arrays.asList(LockHelper.lockAllIDs(asToBeModified)));
        try {
            locks.addAll(Arrays.asList(LockHelper.lockAttributeSet(asToBeModified)));
            this.setLocks(locks.toArray(new AbstractRepositoryLockSample[locks.size()]));
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error((Throwable)e);
            this.rollback(snapshot);
            throw e;
        }
    }

    @Override
    public void rollback(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        assert (this.asToBeModifiedReference != null);
        assert (this.oldValues != null);
        IRepositoryAttributeSet asToBeModified = RepositoryReferences.getAttributeSetFromReference((IRepositoryAttributeSetReference)this.asToBeModifiedReference, (IRepositorySnapshotRO)snapshot);
        snapshot.modifyAttributeSet(asToBeModified, this.oldValues);
        this.oldValues = null;
        this.unloadFiles(snapshot);
    }

    private void loadFiles(IRepositoryAttributeSetType asType, IRepositorySnapshotRW snapshot) {
        for (IRepositoryPropertyTypeID repositoryPropertyTypeID : this.newValues.getPropertyTypeIDs()) {
            IRepositoryPropertySample repositoryPropertySample;
            IRepositoryData data;
            IRepositoryDataTypeFile repositoryDataTypeFile;
            IRepositoryFileID repositoryFileID;
            IRepositoryPropertyType repositoryPropertyType = asType.getPropertyType(repositoryPropertyTypeID);
            IRepositoryDataType repositoryDataType = repositoryPropertyType.getDataType();
            if (!(repositoryDataType instanceof IRepositoryDataTypeFile) || (repositoryFileID = (repositoryDataTypeFile = (IRepositoryDataTypeFile)repositoryDataType).dataToFileID(data = (repositoryPropertySample = this.newValues.getPropertySample(repositoryPropertyTypeID)).getValue())) == null) continue;
            IRepositoryFileArchiveRW repositoryFileArchive = snapshot.getRepositoryWorkspace().getFileArchiveRW();
            try {
                repositoryFileArchive.markFileAsBeingPermanent(repositoryFileID);
                this.loadedRepositoryFileIDs.add((Object)repositoryFileID);
            }
            catch (RuntimeException e) {
                logger.error((Throwable)e);
                this.unloadFiles(snapshot);
                throw e;
            }
        }
    }

    private void unloadFiles(IRepositorySnapshotRW snapshot) {
        IIteratorRW_ i = this.loadedRepositoryFileIDs.iterator();
        while (i.hasNext()) {
            IRepositoryFileID repositoryFileID = (IRepositoryFileID)i.next();
            IRepositoryFileArchiveRW repositoryFileArchive = snapshot.getRepositoryWorkspace().getFileArchiveRW();
            repositoryFileArchive.markFileAsBeingTemporary(repositoryFileID);
            i.remove();
        }
    }

    public String getName() {
        return "Modify Attribute Set Action";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        REAModifyAttributeSet clone = (REAModifyAttributeSet)((Object)super.clone());
        clone.asToBeModifiedReference = this.asToBeModifiedReference;
        clone.newValues = this.newValues;
        return clone;
    }
}

