/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions.actions;

import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IIteratorRW_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.transactions.AbstractElementaryAction;
import com.arcway.repository.implementation.transactions.actions.LockHelper;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryFileArchiveRW;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.UniquePropertyChecker;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeFile;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectIDNotUnique;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectNotInstanciable;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectTypeDoesNotExist;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;

public class REACreateObject
extends AbstractElementaryAction {
    private static final ILogger logger = Logger.getLogger(REACreateObject.class);
    private IRepositoryObjectReference parentObjectReference;
    private IRepositoryObjectSample objectToCreate;
    private final ISetRW_<IRepositoryFileID> loadedRepositoryFileIDs = new HashSet_(IRepositoryFileID.IS_EQUAL_FILE_ID_HASHER);

    public REACreateObject(IRepositoryObjectReference parentObjectReference, IRepositoryObjectSample objectToCreateSample) {
        this.parentObjectReference = parentObjectReference;
        this.objectToCreate = objectToCreateSample;
    }

    @Override
    public void execute(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        assert (this.parentObjectReference != null);
        assert (this.objectToCreate != null);
        IRepositoryObject parentObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)this.parentObjectReference, (IRepositorySnapshotRO)snapshot);
        IRepositoryObjectTypeID objectTypeId = this.objectToCreate.getObjectTypeID();
        IRepositoryTypeManagerRO typeManagerRO = snapshot.getTypeManager();
        IRepositoryObjectType repositoryObjectType = typeManagerRO.getObjectType(objectTypeId);
        if (repositoryObjectType == null) {
            throw new EXObjectTypeDoesNotExist(objectTypeId);
        }
        if (!repositoryObjectType.canBeInstanciated()) {
            throw new EXObjectNotInstanciable(objectTypeId);
        }
        RepositorySamples.checkIfIsOfType((IRepositoryObjectSample)this.objectToCreate, (IRepositoryObjectType)repositoryObjectType);
        IRepositoryPropertySetSample idPropertySetSample = this.objectToCreate.getObjectID(typeManagerRO);
        IRepositoryObject objectWithSameObjectID = snapshot.findRepositoryObject(repositoryObjectType, idPropertySetSample);
        if (objectWithSameObjectID != null) {
            throw new EXObjectIDNotUnique(idPropertySetSample, objectWithSameObjectID.sample());
        }
        IRepositoryPropertySetSample allProperties = this.objectToCreate.getPropertySetSample();
        IRepositoryObjectReference objectToCreateAsReference = this.objectToCreate.getObjectReference(typeManagerRO);
        for (IRepositoryAttributeSetType asType : repositoryObjectType.getAttributeSetTypes()) {
            for (IRepositoryPropertyType propertyType : asType.getPropertyTypes()) {
                if (propertyType.getIDType().isNotAnID()) continue;
                IRepositoryPropertyTypeID propertyTypeID = propertyType.getRepositoryPropertyTypeID();
                IRepositoryPropertySample propertyToCheck = allProperties.getPropertySample(propertyTypeID);
                UniquePropertyChecker.checkForExistingObjectsWithProperty((IRepositoryPropertySample)propertyToCheck, (IRepositoryPropertyType)propertyType, (IRepositoryObjectReference)objectToCreateAsReference, (IRepositoryObjectReference)this.parentObjectReference, (IRepositorySnapshotRO)snapshot);
            }
        }
        assert (parentObject != null);
        this.loadFiles(repositoryObjectType, allProperties, snapshot);
        IRepositoryObject createdObject = snapshot.createObject(parentObject, this.objectToCreate);
        try {
            this.setLocks(LockHelper.lockWholeObjectWithParent(createdObject));
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error((Throwable)e);
            this.rollback(snapshot);
            throw e;
        }
    }

    @Override
    public void rollback(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        assert (this.objectToCreate != null);
        IRepositoryObjectType createdObjectObjectType = snapshot.getTypeManager().getObjectType(this.objectToCreate.getObjectTypeID());
        IRepositoryPropertySetSample createdObjectidASSample = this.objectToCreate.getObjectID(snapshot.getTypeManager());
        IRepositoryObject createdObject = snapshot.findRepositoryObject(createdObjectObjectType, createdObjectidASSample);
        assert (createdObject != null);
        snapshot.deleteObject(createdObject);
        this.unloadFiles(snapshot);
    }

    private void loadFiles(IRepositoryObjectType repositoryObjectType, IRepositoryPropertySetSample allProperties, IRepositorySnapshotRW snapshot) {
        for (IRepositoryPropertyTypeID repositoryPropertyTypeID : allProperties.getPropertyTypeIDs()) {
            IRepositoryPropertySample repositoryPropertySample;
            IRepositoryData data;
            IRepositoryDataTypeFile repositoryDataTypeFile;
            IRepositoryFileID repositoryFileID;
            IRepositoryPropertyType repositoryPropertyType = repositoryObjectType.getAttributeSetType(repositoryPropertyTypeID).getPropertyType(repositoryPropertyTypeID);
            IRepositoryDataType repositoryDataType = repositoryPropertyType.getDataType();
            if (!(repositoryDataType instanceof IRepositoryDataTypeFile) || (repositoryFileID = (repositoryDataTypeFile = (IRepositoryDataTypeFile)repositoryDataType).dataToFileID(data = (repositoryPropertySample = allProperties.getPropertySample(repositoryPropertyTypeID)).getValue())) == null) continue;
            IRepositoryFileArchiveRW repositoryFileArchive = snapshot.getRepositoryWorkspace().getFileArchiveRW();
            try {
                repositoryFileArchive.markFileAsBeingPermanent(repositoryFileID);
                this.loadedRepositoryFileIDs.add((Object)repositoryFileID);
            }
            catch (RuntimeException e) {
                logger.error((Throwable)e);
                this.unloadFiles(snapshot);
                throw e;
            }
        }
    }

    private void unloadFiles(IRepositorySnapshotRW snapshot) {
        IIteratorRW_ i = this.loadedRepositoryFileIDs.iterator();
        while (i.hasNext()) {
            IRepositoryFileID repositoryFileID = (IRepositoryFileID)i.next();
            IRepositoryFileArchiveRW repositoryFileArchive = snapshot.getRepositoryWorkspace().getFileArchiveRW();
            repositoryFileArchive.markFileAsBeingTemporary(repositoryFileID);
            i.remove();
        }
    }

    public String getName() {
        return "Create New Child Action";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        REACreateObject clone = (REACreateObject)((Object)super.clone());
        clone.parentObjectReference = this.parentObjectReference;
        clone.objectToCreate = this.objectToCreate;
        return clone;
    }
}

