/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions.actions;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.repository.implementation.lock.CrossLinkRepositoryRelationLockSample;
import com.arcway.repository.implementation.lock.OccurrenceRepositoryRelationLockSample;
import com.arcway.repository.implementation.lock.RepositoryAttributeSetLockSample;
import com.arcway.repository.implementation.lock.RepositoryIDLockSample;
import com.arcway.repository.implementation.lock.RepositoryObjectLockSample;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryObjectLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.attributeset.RepositoryAttributeSetTypeConflictType;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.property.RepositoryPropertyTypeIDType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import java.util.ArrayList;
import java.util.List;

public class LockHelper {
    private static final IDTypeChecker ID_AND_NAME_LOCKER = new IDTypeChecker(){

        @Override
        public boolean mustBeLocked(RepositoryPropertyTypeIDType idType) {
            return idType.isID() || idType.isName();
        }
    };
    private static final IDTypeChecker NAME_LOCKER = new IDTypeChecker(){

        @Override
        public boolean mustBeLocked(RepositoryPropertyTypeIDType idType) {
            return idType.isName();
        }
    };

    private LockHelper() {
    }

    public static AbstractRepositoryLockSample lockParent(IRepositoryAttributeSet parentAS) throws EXNotReproducibleSnapshot {
        AbstractRepositoryObjectLockSample parentLock;
        Assert.checkArgumentBeeingNotNull((Object)parentAS);
        if (parentAS.getAttributeSetType().getConflictType() == RepositoryAttributeSetTypeConflictType.IS_NOT_CONFLICTING) {
            parentLock = RepositoryObjectLockSample.createSharedLock((IRepositoryObject)parentAS.getObject());
        } else {
            assert (parentAS.getAttributeSetType().getConflictType() == RepositoryAttributeSetTypeConflictType.IS_CONFLICTING);
            parentLock = RepositoryAttributeSetLockSample.createLock((IRepositoryAttributeSet)parentAS);
        }
        return parentLock;
    }

    public static AbstractRepositoryLockSample[] lockWholeObjectWithParent(IRepositoryObject object) throws EXNotReproducibleSnapshot {
        List<AbstractRepositoryLockSample> locks;
        Assert.checkArgumentBeeingNotNull((Object)object);
        IRepositoryAttributeSet parentAS = object.getParentAttributeSet();
        if (parentAS != null) {
            locks = new ArrayList<AbstractRepositoryLockSample>();
            locks.add(LockHelper.lockParent(parentAS));
            locks.addAll(LockHelper.doLockWholeObject(object));
        } else {
            locks = LockHelper.doLockWholeObject(object);
        }
        return LockHelper.toLockSampleArray(locks);
    }

    public static AbstractRepositoryLockSample[] lockWholeObject(IRepositoryObject object) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)object);
        List<AbstractRepositoryLockSample> locks = LockHelper.doLockWholeObject(object);
        return LockHelper.toLockSampleArray(locks);
    }

    private static List<AbstractRepositoryLockSample> doLockWholeObject(IRepositoryObject object) throws EXNotReproducibleSnapshot {
        assert (object != null);
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        locks.add((AbstractRepositoryLockSample)RepositoryObjectLockSample.createExclusiveLock((IRepositoryObject)object));
        for (IRepositoryAttributeSetType attributeSetType : object.getObjectType().getAttributeSetTypes()) {
            locks.addAll(LockHelper.doLockAttributeSet(object.getAttributeSet(attributeSetType)));
        }
        return locks;
    }

    public static AbstractRepositoryLockSample[] lockAttributeSet(IRepositoryAttributeSet attributeSet) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)attributeSet);
        List<AbstractRepositoryLockSample> locks = LockHelper.doLockAttributeSet(attributeSet);
        return LockHelper.toLockSampleArray(locks);
    }

    private static List<AbstractRepositoryLockSample> doLockAttributeSet(IRepositoryAttributeSet attributeSet) throws EXNotReproducibleSnapshot {
        assert (attributeSet != null);
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        locks.add((AbstractRepositoryLockSample)RepositoryAttributeSetLockSample.createLock((IRepositoryAttributeSet)attributeSet));
        locks.addAll(LockHelper.doLockIDs(attributeSet, ID_AND_NAME_LOCKER));
        return locks;
    }

    public static AbstractRepositoryLockSample[] lockAllIDs(IRepositoryAttributeSet attributeSet) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)attributeSet);
        List<AbstractRepositoryLockSample> locks = LockHelper.doLockIDs(attributeSet, ID_AND_NAME_LOCKER);
        return LockHelper.toLockSampleArray(locks);
    }

    public static AbstractRepositoryLockSample[] lockNames(IRepositoryObject object) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)object);
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        IIterator_ astIter = object.getObjectType().getAttributeSetTypes().iterator();
        while (astIter.hasNext()) {
            locks.addAll(LockHelper.doLockIDs(object.getAttributeSet((IRepositoryAttributeSetType)astIter.next()), NAME_LOCKER));
        }
        return LockHelper.toLockSampleArray(locks);
    }

    private static List<AbstractRepositoryLockSample> doLockIDs(IRepositoryAttributeSet attributeSet, IDTypeChecker idTypeChecker) throws EXNotReproducibleSnapshot {
        assert (attributeSet != null);
        assert (idTypeChecker != null);
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        for (IRepositoryPropertyType propertyType : attributeSet.getAttributeSetType().getPropertyTypes()) {
            RepositoryPropertyTypeIDType idType = propertyType.getIDType();
            if (!idTypeChecker.mustBeLocked(idType)) continue;
            locks.add((AbstractRepositoryLockSample)RepositoryIDLockSample.createLock((IRepositoryProperty)attributeSet.getProperty(propertyType)));
        }
        return locks;
    }

    public static AbstractRepositoryLockSample[] lockAuthorizationChange(IRepositoryObject object) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)object);
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        locks.add((AbstractRepositoryLockSample)RepositoryObjectLockSample.createMoveExclusiveLock((IRepositoryObject)object));
        IRepositoryObject parent = object;
        do {
            assert (parent != null);
            IRepositoryAttributeSet parentAttributeSet = parent.getParentAttributeSet();
            if (parentAttributeSet != null) {
                parent = parentAttributeSet.getObject();
                assert (parent != null);
                locks.add((AbstractRepositoryLockSample)RepositoryObjectLockSample.createMoveSharedLock((IRepositoryObject)parent));
                continue;
            }
            parent = null;
        } while (parent != null);
        return LockHelper.toLockSampleArray(locks);
    }

    public static AbstractRepositoryLockSample[] lockCrossLinkRelation(ICrossLinkRepositoryRelation relation) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)relation);
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        locks.add((AbstractRepositoryLockSample)CrossLinkRepositoryRelationLockSample.createLock((ICrossLinkRepositoryRelation)relation));
        for (ICrossLinkRepositoryRelationContributionType rcType : relation.getRelationType().getAllRelationContributionTypes()) {
            ICrossLinkRepositoryRelationContribution relationContribution = relation.getRelationContribution(rcType);
            locks.add(LockHelper.lockParent(relationContribution.getAttributeSet()));
        }
        return LockHelper.toLockSampleArray(locks);
    }

    public static AbstractRepositoryLockSample[] lockOccurrenceRelation(IOccurrenceRepositoryRelation relation) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)relation);
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        locks.add((AbstractRepositoryLockSample)OccurrenceRepositoryRelationLockSample.createLock((IOccurrenceRepositoryRelation)relation));
        IRepositoryAttributeSet occurrenceContainingPropertyAS = relation.getOccurrenceContainingProperty().getAttributeSet();
        locks.add(LockHelper.lockParent(occurrenceContainingPropertyAS));
        locks.add((AbstractRepositoryLockSample)RepositoryObjectLockSample.createSharedLock((IRepositoryObject)relation.getOccuringObject()));
        return LockHelper.toLockSampleArray(locks);
    }

    public static AbstractRepositoryLockSample[] lockMovePath(IRepositoryObject objectToMove, IRepositoryAttributeSet oldParentAS, IRepositoryAttributeSet newParentAS) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)objectToMove);
        Assert.checkArgumentBeeingNotNull((Object)oldParentAS);
        Assert.checkArgumentBeeingNotNull((Object)newParentAS);
        ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
        if (oldParentAS.getAttributeSetType().getConflictType() == RepositoryAttributeSetTypeConflictType.IS_CONFLICTING) {
            locks.add((AbstractRepositoryLockSample)RepositoryAttributeSetLockSample.createLock((IRepositoryAttributeSet)oldParentAS));
        }
        if (newParentAS.getAttributeSetType().getConflictType() == RepositoryAttributeSetTypeConflictType.IS_CONFLICTING) {
            locks.add((AbstractRepositoryLockSample)RepositoryAttributeSetLockSample.createLock((IRepositoryAttributeSet)newParentAS));
        }
        locks.add((AbstractRepositoryLockSample)RepositoryObjectLockSample.createMoveExclusiveLock((IRepositoryObject)objectToMove));
        List<IRepositoryObject> oldAncestors = LockHelper.getAncestorsAndSelf(oldParentAS.getObject());
        assert (oldAncestors.size() > 0);
        List<IRepositoryObject> newAncestors = LockHelper.getAncestorsAndSelf(newParentAS.getObject());
        assert (newAncestors.size() > 0);
        IRepositoryObjectTypeID oldTypeID = null;
        IRepositoryPropertySetSample oldID = null;
        IRepositoryObjectTypeID newTypeID = null;
        IRepositoryPropertySetSample newID = null;
        int oldIndex = oldAncestors.size() - 1;
        int newIndex = newAncestors.size() - 1;
        do {
            if (oldIndex >= 0) {
                IRepositoryObject oldAncestor = oldAncestors.get(oldIndex);
                IRepositoryObjectType oldType = oldAncestor.getObjectType();
                oldTypeID = oldType.getRepositoryObjectTypeID();
                oldID = oldAncestor.getAttributeSet(oldType.getIDAttributeSetType()).sample();
                --oldIndex;
            }
            if (newIndex >= 0) {
                IRepositoryObject newAncestor = newAncestors.get(newIndex);
                IRepositoryObjectType newType = newAncestor.getObjectType();
                newTypeID = newType.getRepositoryObjectTypeID();
                newID = newAncestor.getAttributeSet(newType.getIDAttributeSetType()).sample();
                --newIndex;
            }
            Assert.checkState((oldIndex >= 0 && newIndex >= 0 ? 1 : 0) != 0, (String)"No differing parent.");
            assert (oldTypeID != null && newTypeID != null && oldID != null && newID != null);
        } while (IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)oldTypeID, (Object)newTypeID) && RepositorySamples.isEqual((IRepositoryPropertySetSample)oldID, newID));
        assert (oldIndex >= 0 || newIndex >= 0);
        Assert.checkState((oldIndex + 1 >= 0 && oldIndex + 1 < oldAncestors.size() ? 1 : 0) != 0, (String)"No common parent.");
        assert (newIndex + 1 >= 0 && newIndex + 1 < newAncestors.size());
        int i = 0;
        while (i <= oldIndex) {
            locks.add((AbstractRepositoryLockSample)RepositoryObjectLockSample.createMoveSharedLock((IRepositoryObject)oldAncestors.get(i)));
            ++i;
        }
        locks.add((AbstractRepositoryLockSample)RepositoryObjectLockSample.createSharedLock((IRepositoryObject)oldAncestors.get(oldIndex + 1)));
        i = newIndex;
        while (i >= 0) {
            locks.add((AbstractRepositoryLockSample)RepositoryObjectLockSample.createMoveSharedLock((IRepositoryObject)newAncestors.get(i)));
            --i;
        }
        return LockHelper.toLockSampleArray(locks);
    }

    private static List<IRepositoryObject> getAncestorsAndSelf(IRepositoryObject object) throws EXNotReproducibleSnapshot {
        IRepositoryAttributeSet parentAS;
        assert (object != null);
        ArrayList<IRepositoryObject> ancestors = new ArrayList<IRepositoryObject>();
        ancestors.add(object);
        IRepositoryObject parent = object;
        do {
            if ((parentAS = parent.getParentAttributeSet()) == null) continue;
            parent = parentAS.getObject();
            ancestors.add(parent);
        } while (parentAS != null);
        return ancestors;
    }

    private static AbstractRepositoryLockSample[] toLockSampleArray(List<AbstractRepositoryLockSample> locks) {
        assert (locks != null);
        return locks.toArray(new AbstractRepositoryLockSample[locks.size()]);
    }

    private static interface IDTypeChecker {
        public boolean mustBeLocked(RepositoryPropertyTypeIDType var1);
    }
}

