/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions;

import com.arcway.lib.java.Assert;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.transactions.IRepositoryTransactionAdmin;
import com.arcway.repository.implementation.transactions.RepositoryTPTransaction;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.transactions.AbstractRepositoryAction;
import com.arcway.repository.interFace.transactions.IRepositoryActionStruct;
import com.arcway.repository.interFace.transactions.IRepositoryElementaryActionFactory;
import com.arcway.repository.interFace.transactions.IRepositoryPreActionFactory;
import com.arcway.repository.interFace.transactions.IRepositoryReActionFactory;
import com.arcway.repository.interFace.transactions.IRepositoryTransaction;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionManager;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionManagerListener;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionStateChangeListener;
import com.arcway.repository.interFace.transactions.ITransactionExecutionWrapper;
import com.arcway.repository.interFace.transactions.RepositoryMergeState;
import com.arcway.repository.interFace.transactions.RepositoryTransactionState;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RepositoryTransactionWrapper
implements IRepositoryTransactionAdmin {
    private static final ILogger logger = Logger.getLogger(RepositoryTransactionWrapper.class);
    private IRepositoryTransactionAdmin realTransaction;
    private final List listeners = new ArrayList();
    private final IRepositoryTransactionStateChangeListener backendListener = new IRepositoryTransactionStateChangeListener(){

        public void stateChanged(IRepositoryTransaction transaction) {
            RepositoryTransactionWrapper.this.notifyListeners();
        }
    };

    public RepositoryTransactionWrapper(IRepositoryTransactionManager tm, IRepositorySnapshotRW snapshot, ITransactionExecutionWrapper transactionExecutionWrapper) {
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        TransactionManagerProxy tpProxy = new TransactionManagerProxy(tm);
        this.realTransaction = new RepositoryTPTransaction(tpProxy, snapshot, transactionExecutionWrapper);
        this.realTransaction.addListener(this.backendListener);
    }

    @Override
    public void addListener(IRepositoryTransactionStateChangeListener listener) {
        Assert.checkArgumentBeeingNotNull((Object)listener);
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(IRepositoryTransactionStateChangeListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IRepositoryTransactionStateChangeListener l : this.listeners) {
            try {
                l.stateChanged((IRepositoryTransaction)this);
            }
            catch (RuntimeException e) {
                logger.warn((Throwable)e);
            }
        }
    }

    public void closeTransaction() {
        this.realTransaction.closeTransaction();
    }

    public IRepositoryActionStruct[] getChildActions(IRepositoryActionStruct action) {
        return this.realTransaction.getChildActions(action);
    }

    public IRepositoryTransaction[] getPredecessorTransactions() {
        return this.realTransaction.getPredecessorTransactions();
    }

    public AbstractRepositoryLockSample[] getRequiredLocks() {
        return this.realTransaction.getRequiredLocks();
    }

    public IRepositoryTransaction[] getSuccessorTransactions() {
        return this.realTransaction.getSuccessorTransactions();
    }

    public IRepositoryActionStruct[] getTopLevelActions() {
        return this.realTransaction.getTopLevelActions();
    }

    public boolean hasChildActions(IRepositoryActionStruct action) {
        return this.realTransaction.hasChildActions(action);
    }

    public boolean hasTopLevelActions() {
        return this.realTransaction.hasTopLevelActions();
    }

    public void redoTransaction() throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        this.realTransaction.redoTransaction();
    }

    public void undoTransaction() throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        this.realTransaction.undoTransaction();
    }

    public void appendAction(AbstractRepositoryAction action) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        this.realTransaction.appendAction(action);
    }

    public IRepositoryElementaryActionFactory getElementaryActionFactory() {
        return this.realTransaction.getElementaryActionFactory();
    }

    public IRepositorySnapshotRO getSnapshot() {
        return this.realTransaction.getSnapshot();
    }

    public RepositoryTransactionState getState() {
        return this.realTransaction.getState();
    }

    public long getTransactionID() {
        return this.realTransaction.getTransactionID();
    }

    @Override
    public IRepositoryTransactionAdmin cloneTransaction(IRepositorySnapshotRW snapshot) {
        this.realTransaction.removeListener(this.backendListener);
        this.realTransaction = this.realTransaction.cloneTransaction(snapshot);
        this.realTransaction.addListener(this.backendListener);
        return this;
    }

    public boolean executeTopLevelActions() {
        return this.realTransaction.executeTopLevelActions();
    }

    public IRepositoryTransaction getWrappedTransaction() {
        return this.realTransaction;
    }

    public RepositoryMergeState getMergeState() {
        return this.realTransaction.getMergeState();
    }

    public RepositoryMergeState getPredecessorMergeState() {
        return this.realTransaction.getPredecessorMergeState();
    }

    @Override
    public void setMergeState(RepositoryMergeState newState) {
        this.realTransaction.setMergeState(newState);
    }

    @Override
    public void setPredecessorMergeState(RepositoryMergeState newState) {
        this.realTransaction.setPredecessorMergeState(newState);
    }

    private class TransactionManagerProxy
    implements IRepositoryTransactionManager {
        private final IRepositoryTransactionManager manager;

        public TransactionManagerProxy(IRepositoryTransactionManager tm) {
            Assert.checkArgumentBeeingNotNull((Object)tm);
            this.manager = tm;
        }

        public void executeAsTransaction(AbstractRepositoryAction action) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
            this.manager.executeAsTransaction(action);
        }

        public IRepositoryTransaction[] getConflictingOpenTransactions(IRepositoryTransaction transaction, AbstractRepositoryLockSample[] locks) {
            assert (transaction == RepositoryTransactionWrapper.this.realTransaction);
            return this.manager.getConflictingOpenTransactions((IRepositoryTransaction)RepositoryTransactionWrapper.this, locks);
        }

        public IRepositoryElementaryActionFactory getElementaryActionFactory() {
            return this.manager.getElementaryActionFactory();
        }

        public Set getPreActions(AbstractRepositoryAction action) {
            return this.manager.getPreActions(action);
        }

        public IRepositoryTransaction[] getPredecessorTransactions(IRepositoryTransaction transaction) {
            assert (transaction == RepositoryTransactionWrapper.this.realTransaction);
            return this.manager.getPredecessorTransactions((IRepositoryTransaction)RepositoryTransactionWrapper.this);
        }

        public Set getReActions(AbstractRepositoryAction action) {
            return this.manager.getReActions(action);
        }

        public IRepositoryTransaction[] getSuccessorTransactions(IRepositoryTransaction transaction) {
            assert (transaction == RepositoryTransactionWrapper.this.realTransaction);
            return this.manager.getSuccessorTransactions((IRepositoryTransaction)RepositoryTransactionWrapper.this);
        }

        public long getTransactionID(IRepositoryTransaction transaction) {
            assert (transaction == RepositoryTransactionWrapper.this.realTransaction);
            return this.manager.getTransactionID((IRepositoryTransaction)RepositoryTransactionWrapper.this);
        }

        public IRepositoryTransaction[] getTransactions() {
            return this.manager.getTransactions();
        }

        public IRepositoryTransaction openTransaction() throws EXNotReproducibleSnapshot {
            return this.manager.openTransaction();
        }

        public IRepositoryTransaction openTransaction(IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
            return this.manager.openTransaction(snapshotID);
        }

        public void registerPreActionFactory(Class actionType, IRepositoryPreActionFactory factory) {
            this.manager.registerPreActionFactory(actionType, factory);
        }

        public void registerReActionFactory(Class actionType, IRepositoryReActionFactory factory) {
            this.manager.registerReActionFactory(actionType, factory);
        }

        public void shutdown() {
            this.manager.shutdown();
        }

        public void addListener(IRepositoryTransactionManagerListener listener) {
            this.manager.addListener(listener);
        }

        public void removeListener(IRepositoryTransactionManagerListener listener) {
            this.manager.addListener(listener);
        }

        public void clearModifications() {
            this.manager.clearModifications();
        }

        public void workspaceLocksChanged() {
            this.manager.workspaceLocksChanged();
        }

        public void merge() {
            this.manager.merge();
        }

        public boolean undoModifications() {
            return this.manager.undoModifications();
        }
    }
}

