/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions;

import com.arcway.lib.java.Assert;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.lock.RepositoryLocks;
import com.arcway.repository.implementation.transactions.IRepositoryTransactionAdmin;
import com.arcway.repository.implementation.transactions.RepositoryTransactionWrapper;
import com.arcway.repository.implementation.transactions.actions.RepositoryElementaryActionFactory;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.transactions.AbstractRepositoryAction;
import com.arcway.repository.interFace.transactions.IRepositoryElementaryActionFactory;
import com.arcway.repository.interFace.transactions.IRepositoryPreActionFactory;
import com.arcway.repository.interFace.transactions.IRepositoryReActionFactory;
import com.arcway.repository.interFace.transactions.IRepositoryTransaction;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionManager;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionManagerListener;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionStateChangeListener;
import com.arcway.repository.interFace.transactions.ITransactionExecutionWrapper;
import com.arcway.repository.interFace.transactions.RepositoryTransactionState;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RepositoryTransactionManager
implements IRepositoryTransactionManager {
    private static final ILogger logger = Logger.getLogger(RepositoryTransactionManager.class);
    private final IRepositoryInterfaceRO readInterface;
    private IRepositorySnapshotRW backendSnapshot = null;
    private final List closedTransactions = new ArrayList();
    private final List openTransactions = new ArrayList();
    private final List toBeMergedTransactions = new ArrayList();
    private final IRepositoryTransactionStateChangeListener stateChangeListener = new IRepositoryTransactionStateChangeListener(){

        public void stateChanged(IRepositoryTransaction transaction) {
            block2: {
                if (!$assertionsDisabled && transaction == null) {
                    throw new AssertionError();
                }
                if (!($assertionsDisabled || RepositoryTransactionManager.this.closedTransactions.contains(transaction) || RepositoryTransactionManager.this.openTransactions.contains(transaction) || RepositoryTransactionManager.this.toBeMergedTransactions.contains(transaction))) {
                    throw new AssertionError();
                }
                RepositoryTransactionState state = transaction.getState();
                if (state != RepositoryTransactionState.CLOSED) break block2;
                RepositoryTransactionManager.this.transactionClosed(transaction);
            }
        }
    };
    private final Map preActionFactories = new HashMap();
    private final Map reActionFactories = new HashMap();
    private final GetActionStrategy preActionStrategy = new GetActionStrategy(){

        @Override
        public AbstractRepositoryAction getAction(AbstractRepositoryAction causingAction, Object factory) {
            if (!$assertionsDisabled && !(factory instanceof IRepositoryPreActionFactory)) {
                throw new AssertionError();
            }
            return ((IRepositoryPreActionFactory)factory).getPreAction(causingAction);
        }

        @Override
        public Map getActionMap() {
            return RepositoryTransactionManager.this.preActionFactories;
        }
    };
    private final GetActionStrategy reActionStrategy = new GetActionStrategy(){

        @Override
        public AbstractRepositoryAction getAction(AbstractRepositoryAction causingAction, Object factory) {
            if (!$assertionsDisabled && !(factory instanceof IRepositoryReActionFactory)) {
                throw new AssertionError();
            }
            return ((IRepositoryReActionFactory)factory).getReAction(causingAction);
        }

        @Override
        public Map getActionMap() {
            return RepositoryTransactionManager.this.reActionFactories;
        }
    };
    private List listeners = new ArrayList();
    private final IRepositoryElementaryActionFactory elementaryActionFactory = new RepositoryElementaryActionFactory();
    private final ITransactionExecutionWrapper transactionExecutionWrapper;

    public RepositoryTransactionManager(IRepositoryInterfaceRO readOnly, ITransactionExecutionWrapper transactionExecutionWrapper) {
        Assert.checkArgumentBeeingNotNull((Object)readOnly);
        this.readInterface = readOnly;
        this.transactionExecutionWrapper = transactionExecutionWrapper;
    }

    public long getTransactionID(IRepositoryTransaction transaction) {
        assert (transaction != null);
        long result = this.closedTransactions.indexOf(transaction);
        if (result < 0L) {
            result = this.openTransactions.indexOf(transaction);
            if (result < 0L) {
                result = this.toBeMergedTransactions.indexOf(transaction);
                Assert.checkState((result >= 0L ? 1 : 0) != 0, (String)"Unknown transaction");
                result += (long)this.openTransactions.size();
            }
            result += (long)this.closedTransactions.size();
        }
        return result;
    }

    public IRepositoryTransaction openTransaction(IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)snapshotID);
        return this.doOpenTransaction(snapshotID, this.transactionExecutionWrapper);
    }

    public IRepositoryTransaction openTransaction() throws EXNotReproducibleSnapshot {
        return this.doOpenTransaction(this.getCurrentSnapshotID(), this.transactionExecutionWrapper);
    }

    private IRepositoryPropertySetSample getCurrentSnapshotID() {
        IRepositoryObjectSample snapshotSample = this.readInterface.sampleCurrentSnapshotInformation();
        return RepositorySamples.getSnapshotID((IRepositoryObjectSample)snapshotSample, (IRepositoryTypeManagerRO)this.readInterface.getTypeManager());
    }

    private IRepositoryTransactionAdmin doOpenTransaction(IRepositoryPropertySetSample snapshotID, ITransactionExecutionWrapper transactionExecutionWrapper) throws EXNotReproducibleSnapshot {
        assert (snapshotID != null);
        RepositoryTransactionWrapper result = new RepositoryTransactionWrapper(this, this.getBackendSnapshot(snapshotID), transactionExecutionWrapper);
        this.openTransactions.add(result);
        result.addListener(this.stateChangeListener);
        this.notifyListeners();
        return result;
    }

    private IRepositorySnapshotRW getBackendSnapshot(IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
        boolean updateBackendSnapshot;
        assert (snapshotID != null);
        if (this.backendSnapshot == null) {
            updateBackendSnapshot = true;
        } else {
            IRepositoryPropertySetSample oldSnapshotID = RepositorySamples.getSnapshotID((IRepositoryObjectSample)this.backendSnapshot.getSnapshotInformation(), (IRepositoryTypeManagerRO)this.backendSnapshot.getTypeManager());
            boolean bl = updateBackendSnapshot = !RepositorySamples.isEqual((IRepositoryPropertySetSample)oldSnapshotID, (IRepositoryPropertySetSample)snapshotID);
        }
        if (updateBackendSnapshot) {
            IRepositorySnapshotRO snapshot = this.readInterface.openSnapshot(snapshotID);
            if (snapshot instanceof IRepositorySnapshotRW) {
                if (this.backendSnapshot != null) {
                    this.backendSnapshot.closeSnapshot();
                }
                this.backendSnapshot = (IRepositorySnapshotRW)snapshot;
            } else {
                snapshot.closeSnapshot();
                Assert.unsupportedOperation((String)"Modifications are not allowed by this repository instance.");
            }
        }
        return this.backendSnapshot;
    }

    public void shutdown() {
        if (this.backendSnapshot != null) {
            this.backendSnapshot.closeSnapshot();
            this.backendSnapshot = null;
        }
        this.removeStateListener(this.closedTransactions);
        this.removeStateListener(this.openTransactions);
        this.removeStateListener(this.toBeMergedTransactions);
    }

    private void removeStateListener(List transactions) {
        assert (transactions != null);
        for (IRepositoryTransactionAdmin transaction : transactions) {
            transaction.removeListener(this.stateChangeListener);
        }
    }

    public void registerPreActionFactory(Class actionType, IRepositoryPreActionFactory factory) {
        this.registerActionFactory(this.preActionFactories, actionType, factory);
    }

    public Set getPreActions(AbstractRepositoryAction action) {
        return this.getActions(action, this.preActionStrategy);
    }

    public void registerReActionFactory(Class actionType, IRepositoryReActionFactory factory) {
        this.registerActionFactory(this.reActionFactories, actionType, factory);
    }

    public Set getReActions(AbstractRepositoryAction action) {
        return this.getActions(action, this.reActionStrategy);
    }

    private void registerActionFactory(Map actionFactories, Class actionType, Object factory) {
        assert (actionFactories != null);
        Assert.checkArgumentBeeingNotNull((Object)actionType);
        Assert.checkArgumentBeeingNotNull((Object)factory);
        assert (factory instanceof IRepositoryPreActionFactory || factory instanceof IRepositoryReActionFactory);
        ArrayList<Object> factories = (ArrayList<Object>)actionFactories.get(actionType);
        if (factories == null) {
            factories = new ArrayList<Object>();
        }
        if (!factories.contains(factory)) {
            factories.add(factory);
        }
        actionFactories.put(actionType, factories);
    }

    private Set getActions(AbstractRepositoryAction action, GetActionStrategy strategy) {
        Assert.checkArgumentBeeingNotNull((Object)action);
        assert (strategy != null);
        HashSet<AbstractRepositoryAction> result = new HashSet<AbstractRepositoryAction>();
        List types = this.getTypes(new ArrayList(), action.getClass());
        for (Class actionType : types) {
            List factories = (List)strategy.getActionMap().get(actionType);
            if (factories == null) continue;
            Iterator factoryIter = factories.iterator();
            while (factoryIter.hasNext()) {
                AbstractRepositoryAction newAction = strategy.getAction(action, factoryIter.next());
                if (newAction == null) continue;
                result.add(newAction);
            }
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return result;
    }

    private List getTypes(List types, Class clazz) {
        assert (types != null);
        assert (clazz != null);
        types.add(clazz);
        types.addAll(Arrays.asList(clazz.getInterfaces()));
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return types;
        }
        return this.getTypes(types, superClass);
    }

    public IRepositoryElementaryActionFactory getElementaryActionFactory() {
        return this.elementaryActionFactory;
    }

    public IRepositoryTransaction[] getTransactions() {
        ArrayList list = new ArrayList(this.closedTransactions.size() + this.openTransactions.size() + this.toBeMergedTransactions.size());
        list.addAll(this.closedTransactions);
        list.addAll(this.openTransactions);
        list.addAll(this.toBeMergedTransactions);
        return list.toArray(new IRepositoryTransaction[list.size()]);
    }

    public IRepositoryTransaction[] getSuccessorTransactions(IRepositoryTransaction transaction) {
        ArrayList dependentTransactions;
        Assert.checkArgumentBeeingNotNull((Object)transaction);
        int transactionIndex = this.closedTransactions.indexOf(transaction);
        if (transactionIndex < 0) {
            assert (this.openTransactions.contains(transaction) || this.toBeMergedTransactions.contains(transaction));
            dependentTransactions = Collections.EMPTY_LIST;
        } else {
            dependentTransactions = new ArrayList();
            AbstractRepositoryLockSample[] locks = transaction.getRequiredLocks();
            this.addConflictingTransactions(locks, transactionIndex + 1, this.closedTransactions.size(), this.closedTransactions, dependentTransactions);
            this.addConflictingTransactions(locks, 0, this.openTransactions.size(), this.openTransactions, dependentTransactions);
        }
        return dependentTransactions.toArray(new IRepositoryTransaction[dependentTransactions.size()]);
    }

    public IRepositoryTransaction[] getPredecessorTransactions(IRepositoryTransaction transaction) {
        Assert.checkArgumentBeeingNotNull((Object)transaction);
        int transactionIndex = this.closedTransactions.indexOf(transaction);
        if (transactionIndex < 0) {
            assert (this.openTransactions.contains(transaction) || this.toBeMergedTransactions.contains(transaction));
            transactionIndex = this.closedTransactions.size();
        }
        ArrayList dependentTransactions = new ArrayList();
        AbstractRepositoryLockSample[] locks = transaction.getRequiredLocks();
        this.addConflictingTransactions(locks, 0, transactionIndex, this.closedTransactions, dependentTransactions);
        return dependentTransactions.toArray(new IRepositoryTransaction[dependentTransactions.size()]);
    }

    private void addConflictingTransactions(AbstractRepositoryLockSample[] locks, int startIndex, int endIndex, List transactions, List resultList) {
        assert (locks != null && transactions != null && resultList != null);
        int i = startIndex;
        while (i < endIndex) {
            IRepositoryTransaction t = (IRepositoryTransaction)transactions.get(i);
            AbstractRepositoryLockSample[] otherLocks = t.getRequiredLocks();
            if (RepositoryLocks.conflicting((AbstractRepositoryLockSample[])locks, (AbstractRepositoryLockSample[])otherLocks)) {
                resultList.add(t);
            }
            ++i;
        }
    }

    public IRepositoryTransaction[] getConflictingOpenTransactions(IRepositoryTransaction transaction, AbstractRepositoryLockSample[] locks) {
        ArrayList conflictingTransactions;
        assert (transaction != null && locks != null);
        int transactionIndex = this.openTransactions.indexOf(transaction);
        Assert.checkState((transactionIndex >= 0 ? 1 : 0) != 0, (String)"Transaction is not open.");
        if (this.openTransactions.size() == 1 || locks.length == 0) {
            conflictingTransactions = Collections.EMPTY_LIST;
        } else {
            conflictingTransactions = new ArrayList();
            this.addConflictingTransactions(locks, 0, transactionIndex, this.openTransactions, conflictingTransactions);
            this.addConflictingTransactions(locks, transactionIndex + 1, this.openTransactions.size(), this.openTransactions, conflictingTransactions);
        }
        return conflictingTransactions.toArray(new IRepositoryTransaction[conflictingTransactions.size()]);
    }

    public void executeAsTransaction(AbstractRepositoryAction action) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        Assert.checkArgumentBeeingNotNull((Object)action);
        IRepositoryTransactionAdmin t = null;
        boolean failed = false;
        try {
            try {
                t = this.doOpenTransaction(this.getCurrentSnapshotID(), this.transactionExecutionWrapper);
                t.appendAction(action);
                t.closeTransaction();
            }
            catch (Error e) {
                failed = true;
                throw e;
            }
            catch (RuntimeException e) {
                failed = true;
                throw e;
            }
            catch (EXNotReproducibleSnapshot e) {
                failed = true;
                throw e;
            }
            catch (EXTransactionExecution e) {
                failed = true;
                throw e;
            }
            catch (EXPermissionDenied e) {
                failed = true;
                throw e;
            }
            catch (EXLockDenied e) {
                failed = true;
                throw e;
            }
        }
        finally {
            if (failed && this.openTransactions.remove(t)) {
                assert (t != null);
                t.removeListener(this.stateChangeListener);
            }
        }
    }

    public void merge() {
        try {
            IRepositorySnapshotRW snapshot = this.getBackendSnapshot(this.getCurrentSnapshotID());
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean compareLockSets(IRepositoryTransaction transaction, AbstractRepositoryLockSample[] oldLocks) {
        boolean result;
        assert (transaction != null && oldLocks != null);
        AbstractRepositoryLockSample[] newLocks = transaction.getRequiredLocks();
        if (oldLocks.length != newLocks.length) {
            result = false;
        } else {
            result = true;
            AbstractRepositoryLockSample[] abstractRepositoryLockSampleArray = newLocks;
            int n = newLocks.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractRepositoryLockSample lock = abstractRepositoryLockSampleArray[n2];
                boolean notFound = true;
                AbstractRepositoryLockSample[] abstractRepositoryLockSampleArray2 = oldLocks;
                int n3 = oldLocks.length;
                int n4 = 0;
                while (n4 < n3) {
                    AbstractRepositoryLockSample element = abstractRepositoryLockSampleArray2[n4];
                    if (lock.isEqualTo(element)) {
                        notFound = false;
                        break;
                    }
                    ++n4;
                }
                if (notFound) {
                    result = false;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private Map getTransactionDependencies() {
        HashMap<IRepositoryTransaction, IRepositoryTransaction[]> dependencies = new HashMap<IRepositoryTransaction, IRepositoryTransaction[]>();
        for (IRepositoryTransaction transaction : this.closedTransactions) {
            dependencies.put(transaction, this.getPredecessorTransactions(transaction));
        }
        for (IRepositoryTransaction transaction : this.openTransactions) {
            dependencies.put(transaction, this.getPredecessorTransactions(transaction));
        }
        return dependencies;
    }

    private Map getTransactionLocks() {
        HashMap<IRepositoryTransaction, AbstractRepositoryLockSample[]> transactionLocks = new HashMap<IRepositoryTransaction, AbstractRepositoryLockSample[]>();
        for (IRepositoryTransaction transaction : this.closedTransactions) {
            transactionLocks.put(transaction, transaction.getRequiredLocks());
        }
        for (IRepositoryTransaction transaction : this.openTransactions) {
            transactionLocks.put(transaction, transaction.getRequiredLocks());
        }
        return transactionLocks;
    }

    private List createMergedTransactions(List transactions, IRepositorySnapshotRW snapshot) {
        assert (transactions != null);
        assert (snapshot != null);
        ArrayList<IRepositoryTransactionAdmin> mergedTransactions = new ArrayList<IRepositoryTransactionAdmin>(transactions.size());
        int i = 0;
        while (i < transactions.size()) {
            IRepositoryTransactionAdmin wrapper = (IRepositoryTransactionAdmin)transactions.get(i);
            wrapper.removeListener(this.stateChangeListener);
            IRepositoryTransactionAdmin clonedTransaction = wrapper.cloneTransaction(snapshot);
            clonedTransaction.addListener(this.stateChangeListener);
            mergedTransactions.add(clonedTransaction);
            ++i;
        }
        return mergedTransactions;
    }

    private void transactionClosed(IRepositoryTransaction transaction) {
        Assert.checkArgumentBeeingNotNull((Object)transaction);
        assert (transaction.getState() == RepositoryTransactionState.CLOSED);
        assert (this.openTransactions.contains(transaction) || this.toBeMergedTransactions.contains(transaction));
        assert (!this.closedTransactions.contains(transaction));
        this.openTransactions.remove(transaction);
        this.toBeMergedTransactions.remove(transaction);
        this.closedTransactions.add(transaction);
        this.notifyListeners();
    }

    public void addListener(IRepositoryTransactionManagerListener listener) {
        Assert.checkArgumentBeeingNotNull((Object)listener);
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IRepositoryTransactionManagerListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IRepositoryTransactionManagerListener l : this.listeners) {
            try {
                l.modificationListChanged();
            }
            catch (RuntimeException e) {
                logger.warn((Throwable)e);
            }
        }
    }

    public void clearModifications() {
        Assert.checkState((boolean)this.openTransactions.isEmpty(), (String)"There must not be any open transactions when clearModifications() is called.");
        this.closedTransactions.clear();
        this.notifyListeners();
    }

    public boolean undoModifications() {
        ArrayList allTransactions = new ArrayList(this.closedTransactions.size() + this.openTransactions.size());
        allTransactions.addAll(this.closedTransactions);
        allTransactions.addAll(this.openTransactions);
        boolean result = true;
        for (IRepositoryTransactionAdmin transaction : allTransactions) {
            transaction.removeListener(this.stateChangeListener);
            try {
                transaction.undoTransaction();
            }
            catch (EXNotReproducibleSnapshot e) {
                result = false;
                logger.error("Exception during undo at transaction " + transaction.getTransactionID(), (Throwable)e);
            }
            catch (EXPermissionDenied e) {
                result = false;
                logger.error("Exception during undo at transaction " + transaction.getTransactionID(), (Throwable)e);
            }
            catch (EXLockDenied e) {
                result = false;
                logger.error("Exception during undo at transaction " + transaction.getTransactionID(), (Throwable)e);
            }
            catch (EXTransactionExecution e) {
                result = false;
                logger.error("Exception during undo at transaction " + transaction.getTransactionID(), (Throwable)e);
            }
            transaction.addListener(this.stateChangeListener);
        }
        return result;
    }

    public void workspaceLocksChanged() {
    }

    private static interface GetActionStrategy {
        public Map getActionMap();

        public AbstractRepositoryAction getAction(AbstractRepositoryAction var1, Object var2);
    }
}

