/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions;

import com.arcway.lib.java.Assert;
import com.arcway.repository.implementation.transactions.RepositoryTPTransaction;
import com.arcway.repository.interFace.transactions.AbstractRepositoryAction;
import com.arcway.repository.interFace.transactions.IRepositoryActionStruct;
import com.arcway.repository.interFace.transactions.IRepositoryTransaction;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class RepositoryActionStruct
implements IRepositoryActionStruct {
    private final Set preActions;
    private final AbstractRepositoryAction action;
    private final Set reActions;
    private final IRepositoryActionStruct parent;
    private final IRepositoryTransaction transaction;

    public RepositoryActionStruct(AbstractRepositoryAction a, IRepositoryActionStruct parentStruct, IRepositoryTransaction t) {
        Assert.checkArgumentBeeingNotNull((Object)a);
        Assert.checkArgumentBeeingNotNull((Object)t);
        this.action = a;
        this.preActions = Collections.EMPTY_SET;
        this.reActions = Collections.EMPTY_SET;
        this.parent = parentStruct;
        this.transaction = t;
    }

    public RepositoryActionStruct(AbstractRepositoryAction a, IRepositoryActionStruct parentStruct, RepositoryTPTransaction t, Set before, Set after) {
        Assert.checkArgumentBeeingNotNull((Object)a);
        Assert.checkArgumentBeeingNotNull((Object)t);
        Assert.checkArgumentBeeingNotNull((Object)before);
        Assert.checkCollectionArgumentToContainACertainType((Collection)before, RepositoryActionStruct.class);
        Assert.checkArgumentBeeingNotNull((Object)after);
        Assert.checkCollectionArgumentToContainACertainType((Collection)after, RepositoryActionStruct.class);
        this.action = a;
        this.preActions = Collections.unmodifiableSet(before);
        this.reActions = Collections.unmodifiableSet(after);
        this.parent = parentStruct;
        this.transaction = t;
    }

    public AbstractRepositoryAction getAction() {
        return this.action;
    }

    public Set getPreActions() {
        return this.preActions;
    }

    public Set getReActions() {
        return this.reActions;
    }

    public IRepositoryActionStruct getParent() {
        return this.parent;
    }

    public IRepositoryTransaction getTransaction() {
        return this.transaction;
    }
}

