/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.relation;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.RegistrationTransaction;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;
import com.arcway.repository.implementation.registration.type.relation.AbstractRepositoryRelationType;
import com.arcway.repository.implementation.registration.type.relationcontribution.AbstractRepositoryRelationContributionType;
import com.arcway.repository.interFace.chassis.exceptions.EXRelationContributionTypeIsAbstract;
import com.arcway.repository.interFace.chassis.exceptions.EXRepositoryDeclarationInvalid;
import com.arcway.repository.interFace.declaration.data.item.IItemTypeID;
import com.arcway.repository.interFace.declaration.type.IRepositoryDeclarationItemID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.relationcontribution.IAbstractRepositoryRelationContributionType;

public abstract class AbstractMultipleDimensionsRepositoryRelationType<RCTT extends AbstractRepositoryRelationContributionType<? extends AbstractRepositoryRelationType>>
extends AbstractRepositoryRelationType {
    IMapRW_<IRepositoryRelationContributionRoleID, RCTT> relationContributionTypes = new HashMap_(IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER);

    protected AbstractMultipleDimensionsRepositoryRelationType(RepositoryTypeManager repositoryTypeManager, IRepositoryRelationTypeID repositoryRelationTypeID, boolean isConcrete) {
        super(repositoryTypeManager, repositoryRelationTypeID, isConcrete);
    }

    public final ICollection_<? extends RCTT> getAllRelationContributionTypes() {
        return this.relationContributionTypes.values();
    }

    public final RCTT findRelationContributionType(IRepositoryRelationContributionRoleID roleID) {
        return (RCTT)((AbstractRepositoryRelationContributionType)this.relationContributionTypes.getByKey((Object)roleID));
    }

    public final RCTT getRelationContributionType(IRepositoryRelationContributionRoleID roleID) {
        IAbstractRepositoryRelationContributionType relationContributionType = this.findRelationContributionType(roleID);
        Assert.checkArgumentBeeingNotNull((Object)relationContributionType);
        return (RCTT)relationContributionType;
    }

    protected void assertThatAllRelationContributionTypesAreConcrete() throws EXRepositoryDeclarationInvalid {
        for (IAbstractRepositoryRelationContributionType relationContributionType : this.getAllRelationContributionTypes()) {
            if (relationContributionType.isConcreteType()) continue;
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)this.getRepositoryRelationTypeID(), (Throwable)new EXRelationContributionTypeIsAbstract(relationContributionType.getRepositoryRelationContributionRoleID()));
        }
    }

    public RCTT findReferencedRelationContributionType(RegistrationTransaction registrationTransaction, IRepositoryRelationContributionRoleID id) throws EXRepositoryDeclarationInvalid {
        IAbstractRepositoryRelationContributionType type = this.findRelationContributionType(id);
        RepositoryTypeManager.assertDeclarationItemIsFound(registrationTransaction, (IRepositoryDeclarationItemID)id, (IRepositoryDeclarationItem)type);
        return (RCTT)type;
    }
}

