/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.property;

import com.arcway.lib.java.Assert;
import com.arcway.repository.implementation.registration.transaction.RegistrationTransaction;
import com.arcway.repository.implementation.registration.type.RepositoryDeclarationItem;
import com.arcway.repository.implementation.registration.type.attributeset.RepositoryAttributeSetType;
import com.arcway.repository.implementation.registration.type.manager.RTAHookPropertyType;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;
import com.arcway.repository.implementation.registration.type.object.RepositoryObjectType;
import com.arcway.repository.implementation.registration.type.relation.OccurrenceRepositoryRelationType;
import com.arcway.repository.implementation.registration.type.relationcontribution.OccuringRepositoryRelationContributionType;
import com.arcway.repository.interFace.chassis.exceptions.EXIncompatibleTypeOfDataTypeParameters;
import com.arcway.repository.interFace.chassis.exceptions.EXRepositoryDeclarationInvalid;
import com.arcway.repository.interFace.declaration.data.item.IItemTypeID;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.IRepositoryDeclarationItemID;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeUserID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.property.RepositoryPropertyTypeIDType;
import com.arcway.repository.lib.high.declaration.data.item.ItemTypeID;
import com.arcway.repository.lib.high.declaration.type.RepositoryDeclarationItemTypeID;

public class RepositoryPropertyType
extends RepositoryDeclarationItem
implements IRepositoryPropertyType {
    public static final ItemTypeID ITEM_TYPE_ID = new RepositoryDeclarationItemTypeID(new KeySegment("propertytype"));
    private final IRepositoryPropertyTypeID repositoryPropertyTypeID;
    private final IRepositoryPropertyTypeUserID repositoryPropertyTypeUserID;
    private final RepositoryPropertyTypeIDType idType;
    private final boolean isCategoryIndependentlyFixProperty;
    RepositoryAttributeSetType relatedAttributeSetType = null;
    IRepositoryDataType dataType = null;
    IRepositoryDataTypeParameters dataTypeParameters = null;
    OccuringRepositoryRelationContributionType occuringRepositoryRelationContributionType = null;

    public static void load(RepositoryTypeManager typeManager, RegistrationTransaction registrationTransaction, IRepositoryPropertyTypeDeclaration propertyTypeDeclaration, RepositoryObjectType relatedObjectType) throws EXRepositoryDeclarationInvalid {
        IRepositoryPropertyTypeID propertyTypeID = propertyTypeDeclaration.getPropertyTypeID();
        IRepositoryPropertyTypeUserID propertyTypeUserID = propertyTypeDeclaration.getPropertyTypeUserID();
        IRepositoryAttributeSetTypeID attributeSetTypeID = propertyTypeDeclaration.getAttributeSetTypeID();
        IRepositoryDataTypeID dataTypeID = propertyTypeDeclaration.getDataTypeID();
        IRepositoryDataTypeParameters dataTypeParameters = propertyTypeDeclaration.getDataTypeParameters();
        RepositoryPropertyTypeIDType idType = propertyTypeDeclaration.getIDType();
        boolean isCategoryIndependentlyFixProperty = propertyTypeDeclaration.isCategoryIndependentlyFixProperty();
        RepositoryTypeManager.assertIdIsNotNull(registrationTransaction, IRepositoryPropertyTypeID.class, (IRepositoryDeclarationItemID)propertyTypeID);
        RepositoryTypeManager.assertIdIsNotNull(registrationTransaction, IRepositoryAttributeSetTypeID.class, (IRepositoryDeclarationItemID)attributeSetTypeID);
        RepositoryTypeManager.assertIdIsNotNull(registrationTransaction, IRepositoryDataTypeID.class, (IRepositoryDeclarationItemID)dataTypeID);
        RepositoryTypeManager.assertParameterIsNotNull(registrationTransaction, "Data Type Parameters", dataTypeParameters);
        RepositoryTypeManager.assertParameterIsNotNull(registrationTransaction, "ID Tpye", idType);
        RepositoryAttributeSetType attributeSetType = relatedObjectType.findReferencedAttributeSetType(registrationTransaction, attributeSetTypeID);
        attributeSetType.checkPropertyTypeIDIsUnused(registrationTransaction, propertyTypeID);
        IRepositoryDataType dataType = typeManager.getReferencedDataType(registrationTransaction, dataTypeID);
        RepositoryPropertyType.checkDataTypeToSupportDataTypeParameters(registrationTransaction, dataType, dataTypeParameters);
        RepositoryPropertyType newPropertyType = new RepositoryPropertyType(typeManager, propertyTypeID, propertyTypeUserID, idType, isCategoryIndependentlyFixProperty);
        registrationTransaction.execute(new RTAHookPropertyType(attributeSetType, dataType, dataTypeParameters, newPropertyType));
    }

    public static void loadOccurrenceRelationType(RepositoryObjectType occurenceObjectType, RegistrationTransaction registrationTransaction, IRepositoryPropertyTypeDeclaration propertyTypeDeclaration) throws EXRepositoryDeclarationInvalid {
        IRepositoryObjectTypeID objectTypeID = propertyTypeDeclaration.getOccuringObjectTypeID();
        if (objectTypeID != null) {
            RepositoryTypeManager typeManager = occurenceObjectType.getRepositoryTypeManagerImplementation();
            RepositoryObjectType occuringObjectType = typeManager.getReferencedObjectType(registrationTransaction, objectTypeID);
            IRepositoryPropertyTypeID propertyTypeID = propertyTypeDeclaration.getPropertyTypeID();
            RepositoryAttributeSetType attributeSetType = occurenceObjectType.findReferencedAttributeSetType(registrationTransaction, propertyTypeID);
            RepositoryPropertyType occurencePropertyType = attributeSetType.getPropertyType(propertyTypeID);
            OccurrenceRepositoryRelationType.loadConcreteOccurrenceRelationType(occuringObjectType, occurencePropertyType, registrationTransaction);
        }
    }

    private static void checkDataTypeToSupportDataTypeParameters(RegistrationTransaction registrationTransaction, IRepositoryDataType dataType, IRepositoryDataTypeParameters dataTypeParameters) throws EXRepositoryDeclarationInvalid {
        if (!dataType.getRepositoryDataTypeParemtersType().isInstance(dataTypeParameters)) {
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new EXIncompatibleTypeOfDataTypeParameters(dataType, dataTypeParameters));
        }
    }

    private RepositoryPropertyType(RepositoryTypeManager repositoryTypeManager, IRepositoryPropertyTypeID repositoryPropertyTypeID, IRepositoryPropertyTypeUserID repositoryPropertyTypeUserID, RepositoryPropertyTypeIDType idType, boolean isFixAttribute) {
        super(repositoryTypeManager);
        Assert.checkArgumentBeeingNotNull((Object)repositoryPropertyTypeID);
        this.repositoryPropertyTypeID = repositoryPropertyTypeID;
        this.repositoryPropertyTypeUserID = repositoryPropertyTypeUserID;
        this.idType = idType;
        this.isCategoryIndependentlyFixProperty = isFixAttribute;
    }

    public IItemTypeID getItemTypeID() {
        return ITEM_TYPE_ID;
    }

    public IRepositoryDeclarationItemID getRepositoryDeclarationItemID() {
        return this.getRepositoryPropertyTypeID();
    }

    public IRepositoryPropertyTypeID getRepositoryPropertyTypeID() {
        return this.repositoryPropertyTypeID;
    }

    public IRepositoryPropertyTypeUserID getRepositoryPropertyTypeUserID() {
        return this.repositoryPropertyTypeUserID;
    }

    public RepositoryPropertyTypeIDType getIDType() {
        return this.idType;
    }

    public boolean isCategoryIndependentlyFixProperty() {
        return this.isCategoryIndependentlyFixProperty;
    }

    public RepositoryAttributeSetType getAttributeSetType() {
        return this.relatedAttributeSetType;
    }

    public IRepositoryDataType getDataType() {
        return this.dataType;
    }

    public IRepositoryDataTypeParameters getDataTypeParameters() {
        return this.dataTypeParameters;
    }

    public OccuringRepositoryRelationContributionType getOccuringRelationContributionType() {
        return this.occuringRepositoryRelationContributionType;
    }
}

