/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.object;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.type.object.RepositoryObjectType;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;

public class RTAOTRegisterSubObjectType
implements IRegistrationAction {
    private final RepositoryObjectType superObjectType;
    private final RepositoryObjectType subObjectType;

    public RTAOTRegisterSubObjectType(RepositoryObjectType superObjectType, RepositoryObjectType subObjectType) {
        Assert.checkArgumentBeeingNotNull((Object)superObjectType);
        Assert.checkArgumentBeeingNotNull((Object)subObjectType);
        this.superObjectType = superObjectType;
        this.subObjectType = subObjectType;
    }

    @Override
    public void dodo() {
        IMapRW_<IRepositoryObjectTypeID, RepositoryObjectType> directSubObjectTypes = this.superObjectType.directSubObjectTypes;
        IRepositoryObjectTypeID subObjectTypeID = this.subObjectType.getRepositoryObjectTypeID();
        Assert.checkState((!directSubObjectTypes.containsKey((Object)subObjectTypeID) ? 1 : 0) != 0);
        directSubObjectTypes.put((Object)subObjectTypeID, (Object)this.subObjectType);
    }

    @Override
    public void undo() {
        IRepositoryObjectTypeID subObjectTypeID = this.subObjectType.getRepositoryObjectTypeID();
        IMapRW_<IRepositoryObjectTypeID, RepositoryObjectType> directSubObjectTypes = this.superObjectType.directSubObjectTypes;
        Assert.checkState((boolean)directSubObjectTypes.containsKey((Object)subObjectTypeID));
        directSubObjectTypes.removeAsEntry((Object)subObjectTypeID);
    }
}

