/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.module;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.type.module.RepositoryModuleType;
import com.arcway.repository.implementation.registration.type.object.RepositoryObjectType;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;

public class RTAMTRegisterObjectType
implements IRegistrationAction {
    private final RepositoryModuleType relatedModuleType;
    private final RepositoryObjectType objectType;

    public RTAMTRegisterObjectType(RepositoryModuleType relatedModuleType, RepositoryObjectType objectType) {
        Assert.checkArgumentBeeingNotNull((Object)relatedModuleType);
        Assert.checkArgumentBeeingNotNull((Object)objectType);
        this.relatedModuleType = relatedModuleType;
        this.objectType = objectType;
    }

    @Override
    public void dodo() {
        IMapRW_<IRepositoryObjectTypeID, RepositoryObjectType> allObjectTypes = this.relatedModuleType.allObjectTypesOfThisModuleType;
        IRepositoryObjectTypeID objectTypeID = this.objectType.getRepositoryObjectTypeID();
        Assert.checkState((!allObjectTypes.containsKey((Object)objectTypeID) ? 1 : 0) != 0);
        allObjectTypes.put((Object)objectTypeID, (Object)this.objectType);
    }

    @Override
    public void undo() {
        IRepositoryObjectTypeID objectTypeID = this.objectType.getRepositoryObjectTypeID();
        IMapRW_<IRepositoryObjectTypeID, RepositoryObjectType> allObjectTypes = this.relatedModuleType.allObjectTypesOfThisModuleType;
        Assert.checkState((boolean)allObjectTypes.containsKey((Object)objectTypeID));
        allObjectTypes.removeAsEntry((Object)objectTypeID);
    }
}

