/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.module;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.type.module.RepositoryModuleType;
import com.arcway.repository.implementation.registration.type.relation.CrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;

public class RTAMTRegisterCrossLinkRelationType
implements IRegistrationAction {
    private final RepositoryModuleType relatedModuleType;
    private final CrossLinkRepositoryRelationType relationType;

    public RTAMTRegisterCrossLinkRelationType(RepositoryModuleType relatedModuleType, CrossLinkRepositoryRelationType relationType) {
        Assert.checkArgumentBeeingNotNull((Object)relatedModuleType);
        Assert.checkArgumentBeeingNotNull((Object)relationType);
        this.relatedModuleType = relatedModuleType;
        this.relationType = relationType;
    }

    @Override
    public void dodo() {
        IMapRW_<IRepositoryRelationTypeID, CrossLinkRepositoryRelationType> allRelationTypes = this.relatedModuleType.allCrossLinkRelationTypesOfThisModuleType;
        IRepositoryRelationTypeID relationTypeID = this.relationType.getRepositoryRelationTypeID();
        Assert.checkState((!allRelationTypes.containsKey((Object)relationTypeID) ? 1 : 0) != 0);
        allRelationTypes.put((Object)relationTypeID, (Object)this.relationType);
    }

    @Override
    public void undo() {
        IRepositoryRelationTypeID relationTypeID = this.relationType.getRepositoryRelationTypeID();
        IMapRW_<IRepositoryRelationTypeID, CrossLinkRepositoryRelationType> allRelationTypes = this.relatedModuleType.allCrossLinkRelationTypesOfThisModuleType;
        Assert.checkState((boolean)allRelationTypes.containsKey((Object)relationTypeID));
        allRelationTypes.removeAsEntry((Object)relationTypeID);
    }
}

