/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.manager;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.listener.ListenerManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.implementation.RepositoryImplementationManager;
import com.arcway.repository.implementation.implementation.globalrepository.RepositoryGlobalRepository;
import com.arcway.repository.implementation.registration.transaction.RegistrationTransaction;
import com.arcway.repository.implementation.registration.type.EXCouldNotLoadAllDeclarations;
import com.arcway.repository.implementation.registration.type.IterativeDeclarationLoader;
import com.arcway.repository.implementation.registration.type.data.RepositoryObjectTypeCategoryDeclarationItem;
import com.arcway.repository.implementation.registration.type.item.RepositoryItemType;
import com.arcway.repository.implementation.registration.type.manager.RTAHookDataType;
import com.arcway.repository.implementation.registration.type.module.RepositoryModuleType;
import com.arcway.repository.implementation.registration.type.object.RepositoryObjectType;
import com.arcway.repository.implementation.registration.type.relation.CrossLinkRepositoryRelationType;
import com.arcway.repository.implementation.registration.type.relation.OccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotCreateImplementation;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadAllDependentModuleTypes;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadModule;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadModuleManager;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadRootModuleType;
import com.arcway.repository.interFace.chassis.exceptions.EXMultipleIDUsage;
import com.arcway.repository.interFace.chassis.exceptions.EXRepositoryDeclarationInvalid;
import com.arcway.repository.interFace.chassis.exceptions.EXUnknownDeclarationItem;
import com.arcway.repository.interFace.chassis.exceptions.EXUnknownImplementationType;
import com.arcway.repository.interFace.chassis.exceptions.EXUnknownModuleTypes;
import com.arcway.repository.interFace.chassis.exceptions.EXUnknownRepositoryObjectType;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.data.item.IItemTypeID;
import com.arcway.repository.interFace.declaration.data.item.IItemUID;
import com.arcway.repository.interFace.declaration.type.IRepositoryDeclarationItemID;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.implementation.AbstractRepositoryImplementationDescription;
import com.arcway.repository.interFace.implementation.IRepositoryImplementationManager;
import com.arcway.repository.interFace.implementation.datalayer.RepositoryDataLayerRODescription;
import com.arcway.repository.interFace.implementation.globalrepository.IRepositoryGlobalRepositoryRO;
import com.arcway.repository.interFace.plugin.extensions.IRepositoryDeclarationReader;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.IRepositoryRegistrationItem;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerListener;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRW;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.interFace.registration.type.data.IRepositoryObjectTypeCategoryMetaType;
import com.arcway.repository.interFace.registration.type.item.IRepositoryItemType;
import com.arcway.repository.interFace.registration.type.module.IRepositoryModuleType;
import com.arcway.repository.lib.high.declaration.type.relation.BaseRepositoryRelationTypeID;

public class RepositoryTypeManager
implements IRepositoryDeclarationReader,
IRepositoryTypeManagerRW {
    private static final ILogger logger = Logger.getLogger(RepositoryTypeManager.class);
    private final IRepositoryInterfaceRO repositoryInterface;
    RepositoryModuleType rootModuleType;
    IMapRW_<IRepositoryDataTypeID, IRepositoryDataType> dataTypes = new HashMap_(IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER);
    IRepositoryObjectTypeCategoryMetaType objectTypeCategoryMetaType;
    IMapRW_<IRepositoryModuleTypeID, RepositoryModuleType> allModuleTypes = new HashMap_(IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER);
    IListRW_<RepositoryModuleType> listOfAllModuleTypes = new ArrayList_();
    IMapRW_<IRepositoryObjectTypeID, RepositoryObjectType> allObjectTypes = new HashMap_(IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER);
    IMapRW_<IRepositoryRelationTypeID, CrossLinkRepositoryRelationType> allCrossLinkRelationTypes = new HashMap_(IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER);
    IMapRW_<IRepositoryRelationTypeID, OccurrenceRepositoryRelationType> allOccurenceRelationTypes = new HashMap_(IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER);
    IListRW_<RepositoryItemType> listOfAllItemTypes = new ArrayList_();
    private final ListenerManager<IRepositoryTypeManagerListener> listenerManager = new ListenerManager();

    public static void assertDeclarationItemIsFound(RegistrationTransaction registrationTransaction, IRepositoryDeclarationItemID id, IRepositoryDeclarationItem declarationItem) throws EXRepositoryDeclarationInvalid {
        if (declarationItem == null) {
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new EXUnknownDeclarationItem(id));
        }
    }

    public static void assertDeclarationItemIsNotFound(RegistrationTransaction registrationTransaction, IRepositoryDeclarationItemID id, IRepositoryDeclarationItem declarationItem) throws EXRepositoryDeclarationInvalid {
        if (declarationItem != null) {
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new EXMultipleIDUsage((IItemUID)id));
        }
    }

    public static void assertRegistrationItemIsFound(RegistrationTransaction registrationTransaction, IRepositoryDeclarationItemID id, IRepositoryRegistrationItem registrationItem) throws EXRepositoryDeclarationInvalid {
        if (registrationItem == null) {
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new EXUnknownDeclarationItem(id));
        }
    }

    public static void assertRegistrationItemIsNotFound(RegistrationTransaction registrationTransaction, IRepositoryDeclarationItemID id, IRepositoryRegistrationItem registrationItem) throws EXRepositoryDeclarationInvalid {
        if (registrationItem != null) {
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new EXMultipleIDUsage((IItemUID)id));
        }
    }

    public static void assertParameterIsNotNull(RegistrationTransaction registrationTransaction, String parameterName, Object parameter) throws EXRepositoryDeclarationInvalid {
        if (parameter == null) {
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new NullPointerException(parameterName));
        }
    }

    public static void assertCollectionIsNotEmpty(RegistrationTransaction registrationTransaction, String parameterName, ICollection_<?> parameter) throws EXRepositoryDeclarationInvalid {
        if (parameter.isEmpty()) {
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new IllegalArgumentException(parameterName));
        }
    }

    public static void assertIdsAreNotNull(RegistrationTransaction registrationTransaction, Class<? extends IRepositoryDeclarationItemID> idType, ICollection_<? extends IRepositoryDeclarationItemID> ids) throws EXRepositoryDeclarationInvalid {
        if (ids == null) {
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new NullPointerException(idType.getName()));
        }
        for (IRepositoryDeclarationItemID id : ids) {
            RepositoryTypeManager.assertIdIsNotNull(registrationTransaction, idType, id);
        }
    }

    public static void assertIdIsNotNull(RegistrationTransaction registrationTransaction, Class<? extends IRepositoryDeclarationItemID> idType, IRepositoryDeclarationItemID id) throws EXRepositoryDeclarationInvalid {
        if (id == null) {
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new NullPointerException(idType.getName()));
        }
    }

    public RepositoryTypeManager(IRepositoryInterfaceRO repositoryInterface, IRepositoryObjectTypeID rootObjectTypeID) throws EXUnknownRepositoryObjectType, EXCouldNotLoadRootModuleType, EXCouldNotLoadAllDependentModuleTypes {
        Assert.checkArgumentBeeingNotNull((Object)repositoryInterface);
        Assert.checkArgumentBeeingNotNull((Object)rootObjectTypeID);
        this.repositoryInterface = repositoryInterface;
        try {
            this.init(rootObjectTypeID, null);
        }
        catch (EXUnknownModuleTypes e) {
            logger.error("This exception will never be thrown as moduleTypeIDs was passed as null.", (Throwable)e);
        }
    }

    public RepositoryTypeManager(IRepositoryInterfaceRO repositoryInterface, IRepositoryObjectTypeID rootObjectTypeID, ISet_<IRepositoryModuleTypeID> moduleTypeIDs) throws EXUnknownRepositoryObjectType, EXUnknownModuleTypes, EXCouldNotLoadRootModuleType, EXCouldNotLoadAllDependentModuleTypes {
        Assert.checkArgumentBeeingNotNull((Object)repositoryInterface);
        Assert.checkArgumentBeeingNotNull((Object)rootObjectTypeID);
        Assert.checkArgumentBeeingNotNull(moduleTypeIDs);
        this.repositoryInterface = repositoryInterface;
        this.init(rootObjectTypeID, moduleTypeIDs);
    }

    public RepositoryTypeManager(IRepositoryInterfaceRO repositoryInterface, ICollection_<IRepositoryDataTypeRegistration> dataTypeRegistrations, IRepositoryTypeDeclaration repositoryTypeDeclaration, ICollection_<IRepositoryModuleTypeDeclaration> repositoryModuleTypeDeclarations) throws EXCouldNotLoadRootModuleType, EXCouldNotLoadAllDependentModuleTypes {
        Assert.checkArgumentBeeingNotNull((Object)repositoryInterface);
        Assert.checkArgumentBeeingNotNull((Object)repositoryTypeDeclaration);
        Assert.checkArgumentBeeingNotNull(repositoryModuleTypeDeclarations);
        this.repositoryInterface = repositoryInterface;
        HashSet_ moduleTypeIDs = new HashSet_(repositoryModuleTypeDeclarations.size() + 1, IRepositoryModuleTypeID.IS_EQUAL_MODULE_TYPE_ID_HASHER);
        moduleTypeIDs.add((Object)repositoryTypeDeclaration.getModuleTypeID());
        for (IRepositoryModuleTypeDeclaration moduleTypeDeclaration : repositoryModuleTypeDeclarations) {
            moduleTypeIDs.add((Object)moduleTypeDeclaration.getModuleTypeID());
        }
        try {
            this.init(dataTypeRegistrations, repositoryTypeDeclaration, repositoryModuleTypeDeclarations, (ISet_<IRepositoryModuleTypeID>)moduleTypeIDs);
        }
        catch (EXUnknownModuleTypes e) {
            throw new RuntimeException(e);
        }
    }

    private void init(IRepositoryObjectTypeID rootObjectTypeID, ISet_<IRepositoryModuleTypeID> moduleTypeIDs) throws EXUnknownRepositoryObjectType, EXUnknownModuleTypes, EXCouldNotLoadRootModuleType, EXCouldNotLoadAllDependentModuleTypes {
        Assert.checkArgumentBeeingNotNull((Object)rootObjectTypeID);
        IRepositoryTypeDeclaration repositoryTypeDeclaration = null;
        IIterator_ i = REPOSITORY_TYPE_DECLARATIONS.iterator();
        while (repositoryTypeDeclaration == null && i.hasNext()) {
            IRepositoryTypeDeclaration rootModuleTypeDeclaration = (IRepositoryTypeDeclaration)i.next();
            if (moduleTypeIDs != null && !moduleTypeIDs.contains((Object)rootModuleTypeDeclaration.getModuleTypeID()) || !IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER.isEqual((Object)rootObjectTypeID, (Object)rootModuleTypeDeclaration.getRootObjectTypeDeclaration().getObjectTypeID())) continue;
            repositoryTypeDeclaration = rootModuleTypeDeclaration;
        }
        if (repositoryTypeDeclaration == null) {
            throw new EXUnknownRepositoryObjectType(rootObjectTypeID);
        }
        this.init((ICollection_<IRepositoryDataTypeRegistration>)REPOSITORY_DATA_TYPE_REGISTRATIONS, repositoryTypeDeclaration, (ICollection_<IRepositoryModuleTypeDeclaration>)REPOSITORY_MODULE_TYPE_DECLARATIONS, moduleTypeIDs);
    }

    private void init(ICollection_<IRepositoryDataTypeRegistration> dataTypeRegistrations, IRepositoryTypeDeclaration rootModuleTypeDeclaration, ICollection_<IRepositoryModuleTypeDeclaration> repositoryModuleTypeDeclarations, ISet_<IRepositoryModuleTypeID> moduleTypeIDs) throws EXUnknownModuleTypes, EXCouldNotLoadRootModuleType, EXCouldNotLoadAllDependentModuleTypes {
        Assert.checkArgumentBeeingNotNull((Object)rootModuleTypeDeclaration);
        this.objectTypeCategoryMetaType = new RepositoryObjectTypeCategoryDeclarationItem(this);
        RegistrationTransaction registrationTransaction = new RegistrationTransaction(IRepositoryModuleTypeID.UNNKOWN_MODULE_TYPE_ID);
        try {
            this.loadDataTypes(registrationTransaction, dataTypeRegistrations);
        }
        catch (EXCouldNotLoadAllDeclarations e) {
            logger.warn("Some data types could not have been loaded.", (Throwable)e);
        }
        try {
            this.loadRootModuleType(rootModuleTypeDeclaration);
        }
        catch (EXRepositoryDeclarationInvalid e) {
            IRepositoryModuleTypeID rootModuleTypeID = rootModuleTypeDeclaration.getModuleTypeID();
            if (rootModuleTypeID == null) {
                rootModuleTypeID = IRepositoryModuleTypeID.UNNKOWN_MODULE_TYPE_ID;
            }
            throw new EXCouldNotLoadRootModuleType(rootModuleTypeID, e);
        }
        this.loadDependentModuleTypes(repositoryModuleTypeDeclarations, moduleTypeIDs);
        if (moduleTypeIDs != null) {
            HashSet_ remainingModuleTypeIDs = new HashSet_(moduleTypeIDs, IRepositoryModuleTypeID.IS_EQUAL_MODULE_TYPE_ID_HASHER);
            for (RepositoryModuleType currentModuleType : this.getAllModuleTypes()) {
                remainingModuleTypeIDs.remove((Object)currentModuleType.getRepositoryModuleTypeID());
            }
            if (!remainingModuleTypeIDs.isEmpty()) {
                throw new EXUnknownModuleTypes((ISet_)remainingModuleTypeIDs);
            }
        }
    }

    public IRepositoryInterfaceRO getRepositoryInterface() {
        return this.repositoryInterface;
    }

    public void loadRootModuleType(IRepositoryTypeDeclaration moduleTypeDeclaration) throws EXRepositoryDeclarationInvalid {
        IRepositoryModuleTypeID moduleTypeID = moduleTypeDeclaration.getModuleTypeID();
        RegistrationTransaction registrationTransaction = new RegistrationTransaction(moduleTypeID);
        try {
            RepositoryModuleType.loadRootModuleType(this, registrationTransaction, moduleTypeDeclaration);
        }
        catch (EXRepositoryDeclarationInvalid e) {
            registrationTransaction.discard();
            throw e;
        }
        catch (RuntimeException e) {
            registrationTransaction.discard();
            throw e;
        }
    }

    public void loadDependentModuleTypes(ICollection_<IRepositoryModuleTypeDeclaration> declarations, final ISet_<IRepositoryModuleTypeID> moduleTypeIDs) throws EXCouldNotLoadAllDependentModuleTypes {
        IterativeDeclarationLoader.loadModuleTypeDeclarations(declarations, new IterativeDeclarationLoader.ILoader(){

            @Override
            public void loadDeclaration(RegistrationTransaction innerRegistrationTransaction, Object declarationToLoad) throws EXRepositoryDeclarationInvalid {
                IRepositoryModuleTypeDeclaration castedDeclaration = (IRepositoryModuleTypeDeclaration)declarationToLoad;
                if (moduleTypeIDs == null || moduleTypeIDs.contains((Object)castedDeclaration.getModuleTypeID())) {
                    RepositoryTypeManager.this.loadDependentModuleType(innerRegistrationTransaction, castedDeclaration);
                }
            }
        });
    }

    public void loadDependentModuleType(RegistrationTransaction registrationTransaction, IRepositoryModuleTypeDeclaration moduleTypeDeclaration) throws EXRepositoryDeclarationInvalid {
        RepositoryModuleType.loadDependentModuleType(this, registrationTransaction, moduleTypeDeclaration);
    }

    public void loadDataTypes(RegistrationTransaction registrationTransaction, ICollection_<IRepositoryDataTypeRegistration> registrations) throws EXCouldNotLoadAllDeclarations {
        IterativeDeclarationLoader.loadDeclarations(registrationTransaction, registrations, new IterativeDeclarationLoader.ILoader(){

            @Override
            public void loadDeclaration(RegistrationTransaction innerRegistrationTransaction, Object declarationToLoad) throws EXRepositoryDeclarationInvalid {
                IRepositoryDataTypeRegistration castedRegistration = (IRepositoryDataTypeRegistration)declarationToLoad;
                RepositoryTypeManager.this.loadDataType(innerRegistrationTransaction, castedRegistration);
            }
        });
    }

    public void loadDataType(RegistrationTransaction registrationTransaction, IRepositoryDataTypeRegistration registration) throws EXRepositoryDeclarationInvalid {
        IRepositoryDataType dataType = registration.getRepositoryDataType();
        RepositoryTypeManager.assertParameterIsNotNull(registrationTransaction, "data type", dataType);
        this.checkDataTypeIDIsUnused(registrationTransaction, dataType.getRepositoryDataTypeID());
        registrationTransaction.execute(new RTAHookDataType(this, dataType));
    }

    public void checkDataTypeIDIsUnused(RegistrationTransaction registrationTransaction, IRepositoryDataTypeID id) throws EXRepositoryDeclarationInvalid {
        RepositoryTypeManager.assertRegistrationItemIsNotFound(registrationTransaction, (IRepositoryDeclarationItemID)id, (IRepositoryRegistrationItem)this.findDataType(id));
    }

    public IRepositoryDataType getReferencedDataType(RegistrationTransaction registrationTransaction, IRepositoryDataTypeID id) throws EXRepositoryDeclarationInvalid {
        IRepositoryDataType type = this.findDataType(id);
        RepositoryTypeManager.assertRegistrationItemIsFound(registrationTransaction, (IRepositoryDeclarationItemID)id, (IRepositoryRegistrationItem)type);
        return type;
    }

    private IRepositoryDataType findDataType(IRepositoryDataTypeID dataTypeID) {
        return (IRepositoryDataType)this.dataTypes.getByKey((Object)dataTypeID);
    }

    public void checkModuleTypeIDIsUnused(RegistrationTransaction registrationTransaction, IRepositoryModuleTypeID id) throws EXRepositoryDeclarationInvalid {
        RepositoryTypeManager.assertDeclarationItemIsNotFound(registrationTransaction, (IRepositoryDeclarationItemID)id, this.findModuleType(id));
    }

    public RepositoryModuleType getReferencedModuleType(RegistrationTransaction registrationTransaction, IRepositoryModuleTypeID id) throws EXRepositoryDeclarationInvalid {
        RepositoryModuleType type = this.findModuleType(id);
        RepositoryTypeManager.assertDeclarationItemIsFound(registrationTransaction, (IRepositoryDeclarationItemID)id, type);
        return type;
    }

    private RepositoryModuleType findModuleType(IRepositoryModuleTypeID moduleTypeID) {
        return (RepositoryModuleType)this.allModuleTypes.getByKey((Object)moduleTypeID);
    }

    public void checkObjectTypeIDIsUnused(RegistrationTransaction registrationTransaction, IRepositoryObjectTypeID id) throws EXRepositoryDeclarationInvalid {
        RepositoryTypeManager.assertDeclarationItemIsNotFound(registrationTransaction, (IRepositoryDeclarationItemID)id, this.findObjectType(id));
    }

    public RepositoryObjectType getReferencedObjectType(RegistrationTransaction registrationTransaction, IRepositoryObjectTypeID id) throws EXRepositoryDeclarationInvalid {
        RepositoryObjectType type = this.findObjectType(id);
        RepositoryTypeManager.assertDeclarationItemIsFound(registrationTransaction, (IRepositoryDeclarationItemID)id, type);
        return type;
    }

    public RepositoryObjectType findObjectType(IRepositoryObjectTypeID objectTypeID) {
        return (RepositoryObjectType)this.allObjectTypes.getByKey((Object)objectTypeID);
    }

    public void checkCrossLinkRelationTypeIDIsUnused(RegistrationTransaction registrationTransaction, IRepositoryRelationTypeID id) throws EXRepositoryDeclarationInvalid {
        RepositoryTypeManager.assertDeclarationItemIsNotFound(registrationTransaction, (IRepositoryDeclarationItemID)id, this.findCrossLinkRelationType(id));
    }

    public CrossLinkRepositoryRelationType getReferencedCrossLinkRelationType(RegistrationTransaction registrationTransaction, IRepositoryRelationTypeID id) throws EXRepositoryDeclarationInvalid {
        CrossLinkRepositoryRelationType type = this.findCrossLinkRelationType(id);
        RepositoryTypeManager.assertDeclarationItemIsFound(registrationTransaction, (IRepositoryDeclarationItemID)id, type);
        return type;
    }

    public CrossLinkRepositoryRelationType findCrossLinkRelationType(IRepositoryRelationTypeID relationTypeID) {
        Assert.checkArgument((!IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER.isEqual((Object)relationTypeID, (Object)BaseRepositoryRelationTypeID.RELATION_TYPE_ID) ? 1 : 0) != 0);
        return (CrossLinkRepositoryRelationType)this.allCrossLinkRelationTypes.getByKey((Object)relationTypeID);
    }

    public RepositoryModuleType getRootModuleType() {
        return this.rootModuleType;
    }

    public IList_<? extends RepositoryModuleType> getAllModuleTypes() {
        return this.listOfAllModuleTypes;
    }

    public ICollection_<? extends RepositoryObjectType> getAllObjectTypes() {
        return this.allObjectTypes.values();
    }

    public RepositoryObjectType getObjectType(IRepositoryObjectTypeID objectTypeID) {
        RepositoryObjectType type = this.findObjectType(objectTypeID);
        if (type == null) {
            throw new RuntimeException((Throwable)new EXUnknownDeclarationItem((IRepositoryDeclarationItemID)objectTypeID));
        }
        return type;
    }

    public IRepositoryObjectTypeCategoryMetaType getObjectTypeCategoryMetaType() {
        return this.objectTypeCategoryMetaType;
    }

    public CrossLinkRepositoryRelationType getCrossLinkRelationType(IRepositoryRelationTypeID relationTypeID) {
        CrossLinkRepositoryRelationType type = this.findCrossLinkRelationType(relationTypeID);
        if (type == null) {
            throw new RuntimeException((Throwable)new EXUnknownDeclarationItem((IRepositoryDeclarationItemID)relationTypeID));
        }
        return type;
    }

    public ICollection_<? extends CrossLinkRepositoryRelationType> getAllCrossLinkRelationTypes() {
        return this.allCrossLinkRelationTypes.values();
    }

    public IList_<? extends IRepositoryItemType> getAllItemTypes() {
        return this.listOfAllItemTypes;
    }

    public ICollection_<IRepositoryDataType> getAllDataTypes() {
        return this.dataTypes.values();
    }

    public IRepositoryDataType getDataType(IRepositoryDataTypeID dataTypeID) {
        IRepositoryDataType type = this.findDataType(dataTypeID);
        if (type == null) {
            throw new RuntimeException((Throwable)new EXUnknownDeclarationItem((IRepositoryDeclarationItemID)dataTypeID));
        }
        return type;
    }

    public IRepositoryGlobalRepositoryRO createRepositoryGlobalRepositoryRO(RepositoryDataLayerRODescription globalDataLayerDescription) throws EXCouldNotCreateImplementation {
        RepositoryGlobalRepository newGlobalRepository = new RepositoryGlobalRepository(this, globalDataLayerDescription);
        return newGlobalRepository;
    }

    public void shutdown() {
        this.listenerManager.dispose();
    }

    public IRepositoryImplementationManager createRepositoryImplementation(AbstractRepositoryImplementationDescription implementationDescription) throws EXCouldNotLoadModuleManager, EXCouldNotLoadModule, EXUnknownImplementationType {
        RepositoryImplementationManager implementationManager = new RepositoryImplementationManager((IRepositoryTypeManagerRO)this, implementationDescription);
        return implementationManager;
    }

    public ListenerManager<IRepositoryTypeManagerListener> getListenerManager() {
        return this.listenerManager;
    }

    public IRepositoryModuleType getModuleType(IRepositoryModuleTypeID moduleTypeID) {
        return (IRepositoryModuleType)this.allModuleTypes.getByKey((Object)moduleTypeID);
    }

    public OccurrenceRepositoryRelationType getOccurrenceRelationType(IRepositoryRelationTypeID relationTypeID) {
        OccurrenceRepositoryRelationType type = this.findOccurrenceRelationType(relationTypeID);
        if (type == null) {
            throw new RuntimeException((Throwable)new EXUnknownDeclarationItem((IRepositoryDeclarationItemID)relationTypeID));
        }
        return type;
    }

    public OccurrenceRepositoryRelationType findOccurrenceRelationType(IRepositoryRelationTypeID relationTypeID) {
        return (OccurrenceRepositoryRelationType)this.allOccurenceRelationTypes.getByKey((Object)relationTypeID);
    }

    public ICollection_<? extends OccurrenceRepositoryRelationType> getAllOccurrenceRelationTypes() {
        return this.allOccurenceRelationTypes.values();
    }
}

