/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.manager;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;
import com.arcway.repository.implementation.registration.type.object.RepositoryObjectType;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;

public class RTATMRegisterObjectType
implements IRegistrationAction {
    private final RepositoryTypeManager typeManager;
    private final RepositoryObjectType objectType;

    public RTATMRegisterObjectType(RepositoryTypeManager typeManager, RepositoryObjectType objectType) {
        Assert.checkArgumentBeeingNotNull((Object)typeManager);
        Assert.checkArgumentBeeingNotNull((Object)objectType);
        this.typeManager = typeManager;
        this.objectType = objectType;
    }

    @Override
    public void dodo() {
        IMapRW_<IRepositoryObjectTypeID, RepositoryObjectType> allObjectTypes = this.typeManager.allObjectTypes;
        IRepositoryObjectTypeID objectTypeID = this.objectType.getRepositoryObjectTypeID();
        Assert.checkState((!allObjectTypes.containsKey((Object)objectTypeID) ? 1 : 0) != 0);
        allObjectTypes.put((Object)objectTypeID, (Object)this.objectType);
    }

    @Override
    public void undo() {
        IRepositoryObjectTypeID objectTypeID = this.objectType.getRepositoryObjectTypeID();
        IMapRW_<IRepositoryObjectTypeID, RepositoryObjectType> allObjectTypes = this.typeManager.allObjectTypes;
        Assert.checkState((boolean)allObjectTypes.containsKey((Object)objectTypeID));
        allObjectTypes.removeAsValue((Object)objectTypeID);
    }
}

