/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.manager;

import com.arcway.lib.java.Assert;
import com.arcway.repository.implementation.registration.type.attributeset.RTAATRegisterPropertyType;
import com.arcway.repository.implementation.registration.type.attributeset.RepositoryAttributeSetType;
import com.arcway.repository.implementation.registration.type.manager.RTAHookType;
import com.arcway.repository.implementation.registration.type.object.ObjectTypeProcessor;
import com.arcway.repository.implementation.registration.type.object.RTAOTRegisterAttributeSetTypeForPropertyType;
import com.arcway.repository.implementation.registration.type.object.RepositoryObjectType;
import com.arcway.repository.implementation.registration.type.property.RTAPTSetDataType;
import com.arcway.repository.implementation.registration.type.property.RTAPTSetDataTypeParameters;
import com.arcway.repository.implementation.registration.type.property.RTAPTSetRelatedAttributeSetType;
import com.arcway.repository.implementation.registration.type.property.RepositoryPropertyType;
import com.arcway.repository.interFace.chassis.exceptions.EXRepositoryDeclarationInvalid;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;

public class RTAHookPropertyType
extends RTAHookType {
    public RTAHookPropertyType(RepositoryAttributeSetType relatedAttributeSetType, IRepositoryDataType dataType, IRepositoryDataTypeParameters dataTypeParameters, final RepositoryPropertyType propertyType) {
        super(relatedAttributeSetType.getRepositoryTypeManagerImplementation());
        Assert.checkArgumentBeeingNotNull((Object)relatedAttributeSetType);
        Assert.checkArgumentBeeingNotNull((Object)dataType);
        Assert.checkArgumentBeeingNotNull((Object)dataTypeParameters);
        Assert.checkArgumentBeeingNotNull((Object)propertyType);
        this.addRegistrationAction(new RTAPTSetRelatedAttributeSetType(propertyType, relatedAttributeSetType));
        this.addRegistrationAction(new RTAPTSetDataType(propertyType, dataType));
        this.addRegistrationAction(new RTAPTSetDataTypeParameters(propertyType, dataTypeParameters));
        final IRepositoryAttributeSetTypeID attributeSetTypeID = relatedAttributeSetType.getRepositoryAttributeSetTypeID();
        try {
            ObjectTypeProcessor.forObjectTypeAndAllSubTypes(relatedAttributeSetType.getObjectType(), new ObjectTypeProcessor.IObjectTypeVisitor(){

                @Override
                public void visit(RepositoryObjectType objectType) throws EXRepositoryDeclarationInvalid {
                    RepositoryAttributeSetType currentAttributeSetType = objectType.findAttributeSetType(attributeSetTypeID);
                    Assert.checkState((currentAttributeSetType != null ? 1 : 0) != 0);
                    RTAHookPropertyType.this.addRegistrationAction(new RTAATRegisterPropertyType(currentAttributeSetType, propertyType));
                    RTAHookPropertyType.this.addRegistrationAction(new RTAOTRegisterAttributeSetTypeForPropertyType(currentAttributeSetType, propertyType));
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

