/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.prototype;

import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.locale.LocalisationUtils;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.prototype.AbstractProcessor;
import com.arcway.repository.implementation.prototype.ElementaryOperation;
import com.arcway.repository.implementation.prototype.IProcessorOperation;
import com.arcway.repository.implementation.prototype.WeightedOperation;
import java.util.Locale;

public class SimpleProcessor
extends AbstractProcessor {
    private static final ILogger logger = Logger.getLogger(SimpleProcessor.class);

    @Override
    public void executeWhile(IIterator_<IProcessorOperation> operationIterator) {
        logger.debug("While loop started ...");
        while (operationIterator.hasNext()) {
            IProcessorOperation operation = (IProcessorOperation)operationIterator.next();
            this.executeChildOperation(operation, 0, 0, 0);
        }
        logger.debug("... while loop finished.");
    }

    @Override
    protected void executeSequence(IIterator_<WeightedOperation> weightedOperationIterator, int totalWeight) {
        logger.debug("Sequence started ...");
        int currentWeight = 0;
        while (weightedOperationIterator.hasNext()) {
            WeightedOperation weightedOperation = (WeightedOperation)weightedOperationIterator.next();
            int nextWeight = currentWeight + weightedOperation.getWeight();
            IProcessorOperation operation = weightedOperation.getOperation();
            this.executeChildOperation(operation, currentWeight, nextWeight, totalWeight);
            currentWeight = nextWeight;
        }
        logger.debug("... sequence finished.");
    }

    @Override
    protected void executeConcurrency(IIterator_<WeightedOperation> weightedOperationIterator, int totalWeight) {
        logger.debug("Concurrecy started ...");
        int currentWeight = 0;
        while (weightedOperationIterator.hasNext()) {
            WeightedOperation weightedOperation = (WeightedOperation)weightedOperationIterator.next();
            int nextWeight = currentWeight + weightedOperation.getWeight();
            IProcessorOperation operation = weightedOperation.getOperation();
            this.executeChildOperation(operation, currentWeight, nextWeight, totalWeight);
            currentWeight = nextWeight;
        }
        logger.debug("... concurrecy finished.");
    }

    @Override
    public final void executeOperation(ElementaryOperation operation) {
        this.executeChildOperation(operation, 0, 0, 0);
    }

    private void executeChildOperation(IProcessorOperation operation, int start, int end, int total) {
        logger.debug(String.valueOf(this.toPercentage(start, total)) + "% Operation " + operation + " started ...");
        this.execute(operation);
        logger.debug(String.valueOf(this.toPercentage(end, total)) + "% ... operation " + operation + " finished.");
    }

    private String toPercentage(int where, int total) {
        String percentage = total <= 0 ? "???" : "   " + LocalisationUtils.roundLocalized((Double)((double)where / (double)total), (int)0, (boolean)false, (boolean)true, (Locale)Locale.getDefault());
        return percentage.substring(percentage.length() - 3);
    }
}

