/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planviewer;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.IInternalAbstractPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.planagent.controllinginterface.planviewer.IPlanDataProvider;
import com.arcway.planagent.controllinginterface.planviewer.IPlanViewerExtension;
import com.arcway.planagent.controllinginterface.planviewer.IProjectionRequest;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectFactoryRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.anchoring.IAnchoringContext;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.nonpermanent.PMHighlight;
import com.arcway.planagent.planmodel.nonpermanent.PMLegend;
import com.arcway.planagent.planmodel.nonpermanent.PMProjection;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.TACreatePlanElementStructureAsCopy;
import com.arcway.planagent.planmodel.transactions.TADeletePlanElementStructure;
import de.plans.lib.util.gui.IProgressDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class PlanViewerExtension
implements IPlanViewerExtension {
    private final IInternalAbstractPlanAgent abstractPlanAgent;

    public PlanViewerExtension(IInternalAbstractPlanAgent abstractPlanAgent, IProgressDisplay progress) throws EXSetupPlanException {
        assert (abstractPlanAgent != null);
        this.abstractPlanAgent = abstractPlanAgent;
        abstractPlanAgent.loadPlan(progress);
    }

    public void removePlanElements(Collection<String> planElementUIDs) {
        IPMPlanRO plan = this.getPlan();
        ArrayList<IPMPlanElementRO> planElements = new ArrayList<IPMPlanElementRO>(planElementUIDs.size());
        for (String planElementUID : planElementUIDs) {
            IPMPlanElementRO planElement = plan.getPlanElementRO(planElementUID);
            if (planElement == null) continue;
            planElements.add(planElement);
        }
        ActionParameters actionParameters = ActionParameters.DUMMY;
        TADeletePlanElementStructure transaction = new TADeletePlanElementStructure(planElements, actionParameters);
        if (!transaction.isValid()) {
            throw new IllegalArgumentException("The stated plan elements cannot be deleted from the given plan.");
        }
        transaction.dodo();
    }

    public void createPlanElements(IPlanDataProvider planLoader, GeoVector translation, final double anchoringTolerance) {
        PlanModelMgr planModelMgr = new PlanModelMgr();
        try {
            planModelMgr.load(planLoader);
        }
        catch (EXPlanCreationException e) {
            throw new IllegalArgumentException("Cannot read plan data for createPlanElements", e);
        }
        PMPlan sourcePlan = planModelMgr.getPlan();
        IPMPlanRW destinationPlan = (IPMPlanRW)this.getPlan();
        IAnchoringContext anchoringContext = new IAnchoringContext(){

            public double getAnchoringTolerance() {
                return anchoringTolerance;
            }
        };
        IRoutingParameters routingParameters = IRoutingParameters.DUMMY;
        ActionParameters actionParameters = new ActionParameters(anchoringContext, routingParameters);
        TACreatePlanElementStructureAsCopy transaction = new TACreatePlanElementStructureAsCopy((IPMPlanRW)sourcePlan, translation, destinationPlan, actionParameters);
        if (!transaction.isValid()) {
            throw new IllegalArgumentException("The given plan data cannot be added to the given plan.");
        }
        transaction.dodo();
    }

    public void highlightPlanElements(HighlightLevel highlightLevel, Collection<? extends IHighlightRequest> highlightRequests) {
        IModelChangeRW modelChange;
        IPMPlanModelObjectFactoryRW planModelObjectFactory;
        PMHighlight highlight;
        IPMPlanElementRO pe;
        assert (highlightRequests != null);
        HashSet<IModelChangeRW> modelChanges = new HashSet<IModelChangeRW>();
        Set<IHighlightRequest> oldRequests = this.getAllHighlightRequests(highlightLevel);
        HashSet<? extends IHighlightRequest> newRequests = new HashSet<IHighlightRequest>(highlightRequests);
        HashSet<? extends IHighlightRequest> addedRequests = new HashSet<IHighlightRequest>(newRequests);
        addedRequests.removeAll(oldRequests);
        HashSet<IHighlightRequest> removedRequests = new HashSet<IHighlightRequest>(oldRequests);
        removedRequests.removeAll(newRequests);
        for (IHighlightRequest iHighlightRequest : removedRequests) {
            pe = this.getPlan().getPlanElementRO(iHighlightRequest.getPlanElementUID());
            if (pe == null) continue;
            highlight = pe.getHighlight(highlightLevel);
            pe.setHighlight(highlightLevel, null);
            planModelObjectFactory = highlight.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)highlight, 3);
            modelChanges.add(modelChange);
        }
        for (IHighlightRequest iHighlightRequest : addedRequests) {
            pe = this.getPlan().getPlanElementRO(iHighlightRequest.getPlanElementUID());
            if (pe == null) continue;
            highlight = new PMHighlight((PMPlanElement)pe, iHighlightRequest);
            pe.setHighlight(highlightLevel, highlight);
            planModelObjectFactory = highlight.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)highlight, 1);
            modelChanges.add(modelChange);
        }
        this.viewerModelsChanged(modelChanges);
    }

    public void project(List<? extends IProjectionRequest> projectionRequests) {
        assert (projectionRequests != null);
        HashSet<IModelChangeRW> modelChanges = new HashSet<IModelChangeRW>();
        Set<IProjectionRequest> oldRequests = this.getAllProjectionRequests();
        HashSet<? extends IProjectionRequest> newRequests = new HashSet<IProjectionRequest>(projectionRequests);
        HashSet<? extends IProjectionRequest> addedRequests = new HashSet<IProjectionRequest>(newRequests);
        addedRequests.removeAll(oldRequests);
        HashSet<IProjectionRequest> removedRequests = new HashSet<IProjectionRequest>(oldRequests);
        removedRequests.removeAll(newRequests);
        List oldLegends = this.getPlan().getLegends();
        ArrayList<PMLegend> newLegends = new ArrayList<PMLegend>();
        ArrayList<PMProjection> projections = new ArrayList<PMProjection>(this.getPlan().getProjections());
        for (PMLegend pMLegend : oldLegends) {
            IPMPlanModelObjectFactoryRW planModelObjectFactory = pMLegend.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)pMLegend, 3);
            modelChanges.add(modelChange);
        }
        for (IProjectionRequest iProjectionRequest : removedRequests) {
            boolean found = false;
            Iterator j = projections.iterator();
            while (!found && j.hasNext()) {
                PMProjection projection = (PMProjection)j.next();
                if (!projection.getPMPlanElement().getUid().equals(iProjectionRequest.getPlanElementUID())) continue;
                j.remove();
                found = true;
                IPMPlanModelObjectFactoryRW planModelObjectFactory = projection.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
                IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)projection, 3);
                modelChanges.add(modelChange);
            }
        }
        for (IProjectionRequest iProjectionRequest : addedRequests) {
            if (iProjectionRequest.getPlanElementUID() == null) {
                PMLegend legend = new PMLegend((PMPlan)this.getPlan(), iProjectionRequest);
                newLegends.add(legend);
                IPMPlanModelObjectFactoryRW planModelObjectFactory = legend.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
                IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)legend, 1);
                modelChanges.add(modelChange);
                continue;
            }
            IPMPlanElementRO pe = this.getPlan().getPlanElementRO(iProjectionRequest.getPlanElementUID());
            if (pe == null) continue;
            PMProjection projection = new PMProjection((PMPlanElement)pe, iProjectionRequest);
            projections.add(projection);
            IPMPlanModelObjectFactoryRW planModelObjectFactory = projection.getIPlanModelMgrRW().getPlanModelObjectFactoryRW();
            IModelChangeRW modelChange = planModelObjectFactory.createModelChange((IPMPlanModelObjectRW)projection, 1);
            modelChanges.add(modelChange);
        }
        this.getPlan().setProjections(projections);
        this.getPlan().setLegends(newLegends);
        this.viewerModelsChanged(modelChanges);
    }

    protected final Set<IHighlightRequest> getAllHighlightRequests(HighlightLevel highlightLevel) {
        HashSet<IHighlightRequest> highlightRequests = new HashSet<IHighlightRequest>();
        IPMPlanRO plan = this.getPlan();
        int i = 0;
        while (i < plan.getPlanElementCount()) {
            IPMPlanElementRO planElement = plan.getPlanElementRO(i);
            PMHighlight highlight = planElement.getHighlight(highlightLevel);
            if (highlight != null) {
                IHighlightRequest highlightRequest = highlight.getHighlightRequest();
                highlightRequests.add(highlightRequest);
            }
            ++i;
        }
        return highlightRequests;
    }

    public boolean hasHighlightRequest(HighlightLevel highlightLevel) {
        IPMPlanRO plan = this.getPlan();
        int i = 0;
        while (i < plan.getPlanElementCount()) {
            IPMPlanElementRO planElement = plan.getPlanElementRO(i);
            if (planElement.getHighlight(highlightLevel) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasProjectionRequest() {
        return !this.getPlan().getProjections().isEmpty();
    }

    protected final Set<IProjectionRequest> getAllProjectionRequests() {
        Collection projections = this.getPlan().getProjections();
        HashSet<IProjectionRequest> projectionRequests = new HashSet<IProjectionRequest>(projections.size());
        for (PMProjection projection : projections) {
            IProjectionRequest projectionRequest = projection.getProjectionRequest();
            projectionRequests.add(projectionRequest);
        }
        return projectionRequests;
    }

    public IPMPlanRO getPlan() {
        return this.abstractPlanAgent.getPlan();
    }

    protected abstract void viewerModelsChanged(Set<IModelChangeRW> var1);
}

