/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.viewcreator;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightHint;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.planagent.planmodel.access.readonly.IPMContainmentRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readonly.IPMViewableRO;
import com.arcway.planagent.planmodel.nonpermanent.PMHighlight;
import com.arcway.planagent.planmodel.nonpermanent.PMLegend;
import com.arcway.planagent.planmodel.nonpermanent.PMProjection;
import com.arcway.planagent.planview.frameview.FrameViewConfig;
import com.arcway.planagent.planview.frameview.FrameViewCreator;
import com.arcway.planagent.planview.legends.PVTextLegend;
import com.arcway.planagent.planview.outputupdater.POOutputUpdater;
import com.arcway.planagent.planview.outputupdater.POOutputUpdaterFactory;
import com.arcway.planagent.planview.view.HighlightHint;
import com.arcway.planagent.planview.view.PVLegendView;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import com.arcway.planagent.planview.view.PVView;
import com.arcway.planagent.planview.viewcreator.IEditorContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ViewCreator {
    private static final ILogger LOGGER = Logger.getLogger(ViewCreator.class);
    private static final double DEFAULT_LEGEND_SPACING = 0.0;
    public static final double HIGHLIGHT_CORONA_WIDTH = 0.5;
    private final POOutputUpdaterFactory outputUpdaterfactory = new POOutputUpdaterFactory();

    public PVView createPVView(Object pmModel, HighlightHint ghostHint, PVView pvParent, boolean createComments, HighlightLevel createHighlightsUntilLevel, boolean createProjections, boolean ignoreLegends) {
        return this.createPVView(pmModel, ghostHint, pvParent, createComments, createHighlightsUntilLevel, createProjections, ignoreLegends, null);
    }

    private PVView createPVView(Object pmModel, HighlightHint ghostHint, PVView pvParent, boolean createComments, HighlightLevel createHighlightsUntilLevel, boolean createProjections, boolean ignoreLegends, IPMPlanElementRO legend) {
        IPMPlanElementRO pe;
        PVView pvView = pvParent == null ? new PVView() : pvParent;
        POOutputUpdater outputUpdater = this.outputUpdaterfactory.createOutputUpdater(pmModel);
        PVPlanViewPart planViewPart = outputUpdater.createPlanViewPart();
        if (planViewPart == null) {
            LOGGER.error((Throwable)new Exception(pmModel + ", " + outputUpdater));
        }
        assert (planViewPart != null);
        if (pmModel instanceof IPMViewableRO) {
            pvView = new PVView();
            IPMViewableRO pmViewable = (IPMViewableRO)pmModel;
            pvView.setRoot(planViewPart, pmViewable.getViewableName(), pmViewable.getViewableTypeID(), pmViewable.getViewableUID(), pmViewable.getOptionalTransformation());
            if (pvParent != null) {
                pvParent.addChild(pvView);
            }
        } else {
            pvView = pvParent != null ? pvParent : new PVView();
            pvView.addChild(planViewPart);
        }
        HighlightHint modelHint = new HighlightHint();
        if (pmModel instanceof IPMFigureRO && createHighlightsUntilLevel != null && !(pe = ((IPMFigureRO)pmModel).getPlanElementRO()).getHighlights().isEmpty()) {
            SortedMap<HighlightLevel, ? extends IHighlightHint> modelHints = ViewCreator.createHighlightHint(pe.getHighlights());
            modelHint = HighlightHint.stack(modelHints, createHighlightsUntilLevel);
        }
        HighlightHint realHint = ghostHint == null ? modelHint : HighlightHint.stack(modelHint, ghostHint);
        outputUpdater.refreshVisuals(realHint);
        if (pmModel instanceof IPMViewableRO) {
            IPMViewableRO pmViewable = (IPMViewableRO)pmModel;
            this.createChildViews(pmViewable, ghostHint, pvView, createComments, createHighlightsUntilLevel, createProjections, ignoreLegends, legend);
        }
        return pvView;
    }

    private void createChildViews(IPMViewableRO pmViewable, HighlightHint hint, PVView pvView, boolean createComments, HighlightLevel createHighlightsUntilLevel, boolean createProjections, boolean ignoreLegends, IPMPlanElementRO legend) {
        Collection children = pmViewable.getChildIPMViewableROs();
        for (IPMViewableRO childModel : children) {
            if (this.isIgnored(childModel, createComments, createProjections, ignoreLegends, legend)) continue;
            this.createPVView(childModel, hint, pvView, createComments, createHighlightsUntilLevel, createProjections, ignoreLegends);
        }
    }

    private boolean isIgnored(IPMViewableRO model, boolean createComments, boolean createProjections, boolean ignoreLegends, IPMPlanElementRO legend) {
        IPMPlanElementRO planElement;
        boolean ignored;
        boolean bl = ignored = legend != null;
        if (legend == null) {
            if (createComments) {
                ignored = false;
            } else if (model instanceof IPMPlanElementRO) {
                planElement = (IPMPlanElementRO)model;
                ignored = planElement.isComment();
            } else {
                ignored = false;
            }
        } else {
            ignored = true;
        }
        if (!createProjections) {
            ignored |= model instanceof PMProjection;
        }
        if (legend == null) {
            if (ignoreLegends && model instanceof IPMPlanElementRO) {
                planElement = (IPMPlanElementRO)model;
                ignored |= this.isLegend(planElement, null);
            }
        } else if (model instanceof IPMPlanElementRO) {
            planElement = (IPMPlanElementRO)model;
            ignored &= !this.isLegend(planElement, legend);
        }
        return ignored;
    }

    private boolean isLegend(IPMPlanElementRO planElement, IPMPlanElementRO legend) {
        boolean isLegend = false;
        if ("fmc.cm.legend".equals(planElement.getType())) {
            isLegend |= planElement == legend || legend == null;
        }
        if (!isLegend) {
            int i = 0;
            while (!isLegend && i < planElement.getContainmentAsContainedCount()) {
                IPMContainmentRO containment = planElement.getContainmentAsContainedRO(i);
                isLegend |= this.isLegend(containment.getContainingPlanElementRO(), legend);
                ++i;
            }
        }
        return isLegend;
    }

    public static SortedMap<HighlightLevel, ? extends IHighlightHint> createHighlightHint(SortedMap<HighlightLevel, PMHighlight> pMHighlights) {
        TreeMap<HighlightLevel, IHighlightHint> hints = new TreeMap<HighlightLevel, IHighlightHint>();
        for (Map.Entry<HighlightLevel, PMHighlight> entry : pMHighlights.entrySet()) {
            HighlightLevel highlightLevel = entry.getKey();
            PMHighlight pMHighlight = entry.getValue();
            IHighlightRequest highlightRequest = pMHighlight.getHighlightRequest();
            if (highlightRequest == null) continue;
            IHighlightHint highlightHint = highlightRequest.getHighlightHint();
            hints.put(highlightLevel, highlightHint);
        }
        return hints;
    }

    public PVView createPVView(IEditorContent editorContent, PVView pvParent, boolean createComments, HighlightLevel createHighlightsUntilLevel, boolean createProjections, FrameViewConfig frameViewConfig) {
        PVView pvPlan = this.createPVView(editorContent.getPlanModel(), null, pvParent, createComments, createHighlightsUntilLevel, createProjections, true);
        IPlanInfo info = editorContent.getPlanInfo();
        if (frameViewConfig != null) {
            List projectionLegends;
            PVLegendView leftLegend = null;
            List planLegends = this.getPlanLegends(editorContent.getPlanModel(), createHighlightsUntilLevel, createProjections);
            if (!planLegends.isEmpty()) {
                leftLegend = new PVLegendView(30.0);
                for (PVPlanViewPart legendViewPart : planLegends) {
                    leftLegend.addLowerLeftLegend(legendViewPart, 0.0, 0.0);
                }
            }
            if (!(projectionLegends = editorContent.getPlanModel().getLegends()).isEmpty()) {
                if (leftLegend == null) {
                    leftLegend = new PVLegendView(30.0);
                }
                for (PMLegend pMLegend : projectionLegends) {
                    POOutputUpdater outputUpdater = this.outputUpdaterfactory.createOutputUpdater(pMLegend);
                    PVPlanViewPart legendViewPart = outputUpdater.createPlanViewPart();
                    leftLegend.addLowerLeftLegend(legendViewPart, 0.0, 0.0);
                }
            }
            PVLegendView rightLegend = null;
            if (info != null) {
                PVTextLegend textLegend = new PVTextLegend(info);
                rightLegend = new PVLegendView();
                rightLegend.addLowerRightLegend(textLegend, 0.0, 0.0);
            }
            FrameViewCreator fvc = new FrameViewCreator();
            pvPlan.addChild(fvc.getFrameAndLegends(pvPlan.getOuterBoundsWithoutChildren(), leftLegend, rightLegend, frameViewConfig));
        }
        return pvPlan;
    }

    private List getPlanLegends(IPMPlanRO planModel, HighlightLevel createHighlightsUntilLevel, boolean createProjections) {
        ArrayList<PVView> legends = new ArrayList<PVView>();
        int i = 0;
        while (i < planModel.getPlanElementCount()) {
            IPMPlanElementRO planElement = planModel.getPlanElementRO(i);
            if ("fmc.cm.legend".equals(planElement.getType())) {
                PVView legendView = this.createPVView(planModel, HighlightHint.EMPTY, null, true, createHighlightsUntilLevel, createProjections, false, planElement);
                legends.add(legendView);
            }
            ++i;
        }
        return legends;
    }
}

