/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverGetBounds;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import java.util.ArrayList;
import java.util.List;

public class PVView
extends PVPlanViewPart {
    private PVRootPlanViewPart rootView = null;
    private final List childPlanViewParts = new ArrayList();

    public void addChild(PVPlanViewPart view) {
        assert (view != null);
        this.childPlanViewParts.add(view);
    }

    public void setRoot(PVPlanViewPart view, String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation) {
        assert (view != null);
        this.rootView = new PVRootPlanViewPart(view, elementName, elementTypeID, elementID, optionalTransformation);
    }

    @Override
    public void drawFigure(final Device device) {
        if (this.rootView != null) {
            device.subElement(this.rootView.elementName, this.rootView.elementTypeID, this.rootView.elementID, (Transformation)this.rootView.optionalTransformation, (IDeviceRunnable)new IDeviceRunnable<RuntimeException>(){

                public void run() {
                    ((PVView)PVView.this).rootView.planViewPart.drawFigure(device);
                    PVView.this.drawContent(device);
                }
            });
        } else {
            this.drawContent(device);
        }
    }

    private void drawContent(Device device) {
        for (PVPlanViewPart child : this.childPlanViewParts) {
            child.drawFigure(device);
        }
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        TransformationAffiliate transformation;
        Rectangle thisBounds = this.rootView != null ? this.rootView.planViewPart.getOuterBoundsWithoutChildren() : null;
        for (PVPlanViewPart child : this.childPlanViewParts) {
            Rectangle childBounds = null;
            childBounds = child.getOuterBoundsWithoutChildren();
            thisBounds = thisBounds == null ? childBounds : thisBounds.union(childBounds);
        }
        if (thisBounds != null && this.rootView != null && (transformation = this.rootView.optionalTransformation) != null) {
            thisBounds = thisBounds.transform((Transformation)transformation);
        }
        return thisBounds;
    }

    public Rectangle calculateBounds() {
        DeviceDriverGetBounds deviceDriverGetBounds = new DeviceDriverGetBounds();
        Device dummyDevice = new Device((IDeviceDriver)deviceDriverGetBounds, (Transformation)Transformation.NOP);
        this.drawFigureForGetBounds(dummyDevice);
        Rectangle bounds = deviceDriverGetBounds.getBounds();
        deviceDriverGetBounds.dispose();
        return bounds;
    }

    private static class PVRootPlanViewPart {
        public PVPlanViewPart planViewPart;
        public String elementName;
        public String elementTypeID;
        public String elementID;
        public TransformationAffiliate optionalTransformation;

        public PVRootPlanViewPart(PVPlanViewPart planViewPart, String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation) {
            this.planViewPart = planViewPart;
            this.elementName = elementName;
            this.elementTypeID = elementTypeID;
            this.elementID = elementID;
            this.optionalTransformation = optionalTransformation;
        }
    }
}

