/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.planagent.planview.view.PVPlanViewPart;

public abstract class PVTransformingViewPart
extends PVPlanViewPart {
    PVPlanViewPart transformedView;

    public PVTransformingViewPart(PVPlanViewPart transformedView) {
        this.transformedView = transformedView;
    }

    protected PVPlanViewPart getTransformedView() {
        return this.transformedView;
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        Rectangle outerBoundsWithoutChildren = this.transformedView.getOuterBoundsWithoutChildren();
        Rectangle transformedBounds = outerBoundsWithoutChildren == null ? null : outerBoundsWithoutChildren.transform((Transformation)this.getTransformationInner2Outer());
        return transformedBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawFigureForGetBounds(final Device device) {
        Device device2 = device;
        synchronized (device2) {
            device.subElement(null, null, null, (Transformation)this.getTransformationInner2Outer(), (IDeviceRunnable)new IDeviceRunnable<RuntimeException>(){

                public void run() {
                    PVTransformingViewPart.this.transformedView.drawFigureForGetBounds(device);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawFigure(final Device device) {
        Device device2 = device;
        synchronized (device2) {
            device.subElement(null, null, null, (Transformation)this.getTransformationInner2Outer(), (IDeviceRunnable)new IDeviceRunnable<RuntimeException>(){

                public void run() {
                    PVTransformingViewPart.this.transformedView.drawFigure(device);
                }
            });
        }
    }

    @Override
    public boolean isInside(Point p, double tolerance) {
        double transformedTolerance = this.transformHittestingTolerance(p, tolerance, (Transformation)this.getTransformationOuter2Inner());
        return this.transformedView.isInside(p.transform((Transformation)this.getTransformationOuter2Inner()), transformedTolerance);
    }

    protected double transformHittestingTolerance(Point p, double tolerance, Transformation transformation) {
        GeoVector diagonal1 = GeoVector.GeoVector_1_1.scaleToLength(tolerance);
        Point from1 = p.movePoint(diagonal1.scale(0.5).turn180());
        double abs1 = diagonal1.transform(from1, transformation).abs();
        GeoVector diagonal2 = diagonal1.turn90();
        Point from2 = p.movePoint(diagonal2.scale(0.5).turn180());
        double abs2 = diagonal2.transform(from2, transformation).abs();
        return (abs1 + abs2) / 2.0;
    }

    protected abstract TransformationAffiliate getTransformationInner2Outer();

    protected abstract TransformationAffiliate getTransformationOuter2Inner();
}

