/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverHitTest;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;
import com.arcway.planagent.planview.view.PVPlanViewPart;

public class PVProjectionViewPart
extends PVPlanViewPart {
    private final IProjection projection;
    private Rectangle area = new Rectangle(0.0, 0.0, 0.0, 0.0);

    public PVProjectionViewPart(IProjection projection) {
        this.projection = projection;
    }

    public void setArea(Rectangle area) {
        this.area = new Rectangle(area);
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        return this.projection.getBoundary();
    }

    @Override
    public void drawFigure(Device device) {
        this.projection.drawProjection(device);
    }

    @Override
    public boolean isInside(Point p, double tolerance) {
        DeviceDriverHitTest driver = new DeviceDriverHitTest(null, p, tolerance);
        Device device = new Device((IDeviceDriver)driver, (Transformation)Transformation.NOP);
        this.drawFigureForGetBounds(device);
        return driver.isPointHit();
    }

    public Point getPosition() {
        return this.projection.getPosition(this.area);
    }
}

