/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planview.view.PVPlanObject;

public abstract class PVGraphicalSupplement
extends PVPlanObject {
    protected LineAppearance outlineAppearance = new LineAppearance();

    public PVGraphicalSupplement() {
        this.outlineAppearance.setLineStyle(LineStyle.NONE);
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        Rectangle thisBounds = this.getPoints() == null ? null : this.getPoints().getBounds();
        return thisBounds;
    }

    @Override
    public boolean isInside(Point p, double tolerance) {
        return this.getPoints().isInside(p);
    }

    public LineAppearance getOutlineLineAppearance() {
        return this.outlineAppearance;
    }

    public void setOutlineLineAppearance(LineAppearance appearance) {
        assert (appearance != null) : "appearance must not be null";
        this.outlineAppearance = appearance;
    }

    protected void drawGhostOutline(Device device) {
        if (!this.outlineAppearance.getLineStyle().equals(LineStyle.NONE)) {
            if (this.getPoints().size() > 2) {
                device.polygon(new Corners(this.getPoints(), 0.0), this.outlineAppearance.getLineThickness(), this.outlineAppearance.getLineColor(), this.outlineAppearance.getLineStyle());
            } else if (this.getPoints().size() == 2) {
                device.polyline(new Corners(this.getPoints(), 0.0), this.outlineAppearance.getLineThickness(), this.outlineAppearance.getLineColor(), this.outlineAppearance.getLineStyle());
            }
        }
    }

    protected void drawGhostRectangle(Device device, TurnedRectangle turnedRectangle) {
        if (!this.outlineAppearance.getLineStyle().equals(LineStyle.NONE)) {
            Corners corners = new Corners(turnedRectangle.toPoints(), 0.0);
            device.polygon(corners, this.outlineAppearance.getLineThickness(), this.outlineAppearance.getLineColor(), this.outlineAppearance.getLineStyle());
        }
    }
}

