/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planview.view.PVFigure;

public class PVFigurePlane
extends PVFigure {
    private static final FillColor BLACK = new FillColor();
    private FillAppearance fillAppearance;

    public PVFigurePlane() {
        super(true);
    }

    public void setFillAppearance(IFillAppearanceRO fillAppearance) {
        this.fillAppearance = new FillAppearance(fillAppearance);
        this.updatePolygon();
    }

    @Override
    public void drawFigure(Device device) {
        FillStyle fillStyle = this.fillAppearance.getFillStyle();
        FillColor fillColor = this.fillAppearance.getFillColor();
        this.drawFigure(device, fillStyle, fillColor);
    }

    @Override
    protected void drawFigureForGetBounds(Device device) {
        FillStyle fillStyle = FillStyle.SOLID;
        FillColor fillColor = BLACK;
        this.drawFigure(device, fillStyle, fillColor);
    }

    protected void drawFigure(Device device, FillStyle fillStyle, FillColor fillColor) {
        Color lineColor = this.getLineAppearance().getLineColor();
        LineStyle lineStyle = this.getLineAppearance().getLineStyle();
        double lineThickness = this.getLineAppearance().getLineThickness();
        Color coronaColor = this.getCoronaColor();
        double coronaWidth = this.getCoronaWidth();
        if (fillStyle != FillStyle.NONE) {
            device.polygon(this.getPolygon(), fillColor, fillStyle);
        }
        if (coronaColor != null) {
            device.polygonCorona(this.getPolygon(), lineThickness, coronaColor, coronaWidth);
        }
        device.polygon(this.getPolygon(), lineThickness, lineColor, lineStyle);
    }
}

