/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planview.view.PVFigure;

public class PVFigureLineShape
extends PVFigure {
    private static final Color BLACK = new Color();
    private LineMarkerAppearance lineStartMarkerAppearance;
    private LineMarkerAppearance lineEndMarkerAppearance;

    public PVFigureLineShape() {
        super(false);
    }

    public void setLineStartMarkerAppearance(ILineMarkerAppearanceRO lineMarkerAppearance) {
        this.lineStartMarkerAppearance = new LineMarkerAppearance(lineMarkerAppearance);
        this.updatePolygon();
    }

    public void setLineEndMarkerAppearance(ILineMarkerAppearanceRO lineMarkerAppearance) {
        this.lineEndMarkerAppearance = new LineMarkerAppearance(lineMarkerAppearance);
        this.updatePolygon();
    }

    @Override
    public void drawFigure(Device device) {
        LineStyle lineStyle = this.getLineAppearance().getLineStyle();
        Color lineColor = this.getLineAppearance().getLineColor();
        Color startColor = this.lineStartMarkerAppearance.getLineMarkerColor();
        FillColor startFillColor = this.lineStartMarkerAppearance.getLineMarkerFillColor();
        Color endColor = this.lineEndMarkerAppearance.getLineMarkerColor();
        FillColor endFillColor = this.lineEndMarkerAppearance.getLineMarkerFillColor();
        this.drawFigure(device, lineStyle, lineColor, startColor, startFillColor, endColor, endFillColor);
    }

    @Override
    protected void drawFigureForGetBounds(Device device) {
        LineStyle lineStyle = this.getLineAppearance().getLineStyle();
        if (Geo.equals((double)lineStyle.getWidthFactor(), (double)LineStyle.SOLID.getWidthFactor())) {
            lineStyle = LineStyle.SOLID;
        }
        Color lineColor = BLACK;
        FillColor fillColor = FillColor.BLACK;
        this.drawFigure(device, lineStyle, lineColor, lineColor, fillColor, lineColor, fillColor);
    }

    protected void drawFigure(Device device, LineStyle lineStyle, Color lineColor, Color startColor, FillColor startFillColor, Color endColor, FillColor endFillColor) {
        double lineThickness = this.getLineAppearance().getLineThickness();
        Color coronaColor = this.getCoronaColor();
        double coronaWidth = this.getCoronaWidth();
        LineMarker startMarker = this.lineStartMarkerAppearance.getLineMarkerStyle();
        double startSize = this.lineStartMarkerAppearance.getLineMarkerSize();
        LineMarker endMarker = this.lineEndMarkerAppearance.getLineMarkerStyle();
        double endSize = this.lineEndMarkerAppearance.getLineMarkerSize();
        if (coronaColor != null) {
            device.polylineCorona(this.getPolygon(), lineThickness, coronaColor, startMarker, coronaColor, FillColor.TRANSPARENT, startSize, endMarker, coronaColor, FillColor.TRANSPARENT, endSize, coronaWidth);
        }
        device.polyline(this.getPolygon(), lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize);
    }
}

