/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverHitTest;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planview.view.PVPlanObject;

public abstract class PVFigure
extends PVPlanObject {
    private LineAppearance lineAppearance;
    private Polygon polygon;
    private final boolean closedDraw;
    private Color coronaColor = null;
    private double coronaWidth;

    public PVFigure(boolean closedDraw) {
        this.closedDraw = closedDraw;
    }

    @Override
    public void setPoints(Points points) {
        super.setPoints(points);
        this.updatePolygon();
    }

    public void setLineAppearance(ILineAppearanceRO lineAppearance) {
        this.lineAppearance = new LineAppearance(lineAppearance);
        this.updatePolygon();
    }

    protected ILineAppearance getLineAppearance() {
        return this.lineAppearance;
    }

    protected void updatePolygon() {
        this.polygon = this.createPolygon((ILineAppearanceRO)this.lineAppearance, this.closedDraw);
    }

    protected Polygon getPolygon() {
        return this.polygon;
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildrenByDrawing();
    }

    @Override
    public boolean isInside(Point p, double tolerance) {
        DeviceDriverHitTest driver = new DeviceDriverHitTest(null, p, tolerance);
        Device device = new Device((IDeviceDriver)driver, (Transformation)Transformation.NOP);
        this.drawFigureForGetBounds(device);
        return driver.isPointHit();
    }

    public void setCorona(Color coronaColor, double coronaWidth) {
        this.coronaColor = coronaColor;
        this.coronaWidth = coronaWidth;
    }

    protected Color getCoronaColor() {
        return this.coronaColor;
    }

    protected double getCoronaWidth() {
        return this.coronaWidth;
    }
}

