/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.graphics.Color;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightHint;
import java.util.Map;
import java.util.SortedMap;

public class HighlightHint
implements IHighlightHint {
    public static final HighlightHint EMPTY = new HighlightHint();
    private Color fillColor = null;
    private double fillOpacity = 0.0;
    private Color lineColor = null;
    private double colorWeight = 1.0;
    private Color coronaColor = null;
    private double coronaWidth = 0.0;
    private boolean showGuidelines = false;

    public static HighlightHint mergeHighlightHints(IHighlightHint highlightHintOfStartFigure, IHighlightHint highlightHintOfEndFigure) {
        double fillOpacity;
        Color fillColor;
        Color lineColor;
        Color fillColorOfStartFigure = highlightHintOfStartFigure.getFillColor();
        double fillOpacityOfStartFigure = highlightHintOfStartFigure.getFillOpacity();
        Color lineColorOfStartFigure = highlightHintOfStartFigure.getLineColor();
        double colorWeightOfStartFigure = highlightHintOfStartFigure.getColorWeight();
        Color fillColorOfEndFigure = highlightHintOfEndFigure.getFillColor();
        double fillOpacityOfEndFigure = highlightHintOfEndFigure.getFillOpacity();
        Color lineColorOfEndFigure = highlightHintOfEndFigure.getLineColor();
        double colorWeightOfEndFigure = highlightHintOfEndFigure.getColorWeight();
        double colorWeight = Math.sqrt(colorWeightOfStartFigure * colorWeightOfEndFigure);
        if (lineColorOfStartFigure == null || colorWeightOfStartFigure < 1.0E-10) {
            lineColor = lineColorOfEndFigure;
        } else if (lineColorOfEndFigure == null || colorWeightOfEndFigure < 1.0E-10) {
            lineColor = lineColorOfStartFigure;
        } else {
            double weightOfLineColorOfStartFigure = colorWeightOfStartFigure / (colorWeightOfStartFigure + colorWeightOfEndFigure);
            lineColor = lineColorOfEndFigure.goToColor(lineColorOfStartFigure, weightOfLineColorOfStartFigure);
        }
        if (fillColorOfStartFigure == null || colorWeightOfStartFigure < 1.0E-10) {
            fillColor = fillColorOfEndFigure;
            fillOpacity = fillOpacityOfEndFigure;
        } else if (fillColorOfEndFigure == null || colorWeightOfEndFigure < 1.0E-10) {
            fillColor = fillColorOfStartFigure;
            fillOpacity = fillOpacityOfStartFigure;
        } else {
            double fillColorWeightOfStartFigure = colorWeightOfStartFigure * fillOpacityOfStartFigure;
            double fillColorWeightOfEndFigure = colorWeightOfEndFigure * fillOpacityOfEndFigure;
            double det = fillColorWeightOfStartFigure + fillColorWeightOfEndFigure;
            double weightOfFillColorOfStartFigure = fillColorWeightOfStartFigure / det;
            weightOfFillColorOfStartFigure = det >= 1.0E-10 ? fillColorWeightOfStartFigure / det : 1.0;
            fillColor = lineColor = fillColorOfEndFigure.goToColor(fillColorOfStartFigure, weightOfFillColorOfStartFigure);
            fillOpacity = (colorWeightOfStartFigure * fillOpacityOfStartFigure + colorWeightOfEndFigure * fillOpacityOfEndFigure) / (colorWeightOfStartFigure + colorWeightOfEndFigure);
        }
        HighlightHint mergedHighlightHint = new HighlightHint();
        mergedHighlightHint.setFillColor(fillColor);
        mergedHighlightHint.setFillOpacity(fillOpacity);
        mergedHighlightHint.setLineColor(lineColor);
        mergedHighlightHint.setColorWeight(colorWeight);
        return mergedHighlightHint;
    }

    public static HighlightHint min(IHighlightHint firstHighlightHint, IHighlightHint secondHighlightHint) {
        HighlightHint firstWeakHighlightHint = new HighlightHint(firstHighlightHint).removeHighlight();
        HighlightHint secondWeakHighlightHint = new HighlightHint(secondHighlightHint).removeHighlight();
        double firstColorWeight = firstWeakHighlightHint.colorWeight;
        Color firstFillColor = firstWeakHighlightHint.getFillColor();
        double firstFillOpacity = firstWeakHighlightHint.getFillOpacity();
        double firstFillEffectWeight = (firstFillColor != null ? (firstFillColor.transparent ? -firstColorWeight : firstColorWeight) : 0.0) + 2.0 * firstFillOpacity;
        Color firstLineColor = firstWeakHighlightHint.getLineColor();
        double fistLineEffectWeight = firstLineColor != null ? (firstLineColor.transparent ? -firstColorWeight : firstColorWeight * (1.0 - 2.0 * (double)firstLineColor.r / 255.0)) : 0.0;
        double firstEffectWeight = 2.0 * fistLineEffectWeight + firstFillEffectWeight;
        double secondColorWeight = secondWeakHighlightHint.colorWeight;
        Color secondFillColor = secondWeakHighlightHint.getFillColor();
        double secondFillOpacity = secondWeakHighlightHint.getFillOpacity();
        double secondFillEffectWeight = (secondFillColor != null ? (secondFillColor.transparent ? -secondColorWeight : secondColorWeight) : 0.0) + 2.0 * secondFillOpacity;
        Color secondLineColor = secondWeakHighlightHint.getLineColor();
        double secondLineEffectWeight = secondLineColor != null ? (secondLineColor.transparent ? -secondColorWeight : secondColorWeight * (1.0 - 2.0 * (double)secondLineColor.r / 255.0)) : 0.0;
        double secondEffectWeight = 2.0 * secondLineEffectWeight + secondFillEffectWeight;
        HighlightHint mergedHighlightHint = firstEffectWeight <= secondEffectWeight ? firstWeakHighlightHint : secondWeakHighlightHint;
        return mergedHighlightHint;
    }

    public static HighlightHint stack(SortedMap<HighlightLevel, ? extends IHighlightHint> highlights, HighlightLevel untilLevel) {
        HighlightHint hint = new HighlightHint();
        if (untilLevel != null) {
            for (Map.Entry<HighlightLevel, ? extends IHighlightHint> entry : highlights.entrySet()) {
                HighlightLevel highlightLevel = entry.getKey();
                if (highlightLevel.compareTo((Enum)untilLevel) > 0) continue;
                IHighlightHint hintRun = entry.getValue();
                hint = HighlightHint.stack(hint, hintRun);
            }
        }
        return hint;
    }

    public static HighlightHint stack(IHighlightHint lowerHint, IHighlightHint higherHint) {
        double coronaWidth;
        Color coronaColor;
        double colorWeight;
        Color lineColor;
        double fillOpacity;
        Color fillColor;
        if (higherHint.getFillColor() != null && lowerHint.getFillColor() != null) {
            double higherFillOpacity = higherHint.getFillOpacity();
            double relationOfHigherColor = Math.min(1.0, higherFillOpacity + 1.0);
            double relationOfLowerColor = 1.0 - relationOfHigherColor;
            fillColor = higherHint.getFillColor().goToColor(lowerHint.getFillColor(), relationOfLowerColor);
            fillOpacity = higherFillOpacity;
        } else if (higherHint.getFillColor() == null && lowerHint.getFillColor() != null) {
            fillColor = lowerHint.getFillColor();
            fillOpacity = lowerHint.getFillOpacity();
        } else if (higherHint.getFillColor() != null && lowerHint.getFillColor() == null) {
            fillColor = higherHint.getFillColor();
            fillOpacity = higherHint.getFillOpacity();
        } else {
            fillColor = null;
            fillOpacity = 0.0;
        }
        if (higherHint.getLineColor() != null && lowerHint.getLineColor() != null) {
            double higherColorWeight = higherHint.getColorWeight();
            double lowerColorWeight = lowerHint.getColorWeight();
            double relationOfLowerColor = (1.0 - higherColorWeight) * lowerColorWeight;
            lineColor = higherHint.getLineColor().goToColor(lowerHint.getLineColor(), relationOfLowerColor);
            colorWeight = higherColorWeight;
        } else if (higherHint.getLineColor() == null && lowerHint.getLineColor() != null) {
            lineColor = lowerHint.getLineColor();
            colorWeight = lowerHint.getColorWeight();
        } else if (higherHint.getLineColor() != null && lowerHint.getLineColor() == null) {
            lineColor = higherHint.getLineColor();
            colorWeight = higherHint.getColorWeight();
        } else {
            lineColor = null;
            colorWeight = 1.0;
        }
        if (higherHint.getCoronaColor() != null && higherHint.getCoronaWidth() > 1.0E-10) {
            coronaColor = higherHint.getCoronaColor();
            coronaWidth = higherHint.getCoronaWidth();
        } else if (lowerHint.getCoronaColor() != null && lowerHint.getCoronaWidth() > 1.0E-10) {
            coronaColor = lowerHint.getCoronaColor();
            coronaWidth = lowerHint.getCoronaWidth();
        } else {
            coronaColor = null;
            coronaWidth = 0.0;
        }
        boolean showGuidelines = higherHint.showGuidelines() || lowerHint.showGuidelines();
        return new HighlightHint(fillColor, fillOpacity, lineColor, colorWeight, coronaColor, coronaWidth, showGuidelines);
    }

    public HighlightHint() {
    }

    public HighlightHint(Color fillColor, double fillOpacity, Color lineColor, double colorWeight, Color coronaColor, double coronaWidth, boolean showGuidelines) {
        this.fillColor = fillColor;
        this.fillOpacity = fillOpacity;
        this.lineColor = lineColor;
        this.colorWeight = colorWeight;
        this.coronaColor = coronaColor;
        this.coronaWidth = coronaWidth;
        this.showGuidelines = showGuidelines;
    }

    public HighlightHint(Color fillColor, double fillOpacity, double colorWeight) {
        this.fillColor = fillColor;
        this.fillOpacity = fillOpacity;
        this.colorWeight = colorWeight;
    }

    public HighlightHint(Color fillColor, double fillOpacity, Color lineColor, double colorWeight, boolean showGuidelines) {
        this.fillColor = fillColor;
        this.fillOpacity = fillOpacity;
        this.lineColor = lineColor;
        this.colorWeight = colorWeight;
        this.showGuidelines = showGuidelines;
    }

    public HighlightHint(Color coronaColor, double coronaWidth) {
        this.coronaColor = coronaColor;
        this.coronaWidth = coronaWidth;
    }

    public HighlightHint(IHighlightHint highlight) {
        this.fillColor = highlight.getFillColor() == null ? null : new Color(highlight.getFillColor());
        this.fillOpacity = highlight.getFillOpacity();
        this.lineColor = highlight.getLineColor() == null ? null : new Color(highlight.getLineColor());
        this.colorWeight = highlight.getColorWeight();
        this.coronaColor = highlight.getCoronaColor() == null ? null : new Color(highlight.getCoronaColor());
        this.coronaWidth = highlight.getCoronaWidth();
        this.showGuidelines = highlight.showGuidelines();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public double getFillOpacity() {
        return this.fillOpacity;
    }

    public void setFillOpacity(double fillOpacity) {
        this.fillOpacity = fillOpacity;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public double getColorWeight() {
        return this.colorWeight;
    }

    public void setColorWeight(double colorWeight) {
        this.colorWeight = colorWeight;
    }

    public Color getCoronaColor() {
        return this.coronaColor;
    }

    public double getCoronaWidth() {
        return this.coronaWidth;
    }

    public void setCorona(Color coronaColor, double coronaWidth) {
        this.coronaColor = coronaColor;
        this.coronaWidth = coronaWidth;
    }

    public boolean showGuidelines() {
        return this.showGuidelines;
    }

    public void setShowGuidelines(boolean showGuidelines) {
        this.showGuidelines = showGuidelines;
    }

    public static boolean isEmpty(IHighlightHint highlightHint) {
        boolean empty = true;
        empty &= highlightHint.getFillColor() == null;
        empty &= Geo.isZero((double)highlightHint.getFillOpacity());
        empty &= highlightHint.getLineColor() == null;
        return empty &= highlightHint.getCoronaColor() == null;
    }

    public HighlightHint removeHighlight() {
        HighlightHint newHighlightHint = new HighlightHint();
        if (this.colorWeight > 1.0E-10) {
            if (!this.isLineColorHighlight()) {
                newHighlightHint.setLineColor(this.lineColor);
                newHighlightHint.setColorWeight(this.colorWeight);
            }
            if (!this.isFillColorHighlight()) {
                newHighlightHint.setFillColor(this.fillColor);
                newHighlightHint.setColorWeight(this.colorWeight);
            }
        }
        if (!this.isFillOpacityHighlight()) {
            newHighlightHint.setFillOpacity(Math.min(0.0, this.fillOpacity));
        }
        return newHighlightHint;
    }

    private boolean isLineColorHighlight() {
        boolean lineColorIsHighlight = this.lineColor != null && !this.lineColor.isGreyOrTransparent();
        boolean colorIsRelevant = this.colorWeight > 1.0E-10;
        boolean isHighlight = colorIsRelevant && lineColorIsHighlight;
        return isHighlight;
    }

    private boolean isFillColorHighlight() {
        boolean fillColorIsHighlight = this.fillColor != null && this.fillOpacity > -0.9999999999 && !this.fillColor.isGreyOrTransparent();
        boolean colorIsRelevant = this.colorWeight > 1.0E-10;
        boolean isHighlight = colorIsRelevant && fillColorIsHighlight;
        return isHighlight;
    }

    private boolean isFillOpacityHighlight() {
        boolean fillOpacityIsHighlight = this.fillOpacity > 1.0E-10;
        boolean fillColorTransparencyOverridesFillOpacity = this.fillColor != null && this.fillColor.transparent && this.colorWeight + 1.0E-10 > this.fillOpacity;
        boolean isHighlight = fillOpacityIsHighlight && !fillColorTransparencyOverridesFillOpacity;
        return isHighlight;
    }
}

