/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.print;

import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.print.IPrinter;

public class PageInfo {
    private double widthOfSinglePage;
    private double widthOfFirstPage;
    private double widthOfCenterPage;
    private double widthOfLastPage;
    private double heightOfSinglePage;
    private double heightOfFirstPage;
    private double heightOfCenterPage;
    private double heightOfLastPage;
    private boolean pageInsetsAreOuterBorder = true;

    public PageInfo(IPrinter printer, Insets margins, boolean marginsAreOuterBorder) {
        Rectangle printRect = printer.getDrawingArea();
        Rectangle pageRect = printer.getPageSize();
        Insets printerMargin = new Insets(printRect.upperLeft.y - pageRect.upperLeft.y, pageRect.lowerRight.y - printRect.lowerRight.y, printRect.upperLeft.x - pageRect.upperLeft.x, pageRect.lowerRight.x - printRect.lowerRight.x);
        this.setDimensions(pageRect, printerMargin, margins);
        this.setPageInsetsAreOuterBorder(marginsAreOuterBorder);
    }

    public PageInfo(Rectangle pageRect, Insets printerMargin, Insets margins, boolean marginsAreOuterBorder) {
        this.setDimensions(pageRect, printerMargin, margins);
        this.setPageInsetsAreOuterBorder(marginsAreOuterBorder);
    }

    private void setDimensions(Rectangle pageRect, Insets printerMargin, Insets margins) {
        Rectangle singleRect = pageRect.shrink(margins);
        this.widthOfSinglePage = singleRect.w();
        this.heightOfSinglePage = singleRect.h();
        this.widthOfFirstPage = pageRect.w() - margins.leftInset - printerMargin.rightInset;
        this.widthOfCenterPage = pageRect.w() - printerMargin.leftInset - printerMargin.rightInset;
        this.widthOfLastPage = pageRect.w() - printerMargin.leftInset - margins.rightInset;
        this.heightOfFirstPage = pageRect.h() - margins.upperInset - printerMargin.lowerInset;
        this.heightOfCenterPage = pageRect.h() - printerMargin.upperInset - printerMargin.lowerInset;
        this.heightOfLastPage = pageRect.h() - printerMargin.upperInset - margins.lowerInset;
    }

    public double widthOfSinglePage() {
        return this.widthOfSinglePage;
    }

    public double widthOfFirstPage() {
        return this.widthOfFirstPage;
    }

    public double widthOfCenterPage() {
        return this.widthOfCenterPage;
    }

    public double widthOfLastPage() {
        return this.widthOfLastPage;
    }

    public double heightOfSinglePage() {
        return this.heightOfSinglePage;
    }

    public double heightOfFirstPage() {
        return this.heightOfFirstPage;
    }

    public double heightOfCenterPage() {
        return this.heightOfCenterPage;
    }

    public double heightOfLastPage() {
        return this.heightOfLastPage;
    }

    public boolean pageInsetsAreOuterBorder() {
        return this.pageInsetsAreOuterBorder;
    }

    private void setPageInsetsAreOuterBorder(boolean pageInsetsAreOuterBorder) {
        this.pageInsetsAreOuterBorder = pageInsetsAreOuterBorder;
    }

    public String toString() {
        String s = "PageInfo[";
        s = String.valueOf(s) + "\nwidthOfSinglePage=" + this.widthOfSinglePage;
        s = String.valueOf(s) + ", \nwidthOfFirstPage=" + this.widthOfFirstPage;
        s = String.valueOf(s) + ", \nwidthOfCenterPage=" + this.widthOfCenterPage;
        s = String.valueOf(s) + ", \nwidthOfLastPage=" + this.widthOfLastPage;
        s = String.valueOf(s) + ", \nheightOfSinglePage=" + this.heightOfSinglePage;
        s = String.valueOf(s) + ", \nheightOfFirstPage=" + this.heightOfFirstPage;
        s = String.valueOf(s) + ", \nheightOfCenterPage=" + this.heightOfCenterPage;
        s = String.valueOf(s) + ", \nheightOfLastPage=" + this.heightOfLastPage;
        s = String.valueOf(s) + ", \npageInsetsAreOuterBorder=" + this.pageInsetsAreOuterBorder + "]";
        return s;
    }
}

