/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.legends;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.IImageDataProvider;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.plugin.DefaultRendererExtensionPoint;
import com.arcway.planagent.planview.view.PVPlanViewPart;

public class PVImageLegend
extends PVPlanViewPart {
    private final IImageDataProvider imageDesc;
    private final Rectangle rectangle;

    public PVImageLegend(double width, double height, IImageDataProvider imageDesc) {
        this.imageDesc = imageDesc;
        this.rectangle = new Rectangle(0.0, 0.0, width - 1.0, height - 1.0);
    }

    public PVImageLegend(Rectangle rectangle, IImageDataProvider imageDesc) {
        this.imageDesc = imageDesc;
        this.rectangle = rectangle;
    }

    @Override
    public void drawFigure(Device device) {
        IOffscreenBitmap arcImage;
        if (device.supportsNullImage()) {
            arcImage = null;
        } else {
            try {
                IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
                arcImage = renderer.createOffscreenBitmap(this.imageDesc.getImageData());
            }
            catch (EXImageTooBig e) {
                arcImage = null;
            }
            catch (EXNoMoreHandles e) {
                arcImage = null;
            }
            catch (EXImageDataTypeNotSupported e) {
                arcImage = null;
            }
        }
        if (arcImage != null || device.supportsNullImage()) {
            device.image(arcImage, this.rectangle);
        }
        if (arcImage != null) {
            arcImage.dispose();
        }
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        return this.rectangle;
    }

    @Override
    public boolean isInside(Point p, double tolerance) {
        Rectangle r = this.rectangle.expand(tolerance);
        return r.isInside(p);
    }
}

