/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.frameview;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planview.frameview.FrameViewConfig;
import com.arcway.planagent.planview.view.PVFigurePlane;
import com.arcway.planagent.planview.view.PVFrameViewPart;
import com.arcway.planagent.planview.view.PVLegendView;
import com.arcway.planagent.planview.view.PVPlanViewPart;
import com.arcway.planagent.planview.view.PVTransformedViewPart;
import com.arcway.planagent.planview.view.PVView;
import java.util.LinkedList;

public class FrameViewCreator {
    private static final ILogger logger = Logger.getLogger(FrameViewCreator.class);

    @Deprecated
    public PVView getSomething(PVPlanViewPart plan, FrameViewConfig config) {
        PVFigurePlane planeLegend = new PVFigurePlane();
        planeLegend.setFillAppearance((IFillAppearanceRO)new FillAppearance());
        planeLegend.setLineAppearance((ILineAppearanceRO)new LineAppearance());
        Points points = new Points();
        points.add(new Point(0.0, 0.0));
        points.add(new Point(20.0, 0.0));
        points.add(new Point(20.0, 10.0));
        points.add(new Point(3.0, 10.0));
        points.add(new Point(3.0, 5.0));
        points.add(new Point(0.0, 5.0));
        planeLegend.setPoints(points);
        LinkedList<PVFigurePlane> testSet = new LinkedList<PVFigurePlane>();
        testSet.add(planeLegend);
        testSet.add(planeLegend);
        testSet.add(planeLegend);
        PVLegendView left = new PVLegendView();
        for (Object e : testSet) {
            PVPlanViewPart legend = (PVPlanViewPart)e;
            left.addLowerLeftLegend(legend, 10.0, 0.0);
        }
        PVLegendView pVLegendView = new PVLegendView();
        for (Object e : testSet) {
            PVPlanViewPart legend = (PVPlanViewPart)e;
            pVLegendView.addLowerRightLegend(legend, 5.0, 5.0);
        }
        return this.getFrameAndLegends(plan.getOuterBoundsWithoutChildren(), left, pVLegendView, config);
    }

    public PVView getFrameAndLegends(Rectangle rect, PVLegendView left, PVLegendView right, FrameViewConfig config) {
        Rectangle planRect = rect;
        if (planRect == null) {
            planRect = new Rectangle(0.0, 0.0, 0.0, 0.0);
        }
        PVView view = null;
        try {
            view = config.fitToHeight && config.fitToWidth ? this.getFrameAndLegendsFitToBoth(planRect, left, right, config) : (config.fitToWidth ? this.getFrameAndLegendsFitToWidth(planRect, left, right, config, false) : (config.fitToHeight ? this.getFrameAndLegendsFitToHeight(planRect, left, right, config) : this.getFrameAndLegendsNoFitting(planRect, left, right, config)));
        }
        catch (EXFittingException e) {
            logger.error("Error in frame size calculation; cannot fit: Either fit to width or fit height was not / should be possible.", (Throwable)e);
            view = new PVView();
        }
        return view;
    }

    private PVView getFrameAndLegendsFitToBoth(Rectangle planRect, PVLegendView left, PVLegendView right, FrameViewConfig config) throws EXFittingException {
        PVView view = this.getFrameAndLegendsFitToWidth(planRect, left, right, config, true);
        return view;
    }

    private PVView getFrameAndLegendsNoFitting(Rectangle planRect, PVLegendView left, PVLegendView right, FrameViewConfig config) {
        TransformationAffiliate trafo;
        double rightHeight;
        Rectangle scaledPlanRect = planRect.transform((Transformation)TransformationAffiliate.newTransformationScaling((double)config.zoom));
        PVView view = new PVView();
        PVTransformedViewPart leftLegends = null;
        PVTransformedViewPart rightLegends = null;
        if (left != null) {
            leftLegends = new PVTransformedViewPart(left);
        }
        if (right != null) {
            rightLegends = new PVTransformedViewPart(right);
        }
        double legendsHeight = 0.0;
        if (left != null) {
            legendsHeight = Math.abs(left.getOuterBoundsWithoutChildren().upperLeft.y);
        }
        if (right != null && (rightHeight = Math.abs(right.getOuterBoundsWithoutChildren().upperLeft.y)) > legendsHeight) {
            legendsHeight = rightHeight;
        }
        Rectangle frameRect = scaledPlanRect.expand(config.frameInsets);
        double tooLarge = -frameRect.w();
        if (left != null) {
            tooLarge += Math.abs(left.getOuterBoundsWithoutChildren().lowerRight.x);
        }
        if (right != null) {
            tooLarge += Math.abs(right.getOuterBoundsWithoutChildren().upperLeft.x);
        }
        if (left != null && right != null) {
            tooLarge += config.minLegendDistance;
        }
        if (tooLarge > 0.0) {
            frameRect = frameRect.expand(tooLarge / 2.0, 0.0, tooLarge / 2.0, 0.0);
        }
        frameRect = frameRect.expand(0.0, 0.0, 0.0, legendsHeight);
        if (config.expandFrame) {
            frameRect = this.expandFrame(frameRect, config);
        }
        PVFrameViewPart frame = new PVFrameViewPart(frameRect, 0.5);
        if (leftLegends != null) {
            trafo = leftLegends.getTransformationInner2Outer().getCopy();
            trafo.translate(new GeoVector(new Point(frameRect.upperLeft.x, frameRect.lowerRight.y)));
            leftLegends.setPlan2canvasTrafo(trafo);
        }
        if (rightLegends != null) {
            trafo = rightLegends.getTransformationInner2Outer().getCopy();
            trafo.translate(new GeoVector(frameRect.lowerRight));
            rightLegends.setPlan2canvasTrafo(trafo);
        }
        this.addFrameAndLegends(view, leftLegends, rightLegends, frame, Transformation.createTransformation((Rectangle)planRect, (Rectangle)scaledPlanRect));
        return view;
    }

    private PVView getFrameAndLegendsFitToHeight(Rectangle planRect, PVLegendView left, PVLegendView right, FrameViewConfig config) throws EXFittingException {
        TransformationAffiliate trafo;
        double rightHeight;
        PVView view = new PVView();
        PVTransformedViewPart leftLegends = null;
        PVTransformedViewPart rightLegends = null;
        if (left != null) {
            leftLegends = new PVTransformedViewPart(left);
        }
        if (right != null) {
            rightLegends = new PVTransformedViewPart(right);
        }
        double legendsHeight = 0.0;
        if (left != null) {
            legendsHeight = Math.abs(left.getOuterBoundsWithoutChildren().upperLeft.y);
        }
        if (right != null && (rightHeight = Math.abs(right.getOuterBoundsWithoutChildren().upperLeft.y)) > legendsHeight) {
            legendsHeight = rightHeight;
        }
        double planHeight = config.height - config.frameInsets.upperInset - config.frameInsets.lowerInset - legendsHeight;
        double planWidth = 0.0;
        if (planRect.h() > 1.0E-10) {
            planWidth = planHeight * planRect.w() / planRect.h();
        }
        Dimension finalPlanDimension = new Dimension(planWidth, planHeight);
        Rectangle finalPlanRectangle = new Rectangle(0.0, 0.0, finalPlanDimension);
        Dimension frameDimension = new Dimension(finalPlanDimension.width + config.frameInsets.leftInset + config.frameInsets.rightInset, config.height);
        double tooLarge = -frameDimension.width;
        if (left != null) {
            tooLarge += Math.abs(left.getOuterBoundsWithoutChildren().lowerRight.x);
        }
        if (right != null) {
            tooLarge += Math.abs(right.getOuterBoundsWithoutChildren().upperLeft.x);
        }
        if (left != null && right != null) {
            tooLarge += config.minLegendDistance;
        }
        if (tooLarge > 0.0) {
            finalPlanRectangle = finalPlanRectangle.move(new GeoVector(tooLarge / 2.0, 0.0));
            frameDimension = new Dimension(frameDimension.width + tooLarge, frameDimension.height);
        }
        Rectangle frameRect = new Rectangle(-config.frameInsets.leftInset, -config.frameInsets.upperInset, frameDimension);
        if (config.expandFrame) {
            frameRect = this.expandFrameHorizontally(frameRect, config);
        }
        PVFrameViewPart frame = new PVFrameViewPart(frameRect, 0.5);
        if (leftLegends != null) {
            trafo = leftLegends.getTransformationInner2Outer().getCopy();
            trafo.translate(new GeoVector(new Point(frameRect.upperLeft.x, frameRect.lowerRight.y)));
            leftLegends.setPlan2canvasTrafo(trafo);
        }
        if (rightLegends != null) {
            trafo = rightLegends.getTransformationInner2Outer().getCopy();
            trafo.translate(new GeoVector(frameRect.lowerRight));
            rightLegends.setPlan2canvasTrafo(trafo);
        }
        this.addFrameAndLegends(view, leftLegends, rightLegends, frame, Transformation.createTransformation((Rectangle)planRect, (Rectangle)finalPlanRectangle));
        return view;
    }

    private PVView getFrameAndLegendsFitToWidth(Rectangle planRect, PVLegendView left, PVLegendView right, FrameViewConfig config, boolean fitToHeightAlso) throws EXFittingException {
        TransformationAffiliate trafo;
        double maxPlanHeight;
        PVView view = new PVView();
        PVTransformedViewPart leftLegends = null;
        PVTransformedViewPart rightLegends = null;
        if (left != null) {
            leftLegends = new PVTransformedViewPart(left);
        }
        if (right != null) {
            rightLegends = new PVTransformedViewPart(right);
        }
        double desiredLegendsWidthWithPadding = config.width;
        double legendsWidth = 0.0;
        if (left != null) {
            legendsWidth += left.getOuterBoundsWithoutChildren().w();
            legendsWidth += Math.abs(left.getOuterBoundsWithoutChildren().upperLeft.x);
        }
        if (right != null) {
            legendsWidth += right.getOuterBoundsWithoutChildren().w();
            legendsWidth += Math.abs(right.getOuterBoundsWithoutChildren().lowerRight.x);
        }
        double legendsWidthWithPadding = legendsWidth;
        if (left != null && right != null) {
            legendsWidthWithPadding += config.minLegendDistance;
        }
        double legendScaleFactor = 1.0;
        if (legendsWidthWithPadding > desiredLegendsWidthWithPadding && legendsWidth > 1.0E-10) {
            double desiredLegendsWidth = desiredLegendsWidthWithPadding;
            if (left != null && right != null) {
                desiredLegendsWidth -= config.minLegendDistance;
            }
            legendScaleFactor = desiredLegendsWidth / legendsWidth;
        }
        if (leftLegends != null) {
            leftLegends.setPlan2canvasTrafo(TransformationAffiliate.newTransformationScaling((double)legendScaleFactor));
        }
        if (rightLegends != null) {
            rightLegends.setPlan2canvasTrafo(TransformationAffiliate.newTransformationScaling((double)legendScaleFactor));
        }
        Rectangle legendsRect = null;
        if (leftLegends != null) {
            legendsRect = leftLegends.getOuterBoundsWithoutChildren();
        }
        if (rightLegends != null) {
            legendsRect = legendsRect == null ? rightLegends.getOuterBoundsWithoutChildren() : legendsRect.union(rightLegends.getOuterBoundsWithoutChildren());
        }
        double legendsHeight = 0.0;
        if (legendsRect != null) {
            legendsHeight = Math.abs(legendsRect.upperLeft.y);
        }
        double planWidth = config.width - config.frameInsets.leftInset - config.frameInsets.rightInset;
        double planHeight = 0.0;
        if (planRect.w() > 1.0E-10) {
            planHeight = planWidth * planRect.h() / planRect.w();
        }
        if (fitToHeightAlso && planHeight > (maxPlanHeight = config.height - config.frameInsets.upperInset - config.frameInsets.lowerInset - legendsHeight) && planHeight > 1.0E-10) {
            double scale = maxPlanHeight / planHeight;
            planWidth *= scale;
            planHeight *= scale;
        }
        Dimension finalPlanDimension = new Dimension(planWidth, planHeight);
        Rectangle finalPlanRectangle = new Rectangle(0.0, 0.0, finalPlanDimension);
        Dimension frameDimension = new Dimension(config.width, config.frameInsets.upperInset + finalPlanDimension.height + config.frameInsets.lowerInset + legendsHeight);
        Rectangle frameRect = new Rectangle((planWidth - config.width) / 2.0, -config.frameInsets.upperInset, frameDimension);
        if (config.expandFrame) {
            frameRect = this.expandFrameVertically(frameRect, config);
        }
        PVFrameViewPart frame = new PVFrameViewPart(frameRect, 0.5);
        if (leftLegends != null) {
            trafo = leftLegends.getTransformationInner2Outer().getCopy();
            trafo.translate(new GeoVector(new Point(frameRect.upperLeft.x, frameRect.lowerRight.y)));
            leftLegends.setPlan2canvasTrafo(trafo);
        }
        if (rightLegends != null) {
            trafo = rightLegends.getTransformationInner2Outer().getCopy();
            trafo.translate(new GeoVector(frameRect.lowerRight));
            rightLegends.setPlan2canvasTrafo(trafo);
        }
        this.addFrameAndLegends(view, leftLegends, rightLegends, frame, Transformation.createTransformation((Rectangle)planRect, (Rectangle)finalPlanRectangle));
        return view;
    }

    private void addFrameAndLegends(PVView view, PVTransformedViewPart leftLegends, PVTransformedViewPart rightLegends, PVFrameViewPart frame, TransformationAffiliate frameTransformation) {
        PVView parentView = view;
        if (frameTransformation != null) {
            parentView = new PVView();
        }
        if (leftLegends != null) {
            parentView.addChild(leftLegends);
        }
        if (rightLegends != null) {
            parentView.addChild(rightLegends);
        }
        parentView.addChild(frame);
        if (frameTransformation != null) {
            PVTransformedViewPart frameAndLegendsViewPart = new PVTransformedViewPart(parentView);
            frameAndLegendsViewPart.setPlan2canvasTrafo(frameTransformation);
            view.addChild(frameAndLegendsViewPart);
        }
    }

    public PVView getFramedPlan(PVPlanViewPart plan, PVLegendView left, PVLegendView right, FrameViewConfig config) {
        TransformationAffiliate planScaling;
        Rectangle planRect = plan.getOuterBoundsWithoutChildren();
        if (planRect == null) {
            planRect = new Rectangle(0.0, 0.0, 0.0, 0.0);
        }
        if (config.fitToWidth) {
            double desiredPlanWidth = config.width - config.frameInsets.leftInset - config.frameInsets.leftInset;
            double planScaleFactor = desiredPlanWidth / planRect.w();
            planScaling = TransformationAffiliate.newTransformationScaling((double)planScaleFactor);
        } else if (config.fitToHeight) {
            Rectangle legendsRect = left.getOuterBoundsWithoutChildren();
            legendsRect = legendsRect.union(right.getOuterBoundsWithoutChildren());
            double legendsHeight = legendsRect.h();
            double desiredHeight = config.height - (legendsHeight += legendsRect.lowerRight.y) - config.frameInsets.lowerInset - config.frameInsets.upperInset;
            double planScaleFactor = desiredHeight / planRect.h();
            planScaling = TransformationAffiliate.newTransformationScaling((double)planScaleFactor);
        } else {
            config.fitToHeight = false;
            config.fitToWidth = true;
            PVView result = this.getFramedPlan(plan, left, right, config);
            if (result.getOuterBoundsWithoutChildren().h() > config.height) {
                config.fitToHeight = true;
                config.fitToWidth = false;
                result = this.getFramedPlan(plan, left, right, config);
            }
            config.fitToHeight = true;
            config.fitToWidth = true;
            return result;
        }
        PVTransformedViewPart scaledPlan = new PVTransformedViewPart(plan);
        scaledPlan.setPlan2canvasTrafo(planScaling);
        planRect = scaledPlan.getOuterBoundsWithoutChildren();
        PVView view = this.getFrameAndLegends(planRect, left, right, config);
        view.addChild(scaledPlan);
        return view;
    }

    private double calculateExpandedFrameWidth(Rectangle frameRect, FrameViewConfig config) throws EXFittingException {
        double desiredMinimalWidth;
        double width = config.pageInfo.widthOfSinglePage();
        if (config.pageInfo.pageInsetsAreOuterBorder()) {
            width -= 0.5;
        }
        if ((desiredMinimalWidth = frameRect.w()) > width + 1.0E-10) {
            width = config.pageInfo.widthOfFirstPage() + config.pageInfo.widthOfLastPage();
            if (config.pageInfo.pageInsetsAreOuterBorder()) {
                width -= 0.5;
            }
            if (desiredMinimalWidth > width) {
                width += config.pageInfo.widthOfCenterPage();
                while (desiredMinimalWidth > width) {
                    width += config.pageInfo.widthOfCenterPage();
                }
            }
        }
        if (config.fitToWidth) {
            if (width > config.width + 1.0E-10) {
                throw new EXFittingException();
            }
            width = config.width;
        }
        return width;
    }

    private double calculateExpandedFrameHeight(Rectangle frameRect, FrameViewConfig config) throws EXFittingException {
        double desiredMinimalHeight;
        double height = config.pageInfo.heightOfSinglePage();
        if (config.pageInfo.pageInsetsAreOuterBorder()) {
            height -= 0.5;
        }
        if ((desiredMinimalHeight = frameRect.h()) > height + 1.0E-10) {
            height = config.pageInfo.heightOfFirstPage() + config.pageInfo.heightOfLastPage();
            if (config.pageInfo.pageInsetsAreOuterBorder()) {
                height -= 0.5;
            }
            if (desiredMinimalHeight > height) {
                height += config.pageInfo.heightOfCenterPage();
                while (desiredMinimalHeight > height) {
                    height += config.pageInfo.heightOfCenterPage();
                }
            }
        }
        if (config.fitToHeight) {
            if (height > config.height + 1.0E-10) {
                throw new EXFittingException();
            }
            height = config.height;
        }
        return height;
    }

    private Rectangle expandFrame(Rectangle frameRect, FrameViewConfig config) {
        double deltaX;
        double width = frameRect.w();
        double height = frameRect.h();
        try {
            width = this.calculateExpandedFrameWidth(frameRect, config);
            height = this.calculateExpandedFrameHeight(frameRect, config);
        }
        catch (EXFittingException e) {
            logger.error("Frame wxpansion not possible. This case should not happen (No fitting was chosen).", (Throwable)e);
        }
        double deltaY = (height - frameRect.h()) / 2.0;
        if (deltaY < 0.0) {
            logger.error("This should not happen. Error in calculation of expanded frame");
        }
        if ((deltaX = (width - frameRect.w()) / 2.0) < 0.0) {
            logger.error("This should not happen. Error in calculation of expanded frame");
        }
        return frameRect.expand(deltaX, deltaY, deltaX, deltaY);
    }

    private Rectangle expandFrameHorizontally(Rectangle frameRect, FrameViewConfig config) throws EXFittingException {
        double width = this.calculateExpandedFrameWidth(frameRect, config);
        double deltaX = (width - frameRect.w()) / 2.0;
        if (deltaX < -1.0E-10) {
            logger.error("This should not happen. Error in calculation of expanded frame");
        }
        return frameRect.expand(deltaX, 0.0, deltaX, 0.0);
    }

    private Rectangle expandFrameVertically(Rectangle frameRect, FrameViewConfig config) throws EXFittingException {
        double height = this.calculateExpandedFrameHeight(frameRect, config);
        double deltaY = (height - frameRect.h()) / 2.0;
        if (deltaY < -1.0E-10) {
            logger.error("This should not happen. Error in calculation of expanded frame");
        }
        return frameRect.expand(0.0, deltaY, 0.0, deltaY);
    }

    private static class EXFittingException
    extends Exception {
    }
}

