/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.frameview;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.java.To;
import com.arcway.planagent.planview.print.PageInfo;

public class FrameViewConfig {
    double width;
    double height;
    Insets frameInsets = new Insets(0.0);
    boolean fitToWidth = false;
    boolean fitToHeight = false;
    boolean expandFrame = false;
    double minLegendDistance = 0.0;
    PageInfo pageInfo = null;
    double zoom = 1.0;
    public static final double FRAME_LINE_WIDTH = 0.5;

    public static FrameViewConfig createFrame(Insets frameInsets, double minLegendDistance, double zoom) {
        FrameViewConfig config = new FrameViewConfig();
        config.minLegendDistance = minLegendDistance;
        config.frameInsets = frameInsets;
        config.zoom = zoom;
        return config;
    }

    public static FrameViewConfig createFrameExpandedToPageBorders(Insets frameInsets, double minLegendDistance, double zoom, PageInfo pageInfo) {
        FrameViewConfig config = FrameViewConfig.createFrame(frameInsets, minLegendDistance, zoom);
        config.expandFrame = true;
        config.pageInfo = pageInfo;
        return config;
    }

    public static FrameViewConfig createFrameWithFixedWidth(double forcedFrameWidth, boolean forcedWidthIsOuterBorder, Insets frameInsets, double minLegendDistance) {
        FrameViewConfig config = new FrameViewConfig();
        config.fitToWidth = true;
        config.width = forcedWidthIsOuterBorder ? forcedFrameWidth - 0.5 : forcedFrameWidth;
        config.frameInsets = frameInsets;
        config.minLegendDistance = minLegendDistance;
        return config;
    }

    public static FrameViewConfig createFrameWithFixedWidthExpandedToPageBorders(int numberOfPagesInXDirection, Insets minDistanceBetweenFrameAndPlan, double minLegendAreaDistance, PageInfo pageInfo) {
        double width = FrameViewConfig.calculateLength(numberOfPagesInXDirection, pageInfo.widthOfFirstPage(), pageInfo.widthOfFirstPage(), pageInfo.widthOfLastPage(), pageInfo.widthOfCenterPage());
        FrameViewConfig config = FrameViewConfig.createFrameWithFixedWidth(width, pageInfo.pageInsetsAreOuterBorder(), minDistanceBetweenFrameAndPlan, minLegendAreaDistance);
        config.expandFrame = true;
        config.pageInfo = pageInfo;
        return config;
    }

    public static FrameViewConfig createFrameWithFixedHeight(double forcedFrameHeight, boolean forcedHeightIsOuterBorder, Insets minDistanceBetweenFrameAndPlan, double minLegendAreaDistance) {
        FrameViewConfig config = new FrameViewConfig();
        config.fitToHeight = true;
        config.height = forcedHeightIsOuterBorder ? forcedFrameHeight - 0.5 : forcedFrameHeight;
        config.frameInsets = minDistanceBetweenFrameAndPlan;
        config.minLegendDistance = minLegendAreaDistance;
        return config;
    }

    public static FrameViewConfig createFrameWithFixedHeightExpandedToPageBorders(int numberOfPagesInYDirection, Insets minDistanceBetweenFrameAndPlan, double minLegendAreaDistance, PageInfo pageInfo) {
        double height = FrameViewConfig.calculateLength(numberOfPagesInYDirection, pageInfo.heightOfSinglePage(), pageInfo.heightOfFirstPage(), pageInfo.heightOfLastPage(), pageInfo.heightOfCenterPage());
        FrameViewConfig config = FrameViewConfig.createFrameWithFixedHeight(height, pageInfo.pageInsetsAreOuterBorder(), minDistanceBetweenFrameAndPlan, minLegendAreaDistance);
        config.expandFrame = true;
        config.pageInfo = pageInfo;
        return config;
    }

    public static FrameViewConfig createFrameWithFixedSize(Dimension forcedFrameDimension, boolean forcedDimensionIsOuterBorder, Insets minDistanceBetweenFrameAndPlan, double minLegendAreaDistance) {
        FrameViewConfig config = new FrameViewConfig();
        config.fitToHeight = true;
        config.fitToWidth = true;
        if (forcedDimensionIsOuterBorder) {
            config.height = forcedFrameDimension.height - 0.5;
            config.width = forcedFrameDimension.width - 0.5;
        } else {
            config.height = forcedFrameDimension.height;
            config.width = forcedFrameDimension.width;
        }
        config.frameInsets = minDistanceBetweenFrameAndPlan;
        config.minLegendDistance = minLegendAreaDistance;
        return config;
    }

    public static FrameViewConfig createFrameWithFixedSizeExpandedToPageBorders(int numberOfPagesInXDirection, int numberOfPagesInYDirection, Insets minDistanceBetweenFrameAndPlan, double minLegendAreaDistance, PageInfo pageInfo) {
        double height = FrameViewConfig.calculateLength(numberOfPagesInYDirection, pageInfo.heightOfSinglePage(), pageInfo.heightOfFirstPage(), pageInfo.heightOfLastPage(), pageInfo.heightOfCenterPage());
        double width = FrameViewConfig.calculateLength(numberOfPagesInXDirection, pageInfo.widthOfSinglePage(), pageInfo.widthOfFirstPage(), pageInfo.widthOfLastPage(), pageInfo.widthOfCenterPage());
        Dimension dimension = new Dimension(width, height);
        FrameViewConfig config = FrameViewConfig.createFrameWithFixedSize(dimension, pageInfo.pageInsetsAreOuterBorder(), minDistanceBetweenFrameAndPlan, minLegendAreaDistance);
        config.pageInfo = pageInfo;
        config.expandFrame = true;
        return config;
    }

    private static double calculateLength(int numberOfPages, double singlePage, double firstPage, double lastPage, double centerPage) {
        assert (numberOfPages > 0) : "number of Pages must be greater 0";
        double length = 0.0;
        length = numberOfPages == 1 ? singlePage : firstPage + lastPage + (double)(numberOfPages - 2) * centerPage;
        return length;
    }

    private FrameViewConfig() {
    }

    public String toString() {
        return "FrameViewConfig [width=" + this.width + ", height=" + this.height + ", frameInsets=" + To.makeNotNull((Object)this.frameInsets) + ", fitToWidth=" + this.fitToWidth + ", fitToHeight" + this.fitToHeight + ", expandFrame" + this.expandFrame + ", minLegendDistance=" + this.minLegendDistance + ", pageInfo=" + To.makeNotNull((Object)this.pageInfo) + ", zoom=" + this.zoom + "]";
    }
}

