/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.gui.view;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.gui.appearance.GUILineAndFillSupplementAppearance;
import com.arcway.planagent.planmodel.gui.appearance.IGUIAppearanceWithLineAndFillAppearanceRO;
import com.arcway.planagent.planview.view.PVGraphicalSupplement;

public class PVGraphicalSupplementGUIScrollBarGraphic
extends PVGraphicalSupplement {
    private GUILineAndFillSupplementAppearance symbolAppearance = new GUILineAndFillSupplementAppearance();

    public void setSymbolAppearance(GUILineAndFillSupplementAppearance appearance) {
        this.symbolAppearance = new GUILineAndFillSupplementAppearance((IGUIAppearanceWithLineAndFillAppearanceRO)appearance);
    }

    public void drawFigure(Device device) {
        assert (this.symbolAppearance != null) : "symbolAppearance is NULL";
        ILineAppearanceRO lineAppearance = this.symbolAppearance.getLineAppearanceRO();
        assert (lineAppearance != null) : "lineAppearance is null.";
        Color lineColor = lineAppearance.getLineColor();
        double thickness = lineAppearance.getLineThickness();
        LineStyle lineStyle = lineAppearance.getLineStyle();
        IFillAppearanceRO fillAppearance = this.symbolAppearance.getFillAppearanceRO();
        assert (fillAppearance != null) : "fillAppearance is null.";
        FillStyle fillStyle = fillAppearance.getFillStyle();
        FillColor fillColor = fillAppearance.getFillColor();
        Rectangle bounds = this.getPoints().getBounds();
        assert (bounds != null) : "bounds is NULL.";
        Point center = bounds.center();
        boolean vertical = true;
        if (bounds.w() > bounds.h()) {
            vertical = false;
            bounds = this.getPoints().turnPoints(center, 90.0).getBounds();
        }
        double width = bounds.w();
        double height = bounds.h();
        Point upperLeft = bounds.upperLeft;
        Point lowerRight = bounds.lowerRight;
        Corners corners = new Corners();
        corners.add((Point)new Corner(center.x - width * 0.3, upperLeft.y + width * 0.7, 0.0));
        corners.add((Point)new Corner(center.x, upperLeft.y + width * 0.3, 0.0));
        corners.add((Point)new Corner(center.x + width * 0.3, upperLeft.y + width * 0.7, 0.0));
        device.polygon(vertical ? corners : corners.turnCorners(center, 90.0), fillColor, fillStyle, thickness, lineColor, lineStyle);
        corners = new Corners();
        corners.add((Point)new Corner(center.x - width * 0.3, lowerRight.y - width * 0.7, 0.0));
        corners.add((Point)new Corner(center.x, lowerRight.y - width * 0.3, 0.0));
        corners.add((Point)new Corner(center.x + width * 0.3, lowerRight.y - width * 0.7, 0.0));
        device.polygon(vertical ? corners : corners.turnCorners(center, 90.0), fillColor, fillStyle, thickness, lineColor, lineStyle);
        if (height >= width * 2.0) {
            corners = new Corners();
            corners.add((Point)new Corner(upperLeft.x, upperLeft.y + width, 0.0));
            corners.add((Point)new Corner(upperLeft.x + width, upperLeft.y + width, 0.0));
            device.polyline(vertical ? corners : corners.turnCorners(center, 90.0), thickness, lineColor, lineStyle);
            corners = new Corners();
            corners.add((Point)new Corner(upperLeft.x, lowerRight.y - width, 0.0));
            corners.add((Point)new Corner(upperLeft.x + width, lowerRight.y - width, 0.0));
            device.polyline(vertical ? corners : corners.turnCorners(center, 90.0), thickness, lineColor, lineStyle);
        }
        double sliderTop = upperLeft.y + width * 1.5;
        double sliderBottom = upperLeft.y + height * 0.5;
        double sliderHeight = sliderBottom - sliderTop;
        if (sliderBottom > sliderTop) {
            corners = new Corners();
            corners.add((Point)new Corner(upperLeft.x, sliderTop, 0.0));
            corners.add((Point)new Corner(upperLeft.x + width, sliderTop, 0.0));
            device.polyline(vertical ? corners : corners.turnCorners(center, 90.0), thickness, lineColor, lineStyle);
            corners = new Corners();
            corners.add((Point)new Corner(upperLeft.x, sliderBottom, 0.0));
            corners.add((Point)new Corner(upperLeft.x + width, sliderBottom, 0.0));
            device.polyline(vertical ? corners : corners.turnCorners(center, 90.0), thickness, lineColor, lineStyle);
            if (sliderHeight > 3.0 * width * 0.1) {
                double sliderCenter = (sliderTop + sliderBottom) * 0.5;
                corners = new Corners();
                corners.add((Point)new Corner(upperLeft.x + width * 0.2, sliderCenter, 0.0));
                corners.add((Point)new Corner(upperLeft.x + width * 0.8, sliderCenter, 0.0));
                device.polyline(vertical ? corners : corners.turnCorners(center, 90.0), thickness, lineColor, lineStyle);
                corners = new Corners();
                corners.add((Point)new Corner(upperLeft.x + width * 0.2, sliderCenter + width * 0.1, 0.0));
                corners.add((Point)new Corner(upperLeft.x + width * 0.8, sliderCenter + width * 0.1, 0.0));
                device.polyline(vertical ? corners : corners.turnCorners(center, 90.0), thickness, lineColor, lineStyle);
                corners = new Corners();
                corners.add((Point)new Corner(upperLeft.x + width * 0.2, sliderCenter - width * 0.1, 0.0));
                corners.add((Point)new Corner(upperLeft.x + width * 0.8, sliderCenter - width * 0.1, 0.0));
                device.polyline(vertical ? corners : corners.turnCorners(center, 90.0), thickness, lineColor, lineStyle);
            }
        }
    }

    public Rectangle getOuterBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildrenByDrawing();
    }
}

