/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.gui.view;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.gui.appearance.GUILineAndFillSupplementAppearance;
import com.arcway.planagent.planmodel.gui.appearance.IGUIAppearanceWithLineAndFillAppearanceRO;
import com.arcway.planagent.planview.view.PVGraphicalSupplement;

public class PVGraphicalSupplementGUIProgressBarGraphic
extends PVGraphicalSupplement {
    private GUILineAndFillSupplementAppearance symbolAppearance = new GUILineAndFillSupplementAppearance();
    private static final double SINGLE_BAR_WIDTH = 1.5;
    private static final double SINGLE_BAR_INTERSPACE = 1.0;
    private static final double SINGLE_BAR_BORDER_DISTANCE = 1.0;

    public void setSymbolAppearance(GUILineAndFillSupplementAppearance appearance) {
        this.symbolAppearance = new GUILineAndFillSupplementAppearance((IGUIAppearanceWithLineAndFillAppearanceRO)appearance);
    }

    public void drawFigure(Device device) {
        assert (this.symbolAppearance != null) : "symbolAppearance is NULL";
        ILineAppearanceRO lineAppearance = this.symbolAppearance.getLineAppearanceRO();
        assert (lineAppearance != null) : "lineAppearance is null.";
        Color lineColor = lineAppearance.getLineColor();
        double thickness = lineAppearance.getLineThickness();
        LineStyle lineStyle = lineAppearance.getLineStyle();
        IFillAppearanceRO fillAppearance = this.symbolAppearance.getFillAppearanceRO();
        assert (fillAppearance != null) : "fillAppearance is null.";
        FillStyle fillStyle = fillAppearance.getFillStyle();
        FillColor fillColor = new FillColor(lineColor);
        Rectangle bounds = this.getPoints().getBounds();
        assert (bounds != null) : "bounds is NULL.";
        Point center = bounds.center();
        boolean horizontal = true;
        if (bounds.w() < bounds.h()) {
            horizontal = false;
            bounds = this.getPoints().turnPoints(center, 90.0).getBounds();
        }
        double width = bounds.w();
        Point upperLeft = bounds.upperLeft;
        Point lowerRight = bounds.lowerRight;
        double position = upperLeft.x + 1.0;
        double upperBarPoint = upperLeft.y + 1.0;
        double lowerBarPoint = lowerRight.y - 1.0;
        double limit = position + width * 0.33;
        while (position < limit) {
            Corners corners = new Corners();
            corners.add((Point)new Corner(position, upperBarPoint, 0.0));
            corners.add((Point)new Corner(position, lowerBarPoint, 0.0));
            corners.add((Point)new Corner(position += 1.5, lowerBarPoint, 0.0));
            corners.add((Point)new Corner(position, upperBarPoint, 0.0));
            position += 1.0;
            device.polygon(horizontal ? corners : corners.turnCorners(center, 90.0), fillColor, fillStyle, thickness, lineColor, lineStyle);
        }
    }

    public Rectangle getOuterBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildrenByDrawing();
    }
}

