/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.cm.view;

import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planview.cm.view.PVGraphicalSupplementText;

public class PVGraphicalSupplementPlaneText
extends PVGraphicalSupplementText {
    private LineAppearance lineAppearance;
    private FillAppearance fillAppearance;

    public void setLineAppearance(ILineAppearance lineAppearance) {
        this.lineAppearance = new LineAppearance((ILineAppearanceRO)lineAppearance);
    }

    public void setFillAppearance(IFillAppearance fillAppearance) {
        this.fillAppearance = new FillAppearance((IFillAppearanceRO)fillAppearance);
    }

    public Rectangle getOuterBoundsWithoutChildren() {
        Rectangle boundsWithoutLine = super.getOuterBoundsWithoutChildren();
        LineStyle lineStyle = this.lineAppearance.getLineStyle();
        Rectangle boundsWithLine = boundsWithoutLine == null || lineStyle == LineStyle.NONE ? boundsWithoutLine : boundsWithoutLine.expand(lineStyle.getWidthFactor() * this.lineAppearance.getLineThickness());
        return boundsWithLine;
    }

    @Override
    public void drawFigure(Device device) {
        if (this.getOutlineLineAppearance().getLineStyle() == LineStyle.NONE) {
            Corners corners = new Corners(this.getPoints(), 0.0);
            Polygon polygon = new Polygon(corners, true);
            Color lineColor = this.lineAppearance.getLineColor();
            LineStyle lineStyle = this.lineAppearance.getLineStyle();
            double lineThickness = this.lineAppearance.getLineThickness();
            FillStyle fillStyle = this.fillAppearance.getFillStyle();
            FillColor fillColor = this.fillAppearance.getFillColor();
            if (fillStyle != FillStyle.NONE) {
                device.polygon(polygon, fillColor, fillStyle);
            }
            if (lineStyle != LineStyle.NONE) {
                device.polygon(polygon, lineThickness, lineColor, lineStyle);
            }
        }
        super.drawFigure(device);
    }
}

