/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.cm.view;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.cm.appearance.DotsAppearance;
import com.arcway.planagent.planmodel.cm.appearance.IDotsAppearance;
import com.arcway.planagent.planmodel.cm.appearance.IDotsAppearanceRO;
import com.arcway.planagent.planview.view.PVGraphicalSupplement;

public class PVGraphicalSupplementDots
extends PVGraphicalSupplement {
    private DotsAppearance dotsAppearance;

    public void setDotsAppearance(IDotsAppearance dotsAppearance) {
        this.dotsAppearance = new DotsAppearance((IDotsAppearanceRO)dotsAppearance);
    }

    public void drawFigure(Device device) {
        double startSizeScalingAtDistance;
        double size = this.dotsAppearance.getSize();
        Color color = this.dotsAppearance.getColor();
        double distance = this.dotsAppearance.getDistance();
        Points points = this.getPoints();
        Point start = points.get(0);
        Point end = points.get(points.size() - 1);
        Point second_dot = new Point((start.x + end.x) / 2.0, (start.y + end.y) / 2.0);
        GeoVector startToEnd = new GeoVector(start, end);
        GeoVector secondToThird = startToEnd.abs() < 1.0E-10 ? GeoVector.NULL : (startToEnd.abs() < 4.0 * distance ? startToEnd.scaleToLength(startToEnd.abs() / 4.0) : startToEnd.scaleToLength(distance));
        distance = secondToThird.abs();
        if (size > 1.0E-10 && distance < (startSizeScalingAtDistance = size * 2.0)) {
            size *= distance / startSizeScalingAtDistance;
        }
        Point first_dot = second_dot.movePoint(secondToThird.turn180());
        Point third_dot = second_dot.movePoint(secondToThird);
        Corners first_corner = new Corners();
        Corners second_corner = new Corners();
        Corners third_corner = new Corners();
        first_corner.add((Point)new Corner(first_dot, 0.0));
        second_corner.add((Point)new Corner(second_dot, 0.0));
        third_corner.add((Point)new Corner(third_dot, 0.0));
        LineStyle lineStyle = LineStyle.SOLID;
        this.drawGhostOutline(device);
        device.polyline(first_corner, size, color, lineStyle);
        device.polyline(second_corner, size, color, lineStyle);
        device.polyline(third_corner, size, color, lineStyle);
    }

    public Rectangle getOuterBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildrenByDrawing();
    }
}

