/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.ACMovePlanElementStructure;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.Collection;
import java.util.List;

public class TAMovePlanElementStructure
extends Transaction {
    private final List planElements;
    private final GeoVector distance;

    public TAMovePlanElementStructure(List planElements, GeoVector distance, ActionParameters actionParameters) {
        super(((IPMPlanElementRW)planElements.get(0)).getPlanRW(), actionParameters);
        assert (distance != null) : "distance is null";
        this.planElements = planElements;
        this.distance = distance;
    }

    @Override
    public ActionIterator getActionIterator() {
        PredeterminedActionIterator moveActions = new PredeterminedActionIterator(1);
        moveActions.addAction(new ACMovePlanElementStructure(this.getActionContext(), this.planElements, this.distance, true));
        return moveActions;
    }

    @Override
    protected Collection<? extends IPMPlanModelObjectRW> getPrimarilyChangedPlanModelObjects() {
        return this.planElements;
    }

    public String toString() {
        return "TAMovePlanElementStructure (Plan element list " + this.planElements + ")";
    }
}

