/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.Collection;
import java.util.Collections;

public class TAMoveLine
extends Transaction {
    private final GeoVector distance;

    public TAMoveLine(IPMLineRO line, ActionParameters actionParameters, GeoVector distance) {
        super((IPMLineRW)((Object)line), actionParameters);
        assert (distance != null) : "distance object is null";
        this.distance = distance;
    }

    @Override
    public ActionIterator getActionIterator() {
        IPMLineRW lineToMove = (IPMLineRW)this.getTransactionRoot();
        PredeterminedActionIterator moveActionIterator = new PredeterminedActionIterator();
        Action moveLineAction = ActionFactory.createACMoveLine(this.getActionContext(), lineToMove, this.distance, false);
        moveActionIterator.addAction(moveLineAction);
        return moveActionIterator;
    }

    @Override
    protected Collection<? extends IPMPlanModelObjectRW> getPrimarilyChangedPlanModelObjects() {
        IPMLineRW lineToMove = (IPMLineRW)this.getTransactionRoot();
        return Collections.singleton(lineToMove.getPointListRW());
    }

    public String toString() {
        return "TAMoveLine ()";
    }
}

