/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACRemove1Point;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TADelete2Points
extends PredeterminedLengthTransaction {
    private static final int STEPS = 3;
    private final IPMPointRW pointBetween;

    public TADelete2Points(IPMPointRO pointBetween, ActionParameters actionParameters) {
        super(3, (IPMPlanModelObjectRW)((Object)pointBetween), actionParameters);
        this.pointBetween = (IPMPointRW)((Object)pointBetween);
        assert (this.pointBetween.getLine1stRW() != null && this.pointBetween.getLine2ndRW() != null) : "pointBetween is an endpoint!";
    }

    @Override
    public Action createAction(int n, ArrayList<Action> previousActions) {
        Action nextAction = null;
        switch (n) {
            case 0: {
                Point oldPosition = this.pointBetween.getPosition();
                Point newPosition1st = this.pointBetween.getLine1stRW().getPoint1stRW().getPosition();
                Point newPosition2nd = this.pointBetween.getLine2ndRW().getPoint2ndRW().getPosition();
                double newPositionX = Geo.equals((double)oldPosition.x, (double)newPosition1st.x) ? newPosition2nd.x : newPosition1st.x;
                double newPositionY = Geo.equals((double)oldPosition.y, (double)newPosition1st.y) ? newPosition2nd.y : newPosition1st.y;
                Point newPosition = new Point(newPositionX, newPositionY);
                GeoVector distance = new GeoVector(oldPosition, newPosition);
                nextAction = ActionFactory.createACMovePoint(this.getActionContext(), this.pointBetween, distance, true);
                break;
            }
            case 1: {
                nextAction = new ACRemove1Point(this.getActionContext(), this.pointBetween.getLine1stRW().getPoint1stRW(), this.pointBetween.getLine1stRW());
                break;
            }
            case 2: {
                nextAction = new ACRemove1Point(this.getActionContext(), this.pointBetween.getLine2ndRW().getPoint2ndRW(), this.pointBetween.getLine2ndRW());
            }
        }
        return nextAction;
    }

    public String toString() {
        return "TADelete2Points ()";
    }
}

