/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACRemove1Point;
import com.arcway.planagent.planmodel.actions.ACSetLineForce;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TADelete1Point
extends PredeterminedLengthTransaction {
    private static final int STEPS = 4;
    private final IPMPointRW pointToRemove;

    public TADelete1Point(IPMPointRO pointToRemove, ActionParameters actionParameters) {
        super(4, (IPMPlanModelObjectRW)((Object)pointToRemove), actionParameters);
        this.pointToRemove = (IPMPointRW)((Object)pointToRemove);
        assert (this.pointToRemove.getLine1stRW() != null && this.pointToRemove.getLine2ndRW() != null) : "endPoint is an endpoint!";
    }

    public Action createAction(int n, ArrayList previousActions) {
        Action nextAction = null;
        switch (n) {
            case 0: {
                nextAction = new ACSetLineForce(this.getActionContext(), this.pointToRemove.getLine1stRW(), 1);
                break;
            }
            case 1: {
                nextAction = new ACSetLineForce(this.getActionContext(), this.pointToRemove.getLine2ndRW(), 1);
                break;
            }
            case 2: {
                IPMPointRW targetPoint = this.pointToRemove.getLine2ndRW().getPoint1stRW();
                GeoVector distance = new GeoVector(this.pointToRemove.getPosition(), targetPoint.getPosition());
                nextAction = ActionFactory.createACMovePoint(this.getActionContext(), this.pointToRemove, distance, true);
                break;
            }
            case 3: {
                nextAction = new ACRemove1Point(this.getActionContext(), this.pointToRemove, this.pointToRemove.getLine2ndRW());
            }
        }
        return nextAction;
    }

    public String toString() {
        return "TADelete1Point ()";
    }
}

